#include "DialogSelect.h"

#define Inherited DialogSelectData

DialogSelect::DialogSelect(QWidget* parent,	QString table, const char* name)
	:	Inherited( parent, name )
	{
	setCaption("Select wizard");
	from->setText(table);
	}

DialogSelect::~DialogSelect(void)
	{
	}

QString DialogSelect::getQuery(void)
	{
	QString select = this->select->text();
	QString from = this->from->text();
	QString where = this->where->text();
	QString having = this->having->text();
	QString groupby = this->groupby->text();
	QString orderby = this->orderby->text();
	QString query;
	query += "SELECT " + select;
	query += " FROM " + from;
	if(!where.isEmpty())
		query += " WHERE " + where;
	if(!having.isEmpty())
		query += " HAVING " + having;
	if(!groupby.isEmpty())
		query += " GROUP BY " + groupby;
	if(!orderby.isEmpty())
		query += " ORDER BY " + orderby;
	return query;
	}