#include "utils.h"

	
QString Utils::subStringAt(QString str, char separator, unsigned int index)
	{
	if(str.isEmpty())
		return "";
	int begin = 0;
	int end = 0;
	for(unsigned int i = 0; i<index; i++)
		{
		begin = str.find(separator, begin);
		if(begin == -1)
			return "";
		begin++;
		}
	end = str.find(separator, begin);
	if(end == -1)
		end = str.length();
	QString res = str.mid(begin, end-begin);	
	return res.stripWhiteSpace();
	}
	
QString Utils::insertQuotes(QString str)
	{
	QString res;
	for(unsigned int i=0; i<str.length(); i++)
		{
		if(str[i] == '\'')
			res += "\\'";
		else
			res += str[i];
		}
	return res;
	}


void Utils::Option::clear(void)
	{
	params.clear();
	name = "";
	}
	

bool Utils::Option::fromString(QString str)
	{
	clear();
	int len = str.length();
	int pos = 0;
	QString s;
	while(pos < len && str[pos] != '(')
		{
		s += str[pos];
		pos++;
		}
	name = s;
	s = "";
	if(pos==len)
		return true;
	pos++;
	for(;;)
		{
		if(pos == len)
			return false;
		char c = str[pos];
		if(c == ',')
			{
			params.append(s);
			s = "";
			}
		else if(c == ')')
			{
			params.append(s);
			return true;
			}
		else
			s += c;
		pos++;
		}
	return true;
	}
	
	
QString Utils::Option::toString(void)
	{
	QString res = name;
	unsigned int count = getParamCount();
	if(count == 0)
		return res;
	res += '(';
	for(unsigned int i=0; i<count; i++)
		{
		res += getParam(i);
		if(i!=count-1)
			res += ',';
		}
	res += ')';
	return res;
	}	
	
	
QString Utils::Option::getName(void)
	{
	return name;
	}
	
unsigned int Utils::Option::getParamCount(void)
	{
	return params.count();
	}
	
QString Utils::Option::getParam(unsigned int index)
	{
	return params.at(index);
	}
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	


