#include <qapp.h>
#include <qmenubar.h>
#include <qpopmenu.h>
#include <qmsgbox.h>
#include <qcombo.h>
#include <qstrlist.h>
#include <qlist.h>
#include <qstring.h>
#include <qprinter.h>

#include <kapp.h>
#include <kcombo.h>
#include <kmsgbox.h>
#include <kpopmenu.h>
#include <kmenubar.h>
#include <kmsgbox.h>
#include <kfiledialog.h>
#include <kstatusbar.h>
#include <ktmainwindow.h>
#include <kiconloader.h>
#include <kmsgbox.h>

#include "ISqlServer.h"
#include "MainFrame.h"
#include "Common.h"
#include "DialogPref.h"
#include "DialogSelectBase.h"
#include "DialogFormEditor.h"
#include "FormDialog.h"
#include "DialogCreateTable.h"
#include "DialogInput.h"
#include "DialogAddServer.h"
#include "DialogSelect.h"
#include "Connection.h"
#include "pluginmanager.h"
#include "DialogModules.h"
#include "querywizard.h"

/**
   This represents an item of the menu containing forms.
**/
struct FormMenuItem
  {
  int id;
  int delid;
  QString filename;
  };

class MainWindow : public KTMainWindow
  {
    Q_OBJECT
  public:
    MainWindow(const char * =0);
    ~MainWindow(void);
  protected:
    virtual void closeEvent(QCloseEvent *);
  private slots:
    void menuNewWindow();
    void menuConnect();
    void menuClose();
    void menuSelectBase();
    void menuPref();
    void menuModules();
    void menuSavePref();
    void menuPrint();
    void menuQuit();
    void menuRemoveRow();
    void menuClear();
    void menuFitAll();
    void menuShowTables();
    void menuCreateTable();
    void menuAlterTable();
    void menuDropTable();
    void menuFormEditor();
    void menuRunForm();
    void menuAddForm();
    void menuTableSelect();
    void menuTableSelectAll();
    void menuBaseNewForm();
    void menuShowFields();
    void menuDeleteBase();
    void menuCreateBase();
    void menuRemoveServer();
    void menuAddServer();
    void menuShutdownServer();
    void menuReloadServer();
    void menuServerInfo();
    void menuSelect();
    void menuFormsActivated(int);
    void menuDelformsActivated(int);
    void menuQueryWizard();
    void menuFormExecute();
    void menuFormEdit();
    void menuFormDelete();
    void historyActivated(int);
    void go();
  private:
    void commonInit(void);
    int readPref(void);
    int savePref(void);
    int newQuery(const char *);
    void updateWithPrefs(void);
    int addConnection(Connection *);
    int removeConnection(Connection *);
    int updateTree(void);
    int updateTree(Connection *);
    void addHistory(QString);
    ISqlServer *currentServer(void);
    Connection *currentConnection(void);
    Connection *connectionByName(QString);
    QString currentBase(void);
    QString currentTable(void);
    QString currentForm(void);
    bool prepareBaseForForms(QString);
    bool isBasePreparedForForms(QString);
  private:
    KStatusBar *status;
    QMultiLineEdit *edit;
    QListBox *history;
    TabView *tab;
    ServerTree *treeView;
    QPopupMenu *fichier;
    QPopupMenu *forms;
    QPopupMenu *delforms;
    QPopupMenu *edition;
    QPopupMenu *base;
    KMenuBar *menu;
    //QString currentBase;
    int tableId;
    int editionId;
    QPushButton *btn_go;
    int connect_id, close_id, select_id, pref_id;
    QList<FormMenuItem> formMenuItems;
    static Pref pref;
    static bool initialized;
    static QList<MainWindow> windows;
    static QList<Connection> connections;
    static PluginManager *pluginManager;
  };





















