#include "DialogBaseList.h"

#define Inherited DialogBaseListData

DialogBaseList::DialogBaseList(QWidget* parent, const char* name)
	: Inherited( parent, name )
  {
  setCaption("Base list");
  connect(btn_ok, SIGNAL(clicked()), SLOT(ok()));
  connect(btn_cancel, SIGNAL(clicked()), SLOT(cancel()));
  refreshList();
  }


DialogBaseList::~DialogBaseList()
  {
  }

void DialogBaseList::ok(void)
  {
  if(list->currentItem()==-1)
    QMessageBox::information(this, "Error", "Please select an item");
  else
    {
    result = list->text(list->currentItem());
    done(1);
    }
  }

void DialogBaseList::cancel(void)
  {
  done(0);
  }

void DialogBaseList::refreshList(void)
  {
  // Nafruh
  }

const char *DialogBaseList::getResult(void)
  {
  return result;
  }

void DialogBaseList::setBaseList(QStrList bl)
  {
  baselist = bl;
  for(char *str = baselist.first(); str != 0; str = baselist.next())
    {
    //warning("%s", str);
    list->insertItem(str);
    }
  }
