/*
** Copyright (c) 1998 by Timothy Gerard Endres
** <mailto:time@ice.com>  <http://www.ice.com>
** 
** This program is free software.
** 
** You may redistribute it and/or modify it under the terms of the GNU
** General Public License as published by the Free Software Foundation.
** Version 2 of the license should be included with this distribution in
** the file LICENSE, as well as License.html. If the license is not
** included	with this distribution, you may find a copy at the FSF web
** site at 'www.gnu.org' or 'www.fsf.org', or you may write to the
** Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139 USA.
**
** THIS SOFTWARE IS PROVIDED AS-IS WITHOUT WARRANTY OF ANY KIND,
** NOT EVEN THE IMPLIED WARRANTY OF MERCHANTABILITY. THE AUTHOR
** OF THIS SOFTWARE, ASSUMES _NO_ RESPONSIBILITY FOR ANY
** CONSEQUENCE RESULTING FROM THE USE, MODIFICATION, OR
** REDISTRIBUTION OF THIS SOFTWARE. 
** 
*/

package com.ice.sqlclient;

import java.lang.*;
import java.util.*;
import java.sql.*;


public abstract class
SQLClientHandler extends Object
	{
	private static final boolean		TRACE_DRIVER = false;

	private static Hashtable			handlers;
	private static SQLClientHandler		currentHandler;

	protected String		name;
	protected boolean		isOpen;
	protected int			port;


	static
		{
		if ( SQLClientHandler.TRACE_DRIVER )
			{
			DriverManager.setLogStream( System.err );
			}

		SQLClientHandler.handlers = new Hashtable();

		SQLClientHandler.currentHandler = null;
		}

	public static SQLClientHandler
	getCurrentHandler()
		{
		return SQLClientHandler.currentHandler;
		}

	public static void
	setCurrentHandler( SQLClientHandler handler )
		{
		SQLClientHandler.currentHandler = handler;
		}

	public static void
	addHandler( SQLClientHandler handler )
		{
		SQLClientHandler.handlers.put
			( handler.getName(), handler );
		}

	public static SQLClientHandler
	getHandler( String name )
		{
		return (SQLClientHandler)
			SQLClientHandler.handlers.get( name );
		}

	public static String[]
	getAllHandlerNames()
		{
		String[] result =
			new String[ SQLClientHandler.handlers.size() ];

		Enumeration enum =
			SQLClientHandler.handlers.keys();

		for ( int i = 0 ; enum.hasMoreElements() ; )
			{
			result[i++] = (String) enum.nextElement();
			}

		return result;
		}

	public
	SQLClientHandler( String name )
		{
		this.isOpen = false;

		this.name = name;

		SQLClientHandler.handlers.put( name, this );
		}

	public String
	getName()
		{
		return this.name;
		}

	public boolean
	isOpen()
		{
		return this.isOpen;
		}

	abstract public void
		setConnectInfo
			( String host, String port,
				String name, String pass, String database );

	abstract public void
		openConnection()
		throws SQLException;

	abstract public void
		closeConnection();

	abstract public DatabaseMetaData
		getMetaData()
		throws SQLException;

	abstract public void
		setCurrentDatabase( String dbName )
		throws SQLException;

	abstract public boolean
		performSQLCommand( String command )
		throws SQLException;

	abstract public String
		performSQLQuery( String query )
		throws SQLException;

	abstract public JDBCAdapter
		performTableSQLQuery( String query )
		throws SQLException;

	abstract public int
		performSQLUpdate( String update )
		throws SQLException;

	abstract public String[]
		getDatabaseList()
		throws SQLException;

	abstract public String[]
		getDatabaseTableList()
		throws SQLException;

	abstract public JDBCAdapter
		getDatabaseTableInfo()
		throws SQLException;

	abstract public JDBCAdapter
		getTableColumnInfo( String tableNamePattern )
		throws SQLException;

	abstract public void
		flushAllCaches();

	abstract public void
		flushTableCaches();

	abstract public int
		formatResults( ResultSet rs, StringBuffer buf, String sep )
		throws SQLException;
	}

