/*
** Copyright (c) 1998 by Timothy Gerard Endres
** <mailto:time@ice.com>  <http://www.ice.com>
** 
** This program is free software.
** 
** You may redistribute it and/or modify it under the terms of the GNU
** General Public License as published by the Free Software Foundation.
** Version 2 of the license should be included with this distribution in
** the file LICENSE, as well as License.html. If the license is not
** included	with this distribution, you may find a copy at the FSF web
** site at 'www.gnu.org' or 'www.fsf.org', or you may write to the
** Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139 USA.
**
** THIS SOFTWARE IS PROVIDED AS-IS WITHOUT WARRANTY OF ANY KIND,
** NOT EVEN THE IMPLIED WARRANTY OF MERCHANTABILITY. THE AUTHOR
** OF THIS SOFTWARE, ASSUMES _NO_ RESPONSIBILITY FOR ANY
** CONSEQUENCE RESULTING FROM THE USE, MODIFICATION, OR
** REDISTRIBUTION OF THIS SOFTWARE. 
** 
*/

package com.ice.sqlclient;

import java.sql.*;
import java.awt.*;
import java.awt.event.*;
import com.sun.java.swing.*;
import com.sun.java.swing.event.*;
import com.sun.java.swing.table.*;

import com.ice.util.AWTUtilities;


public class
QueryTablePanel extends JPanel
		implements ActionListener
	{
	private JTextArea		queryText;
	private JButton			queryButton;

	private JPanel			queryPanel;
	private JPanel			resultPanel;
	private JSplitPane		splitPane;

	private JTable			resultTable;
	private MySQLAdapter	sqlAdapter;
	private JScrollPane		scroller;


	public
	QueryTablePanel()
		{
		this.setDoubleBuffered( true );
		this.establishContents();
		}

	public void
	actionPerformed( ActionEvent event )
		{
		String command = event.getActionCommand();

		if ( command.equals( "QUERY" ) )
			{
			String qText = this.queryText.getText();
			
			SQLClientHandler handler =
				SQLClientHandler.getCurrentHandler();

			if ( handler == null )
				{
				ErrMsgAdapter msgTable =
					new ErrMsgAdapter
						( "INTERNAL ERROR: current handler is null." );
				this.setTableModel( msgTable );
				return;
				}

			if ( ! handler.isOpen() )
				{
				ErrMsgAdapter msgTable =
					new ErrMsgAdapter
						( "INTERNAL ERROR: connection is not open." );
				this.setTableModel( msgTable );
				return;
				}

			try {
				this.sqlAdapter = (MySQLAdapter)
					handler.performTableSQLQuery( qText + "\n" );

				this.setTableModel( this.sqlAdapter );
/*
				int count = this.sqlAdapter.getColumnCount();
				for ( int c = 0 ; c < count ; ++c )
					{
					String colName =
						this.sqlAdapter.getColumnName( c );

					TableColumn tblColumn =
						this.resultTable.getColumn( colName );

					if ( tblColumn != null )
						{
						tblColumn.setWidth(75);
						tblColumn.setMinWidth(25);
						tblColumn.setMaxWidth(150);
						}
					}
*/
				}
			catch ( SQLException ex )
				{
				String msg =
					"SQLException: performing query\n"
						+ ex.getMessage();
				ErrMsgAdapter msgTable = new ErrMsgAdapter( msg );
				this.setTableModel( msgTable );
				}
			}
		else
			{
			ErrMsgAdapter msgTable =
				new ErrMsgAdapter
					( "INTERNAL ERROR: unknown command: " + command );
			this.setTableModel( msgTable );
			}
		}

	private void
	setTableModel( TableModel model )
		{
		if ( model instanceof ErrMsgAdapter )
			{
			this.resultTable.setAutoResizeMode
				( JTable.AUTO_RESIZE_ALL_COLUMNS );
			}
		else
			{
			this.resultTable.setAutoResizeMode
				( JTable.AUTO_RESIZE_OFF );
			}

		this.resultTable.setModel( model );
		
		this.resultTable.tableChanged
			( new TableModelEvent
				( model, TableModelEvent.HEADER_ROW ) );
		}

	private void 
	establishContents()
		{
		JLabel	lbl;
		int		row = 0;

		this.setLayout( new BorderLayout() );

		this.queryPanel = new JPanel();
		this.queryPanel.setLayout( new GridBagLayout() );
		this.queryPanel.setPreferredSize( new Dimension(450, 125) );

		lbl = new JLabel( "Query:" );
		AWTUtilities.constrain(
			this.queryPanel, lbl,
			GridBagConstraints.NONE,
			GridBagConstraints.WEST,
			0, row, 2, 1, 0.0, 0.0 );

		++row;

		this.queryText = new JTextArea();
		scroller = new JScrollPane();
		scroller.getViewport().add( this.queryText );
		AWTUtilities.constrain(
			this.queryPanel, scroller,
			GridBagConstraints.BOTH,
			GridBagConstraints.CENTER,
			0, row, 2, 1, 1.0, 1.0 );

		++row;
		
		this.queryButton =
			new JButton( "Perform Query" );
		this.queryButton.setActionCommand( "QUERY" );
		this.queryButton.addActionListener( this );
		AWTUtilities.constrain(
			this.queryPanel, this.queryButton,
			GridBagConstraints.HORIZONTAL,
			GridBagConstraints.CENTER,
			0, row, 2, 1, 1.0, 0.0 );
		
		this.resultPanel = new JPanel();
		this.resultPanel.setLayout( new GridBagLayout() );

		row = 0;

		lbl = new JLabel( "Result:" );
		AWTUtilities.constrain(
			this.resultPanel, lbl,
			GridBagConstraints.NONE,
			GridBagConstraints.WEST,
			0, row, 1, 1, 0.0, 0.0 );

		++row;

		this.sqlAdapter =
			new MySQLAdapter( null );

		this.resultTable =
			new JTable( this.sqlAdapter );

		this.resultTable.setAutoResizeMode
			( JTable.AUTO_RESIZE_OFF );

        this.scroller =
			JTable.createScrollPaneForTable
				( this.resultTable );

		this.scroller.setMinimumSize
			( new Dimension( 250, 50 ) );

		this.scroller.setVerticalScrollBarPolicy
			( ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS );

		this.scroller.setHorizontalScrollBarPolicy
			( ScrollPaneConstants.HORIZONTAL_SCROLLBAR_ALWAYS );

		AWTUtilities.constrain(
			this.resultPanel, scroller,
			GridBagConstraints.BOTH,
			GridBagConstraints.CENTER,
			0, row, 1, 1, 1.0, 1.0 );

		++row;

		
		this.splitPane =
			new JSplitPane
				( JSplitPane.VERTICAL_SPLIT,
					this.queryPanel, this.resultPanel );
		
		this.splitPane.setContinuousLayout( true );

		this.add( this.splitPane, BorderLayout.CENTER );
		}

	}


