/*
 * Decompiled with CFR 0.152.
 */
package com.ice.util;

import com.ice.util.ICETracer;
import com.ice.util.ResourceUtilities;
import com.ice.util.StringUtilities;
import java.awt.Color;
import java.awt.Font;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Vector;

public abstract class UserProperties {
    private static final String PREFIX_PROPERTY = "propertyPrefix";
    private static final String DEFAULTS_RSRC_NAME = ".com.ice.global.defaultsResource.";
    private static final String GLOBAL_RSRCLIST_NAME = ".com.ice.global.propertyResourceList";
    private static final String GLOBAL_RSRC_PREFIX = ".com.ice.global.propertyResource.";
    private static final String APP_RSRCLIST_NAME = ".com.ice.local.propertyResourceList";
    private static final String APP_RSRC_PREFIX = ".com.ice.local.propertyResource.";
    private static final String LOCAL_PROPERTY = "global.localPropertyFile";
    private static final String LOCAL_DEFAULT = null;
    private static final String DYNAMIC_PROPERTY_VERSION = "1.0";
    private static boolean debug = false;
    private static boolean verbose = false;
    private static String osname;
    private static String userName;
    private static String userHome;
    private static String prefix;
    private static String osSuffix;
    private static String userSuffix;
    private static String defaultsResource;
    private static String localPropertyFile;
    private static Hashtable dynKeysTable;
    private static Hashtable dynPathTable;
    private static Properties workingProps;

    public static String getOSName() {
        return osname;
    }

    public static String getUserHome() {
        return userHome;
    }

    public static String getUserName() {
        return userName;
    }

    public static void setDebug(boolean bl) {
        debug = bl;
    }

    public static void setVerbose(boolean bl) {
        verbose = bl;
    }

    public static void setLocalPropertyFile(String string) {
        localPropertyFile = string;
    }

    public static void setDefaultsResource(String string) {
        defaultsResource = string;
    }

    public static void setOSSuffix(String string) {
        osSuffix = string;
    }

    public static void setUserSuffix(String string) {
        userSuffix = string;
    }

    public static void setPropertyPrefix(String string) {
        if (string.endsWith(".")) {
            prefix = string;
            return;
        }
        prefix = String.valueOf(string) + ".";
    }

    public static String getPropertyPrefix() {
        return prefix;
    }

    public static String getLineSeparator() {
        return System.getProperty("line.separator", "\n");
    }

    public static Font getFont(String string, Font font) {
        return Font.getFont(UserProperties.prefixedPropertyName(string), font);
    }

    public static Color getColor(String string, Color color) {
        return Color.getColor(UserProperties.prefixedPropertyName(string), color);
    }

    public static String prefixedPropertyName(String string) {
        return String.valueOf(prefix) + string;
    }

    public static String normalizePropertyName(String string) {
        if (string.startsWith(".")) {
            return string.substring(1);
        }
        return UserProperties.prefixedPropertyName(string);
    }

    private static String getOverridableProperty(String string, String string2) {
        String string3 = null;
        String string4 = null;
        String string5 = null;
        string5 = UserProperties.normalizePropertyName(string);
        if (string5.endsWith(".")) {
            string5 = string5.substring(0, string5.length() - 1);
            string3 = System.getProperty(string5, string2);
            if (debug) {
                System.err.println("UserProperties.getOverridableProperty: " + string5 + " = '" + string3 + "'");
            }
            return string3;
        }
        if (osSuffix != null && userSuffix != null) {
            string4 = String.valueOf(string5) + "." + osSuffix + "." + userSuffix;
            string3 = System.getProperty(string4, null);
            if (debug) {
                System.err.println("UserProperties.getOverridableProperty: " + string4 + " = '" + string3 + "'");
            }
            if (string3 != null) {
                return string3;
            }
        }
        if (userSuffix != null) {
            string4 = String.valueOf(string5) + "." + userSuffix;
            string3 = System.getProperty(string4, null);
            if (debug) {
                System.err.println("UserProperties.getOverridableProperty: " + string4 + " = '" + string3 + "'");
            }
            if (string3 != null) {
                return string3;
            }
        }
        if (osSuffix != null) {
            string4 = String.valueOf(string5) + "." + osSuffix;
            string3 = System.getProperty(string4, null);
            if (debug) {
                System.err.println("UserProperties.getOverridableProperty: " + string4 + " = '" + string3 + "'");
            }
            if (string3 != null) {
                return string3;
            }
        }
        if (string3 == null) {
            string3 = System.getProperty(string5, null);
            if (debug) {
                System.err.println("UserProperties.getOverridableProperty: " + string5 + " = '" + string3 + "'");
            }
        }
        if (string3 == null) {
            string3 = string2;
            if (debug) {
                System.err.println("UserProperties.getOverridableProperty: " + string + " defaulted to '" + string3 + "'");
            }
        }
        return string3;
    }

    public static String getProperty(String string, String string2) {
        String string3 = UserProperties.getOverridableProperty(string, string2);
        return string3;
    }

    public static int getProperty(String string, int n) {
        int n2;
        block2: {
            n2 = n;
            String string2 = UserProperties.getProperty(string, null);
            if (string2 == null) break block2;
            try {
                n2 = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                n2 = n;
            }
        }
        return n2;
    }

    public static long getProperty(String string, long l) {
        long l2;
        block2: {
            l2 = l;
            String string2 = UserProperties.getProperty(string, null);
            if (string2 == null) break block2;
            try {
                l2 = Long.parseLong(string2);
            }
            catch (NumberFormatException numberFormatException) {
                l2 = l;
            }
        }
        return l2;
    }

    public static double getProperty(String string, double d) {
        double d2;
        block2: {
            d2 = d;
            String string2 = UserProperties.getProperty(string, null);
            if (string2 == null) break block2;
            try {
                d2 = Double.valueOf(string2);
            }
            catch (NumberFormatException numberFormatException) {
                d2 = d;
            }
        }
        return d2;
    }

    public static boolean getProperty(String string, boolean bl) {
        boolean bl2 = bl;
        String string2 = UserProperties.getProperty(string, null);
        if (string2 != null) {
            if (string2.equalsIgnoreCase("T") || string2.equalsIgnoreCase("TRUE") || string2.equalsIgnoreCase("Y") || string2.equalsIgnoreCase("YES")) {
                bl2 = true;
            } else if (string2.equalsIgnoreCase("F") || string2.equalsIgnoreCase("FALSE") || string2.equalsIgnoreCase("N") || string2.equalsIgnoreCase("NO")) {
                bl2 = false;
            }
        }
        return bl2;
    }

    public static String[] getStringArray(String string, String[] stringArray) {
        String[] stringArray2 = stringArray;
        String string2 = UserProperties.getProperty(string, null);
        if (string2 != null) {
            stringArray2 = StringUtilities.splitString(string2, ":");
        }
        return stringArray2;
    }

    public static Vector getStringVector(String string, Vector vector) {
        Vector<String> vector2 = vector;
        String[] stringArray = UserProperties.getStringArray(string, null);
        if (stringArray != null) {
            vector2 = new Vector<String>();
            int n = 0;
            while (n < stringArray.length) {
                vector2.addElement(stringArray[n]);
                ++n;
            }
        }
        return vector2;
    }

    public static int getClassConstant(String string, int n) {
        int n2;
        block2: {
            int n3;
            n2 = n;
            String string2 = UserProperties.getProperty(string, null);
            if (string2 == null || (n3 = string2.lastIndexOf(".")) <= 0) break block2;
            try {
                String string3 = string2.substring(0, n3);
                String string4 = string2.substring(n3 + 1);
                Class<?> clazz = Class.forName(string3);
                Field field = clazz.getField(string4);
                n2 = field.getInt(null);
            }
            catch (Exception exception) {
                n2 = n;
                ICETracer.traceWithStack("Exception getting constant.");
            }
        }
        return n2;
    }

    public static void defaultProperties(Properties properties) {
        ((Hashtable)properties).put("com.ice.util.UserProperties.revision", "$Revision: 1.7 $");
        ((Hashtable)properties).put("copyright", "Copyright (c) by Tim Endres");
    }

    public static void includeProperties(Properties properties, Properties properties2) {
        Enumeration enumeration = ((Hashtable)properties2).keys();
        while (enumeration.hasMoreElements()) {
            String string = null;
            try {
                string = (String)enumeration.nextElement();
            }
            catch (NoSuchElementException noSuchElementException) {
                string = null;
            }
            if (string == null) continue;
            ((Hashtable)properties).put(string, ((Hashtable)properties2).get(string));
        }
    }

    public static void addDefaultProperties(Properties properties, Properties properties2) {
        UserProperties.includeProperties(properties, properties2);
    }

    private static boolean loadPropertiesStream(InputStream inputStream, Properties properties) throws IOException {
        properties.load(inputStream);
        return true;
    }

    private static void doLoadPropertiesFile(String string, Properties properties, Properties properties2) throws IOException {
        FileInputStream fileInputStream;
        try {
            fileInputStream = new FileInputStream(string);
        }
        catch (IOException iOException) {
            throw new IOException("opening property file '" + string + "' - " + iOException.getMessage());
        }
        try {
            if (properties2 != null) {
                UserProperties.loadPropertiesStream(fileInputStream, properties2);
                UserProperties.includeProperties(properties, properties2);
            } else {
                UserProperties.loadPropertiesStream(fileInputStream, properties);
            }
        }
        catch (IOException iOException) {
            throw new IOException("loading property file '" + string + "' - " + iOException.getMessage());
        }
        try {
            fileInputStream.close();
            return;
        }
        catch (IOException iOException) {
            throw new IOException("closing property file '" + string + "' - " + iOException.getMessage());
        }
    }

    private static boolean loadPropertiesFile(String string, Properties properties, Properties properties2) {
        boolean bl = true;
        if (debug) {
            System.err.println("Loading property file '" + string + "'.");
        }
        try {
            UserProperties.doLoadPropertiesFile(string, properties, properties2);
        }
        catch (IOException iOException) {
            System.err.println("ERROR " + iOException.getMessage());
            bl = false;
        }
        if (bl) {
            System.err.println("Loaded property file '" + string + "'.");
        }
        return bl;
    }

    private static void loadDynamicProperties(String string, String string2) {
        Properties properties = new Properties();
        Properties properties2 = System.getProperties();
        if (debug) {
            System.err.println("Loading  '" + string + "' protperties from '" + string2 + "'.");
        }
        try {
            UserProperties.doLoadPropertiesFile(string2, properties2, properties);
            UserProperties.addDynamicPropertyKeys(string, properties);
            System.err.println("Loaded '" + string + "' properties from '" + string2 + "'.");
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    private static boolean loadPropertiesResource(String string, Properties properties) {
        boolean bl = false;
        if (debug) {
            System.err.println("Load properties resource '" + string + "'");
        }
        try {
            InputStream inputStream = ResourceUtilities.openNamedResource(string);
            UserProperties.loadPropertiesStream(inputStream, properties);
            inputStream.close();
            bl = true;
        }
        catch (IOException iOException) {
            System.err.println("ERROR loading properties resource '" + string + "' - " + iOException.getMessage());
        }
        return bl;
    }

    private static void loadPropertyResourceList(String string, String string2, Properties properties) {
        String string3 = UserProperties.getProperty(string, null);
        if (string3 != null) {
            String[] stringArray = StringUtilities.splitString(string3, ":");
            int n = 0;
            while (stringArray != null && n < stringArray.length) {
                boolean bl;
                String string4 = String.valueOf(string2) + stringArray[n];
                String string5 = UserProperties.getProperty(string4, null);
                if (string5 != null && !(bl = UserProperties.loadPropertiesResource(string5, properties))) {
                    System.err.println("ERROR loading property resource '" + string5 + "'");
                }
                ++n;
            }
        }
    }

    public static void loadProperties(String string, Properties properties) {
        File file;
        boolean bl;
        Properties properties2;
        if (debug) {
            UserProperties.printContext(System.err);
        }
        if ((properties2 = System.getProperties()) == null) {
            return;
        }
        UserProperties.defaultProperties(properties2);
        String string2 = defaultsResource;
        if (string2 == null) {
            string2 = UserProperties.getProperty(DEFAULTS_RSRC_NAME, null);
        }
        if (debug) {
            System.err.println("Default Properties Resource '" + string2 + "'");
        }
        if (string2 != null) {
            bl = UserProperties.loadPropertiesResource(string2, properties2);
            System.err.println("Loaded " + (bl ? "the " : "no ") + "default properties.");
        }
        if (properties != null) {
            if (debug) {
                System.err.println("Adding application default properties.");
            }
            UserProperties.addDefaultProperties(properties2, properties);
        }
        String string3 = prefix;
        if (debug) {
            System.err.println("Prefix '" + string3 + "'");
        }
        if (string3 == null) {
            UserProperties.getProperty(String.valueOf(string) + "." + PREFIX_PROPERTY, null);
            if (string3 != null) {
                if (debug) {
                    System.err.println("Prefix via property '" + string3 + "'");
                }
                UserProperties.setPropertyPrefix(string3);
                if (verbose) {
                    System.err.println("Property prefix set to '" + string3 + "'");
                }
            }
        }
        UserProperties.loadPropertyResourceList(GLOBAL_RSRCLIST_NAME, GLOBAL_RSRC_PREFIX, properties2);
        UserProperties.processDynamicProperties();
        String string4 = localPropertyFile;
        if (string4 == null) {
            string4 = UserProperties.getProperty(LOCAL_PROPERTY, null);
        }
        if (debug) {
            System.err.println("Local property file '" + string4 + "'");
        }
        if (string4 != null && (file = new File(string4)).exists() && !(bl = UserProperties.loadPropertiesFile(string4, properties2, null))) {
            System.err.println("ERROR loading local property file '" + string4 + "'");
        }
        UserProperties.loadPropertyResourceList(APP_RSRCLIST_NAME, APP_RSRC_PREFIX, properties2);
    }

    private static void processDynamicProperties() {
        String string;
        String[] stringArray;
        Properties properties = System.getProperties();
        String string2 = properties.getProperty("global.dynamicPropList", null);
        if (string2 != null) {
            stringArray = StringUtilities.splitString(string2, ":");
            int n = 0;
            while (n < stringArray.length) {
                string = stringArray[n];
                String string3 = "global.dynamicPropFile." + string;
                String string4 = properties.getProperty(string3, null);
                if (string4 != null) {
                    if (string4.startsWith("~" + File.separator)) {
                        string4 = String.valueOf(properties.getProperty("user.home", "")) + string4.substring(2);
                    }
                    UserProperties.registerDynamicProperties(string, string4, new Properties());
                }
                ++n;
            }
        }
        stringArray = dynKeysTable.keys();
        while (stringArray.hasMoreElements()) {
            String string5 = (String)stringArray.nextElement();
            string = (String)dynPathTable.get(string5);
            UserProperties.loadDynamicProperties(string5, string);
        }
    }

    public static void registerDynamicProperties(String string, String string2, Properties properties) {
        dynPathTable.put(string, string2);
        UserProperties.addDynamicPropertyKeys(string, properties);
    }

    private static void addDynamicPropertyKeys(String string, Properties properties) {
        Vector<String> vector = (Vector<String>)dynKeysTable.get(string);
        if (vector == null) {
            vector = properties == null ? new Vector<String>(0) : new Vector(((Hashtable)properties).size());
            dynKeysTable.put(string, vector);
        }
        if (properties != null) {
            Enumeration enumeration = ((Hashtable)properties).keys();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                if (vector.contains(string2)) continue;
                vector.addElement(string2);
            }
        }
    }

    private static void copyDynamicProperties(String string, Properties properties) {
        String string2 = (String)dynPathTable.get(string);
        Vector vector = (Vector)dynKeysTable.get(string);
        if (vector == null || string2 == null) {
            throw new NoSuchElementException("you have not registered the dynamic property package named '" + string + "'");
        }
        Properties properties2 = System.getProperties();
        try {
            Enumeration enumeration = ((Hashtable)properties).keys();
            while (enumeration.hasMoreElements()) {
                String string3 = (String)enumeration.nextElement();
                if (string3 == null) continue;
                String string4 = UserProperties.normalizePropertyName(string3);
                ((Hashtable)properties2).put(string4, ((Hashtable)properties).get(string3));
                if (vector.contains(string4)) continue;
                vector.addElement(string4);
            }
            return;
        }
        catch (NoSuchElementException noSuchElementException) {
            return;
        }
    }

    public static void setDynamicProperties(String string, Properties properties) {
        UserProperties.copyDynamicProperties(string, properties);
    }

    public static void setDynamicProperty(String string, String string2, String string3) {
        ((Hashtable)workingProps).clear();
        ((Hashtable)workingProps).put(string2, string3);
        UserProperties.setDynamicProperties(string, workingProps);
    }

    public static void removeDynamicProperty(String string, String string2) {
        String string3 = (String)dynPathTable.get(string);
        Vector vector = (Vector)dynKeysTable.get(string);
        if (vector == null || string3 == null) {
            throw new NoSuchElementException("you have not registered the dynamic property package named '" + string + "'");
        }
        String string4 = UserProperties.normalizePropertyName(string2);
        if (vector.contains(string4)) {
            vector.removeElement(string4);
            ((Hashtable)System.getProperties()).remove(string4);
        }
    }

    public static void saveDynamicProperties(String string) throws IOException {
        String string2 = (String)dynPathTable.get(string);
        Vector vector = (Vector)dynKeysTable.get(string);
        if (vector == null || string2 == null) {
            throw new NoSuchElementException("you have not registered the dynamic property package named '" + string + "'");
        }
        Properties properties = new Properties();
        Properties properties2 = System.getProperties();
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            String string3 = (String)vector.elementAt(n2);
            ((Hashtable)properties).put(string3, ((Hashtable)properties2).get(string3));
            ++n2;
        }
        UserProperties.saveDynamicPropFile(string, string2, properties);
    }

    private static void saveDynamicPropFile(String string, String string2, Properties properties) throws IOException {
        String string3 = System.getProperty("line.separator", "\n");
        String string4 = String.valueOf(string3) + "## --------------------  W A R N I N G  -------------------- " + string3 + "#  This file is automatically generated." + string3 + "#  Any changes you make to this file will be overwritten." + string3 + "## ---------------------------------------------------------" + string3 + "#";
        FileOutputStream fileOutputStream = new FileOutputStream(string2);
        ((Hashtable)properties).put("global.dynPropVersion." + string, DYNAMIC_PROPERTY_VERSION);
        properties.save(fileOutputStream, string4);
        fileOutputStream.close();
    }

    public static void printContext(PrintStream printStream) {
        printStream.println("os.name    = '" + osname + "'");
        printStream.println("user.name  = '" + userName + "'");
        printStream.println("user.home  = '" + userHome + "'");
        printStream.println("");
        printStream.println("prefix     = '" + prefix + "'");
        printStream.println("osSuffix   = '" + osSuffix + "'");
        printStream.println("userSuffix = '" + userSuffix + "'");
        printStream.println("");
    }

    public static void printUsage(PrintStream printStream) {
        printStream.println("Properties options:");
        printStream.println("   -propDebug             -- turns on debugging of property loading");
        printStream.println("   -propVerbose           -- turns on verbose messages during loading");
        printStream.println("   -propDefaults rsrcName -- sets default properties resource name");
        printStream.println("   -propFile path         -- sets application property file path");
        printStream.println("   -propOS suffix         -- sets the os suffix");
        printStream.println("   -propUser suffix       -- sets the user suffix");
        printStream.println("   -propPrefix prefix     -- sets application property prefix");
    }

    public static String[] processOptions(String[] stringArray) {
        Vector<String> vector = new Vector<String>(stringArray.length);
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals("-propPrefix") && n + 1 < stringArray.length) {
                UserProperties.setPropertyPrefix(stringArray[++n]);
            } else if (stringArray[n].equals("-propFile") && n + 1 < stringArray.length) {
                UserProperties.setLocalPropertyFile(stringArray[++n]);
            } else if (stringArray[n].equals("-propDefaults") && n + 1 < stringArray.length) {
                UserProperties.setDefaultsResource(stringArray[++n]);
            } else if (stringArray[n].equals("-propDebug")) {
                UserProperties.setDebug(true);
            } else if (stringArray[n].equals("-propVerbose")) {
                UserProperties.setVerbose(true);
            } else if (stringArray[n].equals("-propOS") && n + 1 < stringArray.length) {
                UserProperties.setOSSuffix(stringArray[++n]);
            } else if (stringArray[n].equals("-propUser") && n + 1 < stringArray.length) {
                UserProperties.setUserSuffix(stringArray[++n]);
            } else {
                vector.addElement(stringArray[n]);
            }
            ++n;
        }
        String[] stringArray2 = new String[vector.size()];
        int n2 = 0;
        while (n2 < vector.size()) {
            stringArray2[n2] = (String)vector.elementAt(n2);
            ++n2;
        }
        return stringArray2;
    }

    static {
        prefix = null;
        defaultsResource = null;
        localPropertyFile = null;
        dynKeysTable = new Hashtable();
        dynPathTable = new Hashtable();
        workingProps = new Properties();
        osname = System.getProperty("os.name");
        userName = System.getProperty("user.name");
        userHome = System.getProperty("user.home");
        osSuffix = osname.replace(' ', '_');
        userSuffix = userName.replace(' ', '_');
    }
}

