/*
 * Decompiled with CFR 0.152.
 */
package com.ice.sqlclient;

import com.ice.sqlclient.JDBCAdapter;
import com.ice.sqlclient.MySQLAdapter;
import com.ice.sqlclient.SQLClientHandler;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class MySQLClient
extends SQLClientHandler {
    private static final String defDriverPrefix = "mysql";
    private static final String defDriverClass = "gwe.sql.gweMysqlDriver";
    private Class driverClass;
    private Connection connection = null;
    private String prefix;
    private String port = null;
    private String host = null;
    private String name = null;
    private String pass = null;
    private String database = null;
    private String[] dbListCache;
    private String[] tableListCache = null;
    private MySQLAdapter tableAdapterCache = null;
    private Hashtable columnAdapterCache = new Hashtable();

    public MySQLClient(String string) throws ClassNotFoundException {
        this(string, defDriverPrefix, defDriverClass);
    }

    public MySQLClient(String string, String string2, String string3) throws ClassNotFoundException {
        super(string);
        this.prefix = string2;
        try {
            this.driverClass = Class.forName(string3);
            return;
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.driverClass = null;
            throw classNotFoundException;
        }
    }

    public void finalize() {
        this.closeConnection();
    }

    public void flushAllCaches() {
        this.dbListCache = null;
        this.flushTableCaches();
    }

    public void flushTableCaches() {
        this.tableListCache = null;
        this.tableAdapterCache = null;
        this.columnAdapterCache = new Hashtable();
    }

    public void closeConnection() {
        if (this.isOpen() && this.connection != null) {
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                System.err.println("ERROR closing MySQL connection: " + sQLException.getMessage());
            }
        }
        this.isOpen = false;
        this.tableListCache = null;
        this.tableAdapterCache = null;
    }

    public void setConnectInfo(String string, String string2, String string3, String string4, String string5) {
        this.host = string;
        this.port = string2;
        this.name = string3;
        this.pass = string4;
        this.database = string5;
    }

    public void openConnection() throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("jdbc:");
        stringBuffer.append(this.prefix);
        stringBuffer.append("://");
        stringBuffer.append(this.host);
        if (this.port != null) {
            stringBuffer.append(":");
            stringBuffer.append(this.port);
        }
        stringBuffer.append("/");
        stringBuffer.append(this.database);
        stringBuffer.append("?user=");
        stringBuffer.append(this.name);
        if (this.pass != null) {
            stringBuffer.append(";password=");
            stringBuffer.append(this.pass);
        }
        this.openConnection(stringBuffer.toString());
    }

    private void openConnection(String string) throws SQLException {
        if (this.isOpen()) {
            throw new SQLException("connection is already open");
        }
        try {
            Object object;
            Object object2 = null;
            Enumeration<Driver> enumeration = DriverManager.getDrivers();
            while (enumeration.hasMoreElements()) {
                object = enumeration.nextElement();
                if (object.getClass() != this.driverClass) continue;
                object2 = object;
                break;
            }
            if (object2 != null) {
                object = new Properties();
                ((Hashtable)object).put("user", this.name);
                if (this.pass != null) {
                    ((Hashtable)object).put("password", this.pass);
                }
                this.connection = object2.connect(string, (Properties)object);
            }
            if (this.connection == null) {
                this.connection = DriverManager.getConnection(string);
            }
            this.isOpen = true;
            return;
        }
        catch (SQLException sQLException) {
            this.connection = null;
            throw sQLException;
        }
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        return this.connection.getMetaData();
    }

    public void setCurrentDatabase(String string) throws SQLException {
        try {
            this.performSQLCommand("use " + string);
            return;
        }
        catch (SQLException sQLException) {
            this.connection.setCatalog(string);
            return;
        }
    }

    public boolean performSQLCommand(String string) throws SQLException {
        Statement statement = this.connection.createStatement();
        boolean bl = statement.execute(string);
        statement.close();
        return bl;
    }

    public String performSQLQuery(String string) throws SQLException {
        Statement statement = this.connection.createStatement();
        ResultSet resultSet = statement.executeQuery(string);
        StringBuffer stringBuffer = new StringBuffer();
        this.formatResults(resultSet, stringBuffer);
        resultSet.close();
        statement.close();
        return stringBuffer.toString();
    }

    public JDBCAdapter performTableSQLQuery(String string) throws SQLException {
        Statement statement = this.connection.createStatement();
        ResultSet resultSet = statement.executeQuery(string);
        MySQLAdapter mySQLAdapter = new MySQLAdapter(resultSet);
        resultSet.close();
        statement.close();
        return mySQLAdapter;
    }

    public int performSQLUpdate(String string) throws SQLException {
        Statement statement = this.connection.createStatement();
        int n = statement.executeUpdate(string);
        statement.close();
        return n;
    }

    public JDBCAdapter getTableColumnInfo(String string) throws SQLException {
        MySQLAdapter mySQLAdapter = (MySQLAdapter)((Object)this.columnAdapterCache.get(string));
        if (mySQLAdapter != null) {
            return mySQLAdapter;
        }
        Statement statement = this.connection.createStatement();
        String string2 = "show columns from " + string;
        ResultSet resultSet = statement.executeQuery(string2);
        mySQLAdapter = new MySQLAdapter(resultSet);
        this.columnAdapterCache.put(string, mySQLAdapter);
        resultSet.close();
        statement.close();
        return mySQLAdapter;
    }

    public String[] getDatabaseList() throws SQLException {
        if (this.dbListCache != null) {
            return this.dbListCache;
        }
        Statement statement = this.connection.createStatement();
        String string = "show databases";
        ResultSet resultSet = statement.executeQuery(string);
        String[] stringArray = this.columnToStringList(resultSet, 1);
        resultSet.close();
        statement.close();
        this.dbListCache = stringArray;
        return stringArray;
    }

    public String[] getDatabaseTableList() throws SQLException {
        if (this.tableListCache != null) {
            return this.tableListCache;
        }
        String[] stringArray = null;
        Statement statement = this.connection.createStatement();
        String string = "show tables";
        ResultSet resultSet = statement.executeQuery(string);
        stringArray = this.columnToStringList(resultSet, 1);
        resultSet.close();
        statement.close();
        this.tableListCache = stringArray;
        return stringArray;
    }

    public JDBCAdapter getDatabaseTableInfo() throws SQLException {
        if (this.tableAdapterCache != null) {
            return this.tableAdapterCache;
        }
        MySQLAdapter mySQLAdapter = null;
        Statement statement = this.connection.createStatement();
        String string = "show tables";
        ResultSet resultSet = statement.executeQuery(string);
        mySQLAdapter = new MySQLAdapter(resultSet);
        resultSet.close();
        statement.close();
        this.tableAdapterCache = mySQLAdapter;
        return mySQLAdapter;
    }

    public int formatResults(ResultSet resultSet, StringBuffer stringBuffer) throws SQLException {
        return this.formatResults(resultSet, stringBuffer, " ");
    }

    public int formatResults(ResultSet resultSet, StringBuffer stringBuffer, String string) throws SQLException {
        int n = 0;
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n2 = resultSetMetaData.getColumnCount();
        stringBuffer.append("Result contains " + n2 + " columns.\n\n");
        boolean bl = resultSet.next();
        if (bl) {
            String string2;
            int[] nArray = new int[n2 + 1];
            int n3 = 1;
            while (n3 <= n2) {
                nArray[n3] = resultSetMetaData.getColumnDisplaySize(n3);
                if (nArray[n3] > 32) {
                    nArray[n3] = 32;
                }
                string2 = resultSetMetaData.getColumnName(n3);
                stringBuffer.append(string2);
                int n4 = nArray[n3] - string2.length();
                if (n4 > 0) {
                    stringBuffer.append(this.padChars(n4, " "));
                }
                if (n3 < n2) {
                    stringBuffer.append(string);
                }
                ++n3;
            }
            stringBuffer.append("\n");
            n3 = 1;
            while (n3 <= n2) {
                stringBuffer.append(this.padChars(nArray[n3], "-"));
                if (n3 < n2) {
                    stringBuffer.append(string);
                }
                ++n3;
            }
            stringBuffer.append("\n");
            while (bl) {
                ++n;
                n3 = 1;
                while (n3 <= n2) {
                    string2 = resultSet.getString(n3);
                    if (string2 == null) {
                        string2 = "(null)";
                    }
                    if (string2.length() > nArray[n3]) {
                        stringBuffer.append(string2.substring(0, nArray[n3] - 3));
                        stringBuffer.append("...");
                    } else {
                        stringBuffer.append(string2);
                        stringBuffer.append(this.padChars(nArray[n3] - string2.length(), " "));
                    }
                    if (n3 < n2) {
                        stringBuffer.append(string);
                    }
                    ++n3;
                }
                stringBuffer.append("\n");
                bl = resultSet.next();
            }
        }
        return n;
    }

    private String[] columnToStringList(ResultSet resultSet, int n) throws SQLException {
        String[] stringArray = new String[]{};
        Vector<String> vector = new Vector<String>();
        while (resultSet.next()) {
            String string = resultSet.getString(n);
            vector.addElement(string);
        }
        stringArray = new String[vector.size()];
        int n2 = 0;
        while (n2 < stringArray.length) {
            stringArray[n2] = (String)vector.elementAt(n2);
            ++n2;
        }
        return stringArray;
    }

    private String padChars(int n, String string) {
        StringBuffer stringBuffer = new StringBuffer(n * string.length());
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(string);
            ++n2;
        }
        return stringBuffer.toString();
    }
}

