/*
 * Decompiled with CFR 0.152.
 */
package com.ice.sqlclient;

import com.ice.sqlclient.MainFrame;
import com.ice.sqlclient.MainPanel;
import com.ice.sqlclient.SQLClientHandler;
import com.ice.util.AWTUtilities;
import com.ice.util.StringUtilities;
import com.ice.util.UserProperties;
import com.sun.java.swing.JButton;
import com.sun.java.swing.JComboBox;
import com.sun.java.swing.JLabel;
import com.sun.java.swing.JPanel;
import com.sun.java.swing.JScrollPane;
import com.sun.java.swing.JTextArea;
import com.sun.java.swing.JTextField;
import com.sun.java.swing.border.Border;
import com.sun.java.swing.border.CompoundBorder;
import com.sun.java.swing.border.EmptyBorder;
import com.sun.java.swing.border.EtchedBorder;
import com.sun.java.swing.event.ChangeEvent;
import com.sun.java.swing.event.ChangeListener;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;

public class HostInfoPanel
extends JPanel
implements ActionListener,
ChangeListener,
ItemListener {
    private static final int PROFILE_NAME = 0;
    private static final int PROFILE_HOST = 1;
    private static final int PROFILE_PORT = 2;
    private static final int PROFILE_USER = 3;
    private static final int PROFILE_PASS = 4;
    private static final int PROFILE_DB = 5;
    private static final int PROFILE_HAND = 6;
    private JTextField hostText;
    private JTextField dbText;
    private JTextField portText;
    private JTextField userText;
    private JTextField passText;
    private JTextArea statusText;
    private JComboBox profileList;
    private JComboBox handlerList;
    private JButton connButton;
    private JButton disconnButton;
    private MainPanel mainPanel;
    private Vector profileNames;
    private Hashtable profileTable;

    public HostInfoPanel(MainPanel mainPanel) {
        this.mainPanel = mainPanel;
        this.loadProfiles();
        this.setDoubleBuffered(true);
        this.establishContents();
    }

    public void stateChanged(ChangeEvent changeEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("CONNECT")) {
            boolean bl = true;
            this.clearStatusMessage();
            String string2 = (String)this.handlerList.getSelectedItem();
            SQLClientHandler sQLClientHandler = SQLClientHandler.getHandler(string2);
            if (sQLClientHandler == null) {
                this.appendStatusMessage("Could not find handler '" + string2 + "'.");
                return;
            }
            if (sQLClientHandler.isOpen()) {
                this.appendStatusMessage("Connection is already open.");
                return;
            }
            String string3 = this.portText.getText();
            String string4 = this.hostText.getText();
            String string5 = this.dbText.getText();
            String string6 = this.userText.getText();
            String string7 = this.passText.getText();
            this.appendStatusMessage("** Input Parameters:");
            this.appendStatusMessage("-- DB       '" + string5 + "'");
            this.appendStatusMessage("-- Host     '" + string4 + "'");
            this.appendStatusMessage("-- Port     '" + string3 + "'");
            this.appendStatusMessage("-- Username '" + string6 + "'");
            this.appendStatusMessage("-- Password '" + string7 + "'");
            this.appendStatusMessage("-- Handler  '" + string2 + "'");
            this.appendStatusMessage("");
            sQLClientHandler.setConnectInfo(string4, string3, string6, string7, string5);
            this.appendStatusMessage("Opening the '" + sQLClientHandler.getName() + "' connection...");
            try {
                sQLClientHandler.openConnection();
                this.appendHandlerDetails(sQLClientHandler);
                SQLClientHandler.setCurrentHandler(sQLClientHandler);
                this.mainPanel.adjustConnectedTabs(true);
                String[] stringArray = sQLClientHandler.getDatabaseList();
                MainFrame.showDatabaseMenu(stringArray, string5);
                this.connButton.setEnabled(false);
                this.disconnButton.setEnabled(true);
            }
            catch (SQLException sQLException) {
                bl = false;
                this.appendStatusMessage("SQLException: while opening connection:\n\t" + sQLException.getMessage());
            }
            if (bl) {
                this.mainPanel.dbHasChanged(string5);
                this.appendStatusMessage("The connection has been successfully estabilshed.");
                return;
            }
            this.appendStatusMessage("The connection has not been estabilshed.");
            return;
        }
        if (string.equals("DISCONNECT")) {
            MainFrame.hideDatabaseMenu();
            this.connButton.setEnabled(true);
            this.disconnButton.setEnabled(false);
            this.mainPanel.adjustConnectedTabs(false);
            this.clearStatusMessage();
            SQLClientHandler sQLClientHandler = SQLClientHandler.getCurrentHandler();
            if (sQLClientHandler == null) {
                this.appendStatusMessage("Current handler is null.");
                return;
            }
            if (!sQLClientHandler.isOpen()) {
                this.appendStatusMessage("The connection is not currently open.");
                return;
            }
            sQLClientHandler.closeConnection();
            this.appendStatusMessage("The handler was successfully closed.");
            return;
        }
        this.appendStatusMessage("INTERNAL ERROR: UNKNOWN Command '" + string + "'");
    }

    public void clearStatusMessage() {
        this.statusText.setText("");
    }

    public void setStatusMessage(String string) {
        this.statusText.setText(string);
    }

    public void appendStatusMessage(String string) {
        this.statusText.append(string);
        if (!string.endsWith("\n")) {
            this.statusText.append("\n");
        }
    }

    private void appendHandlerDetails(SQLClientHandler sQLClientHandler) {
        this.appendStatusMessage("** JDBC Driver and Datbase Information:");
        try {
            DatabaseMetaData databaseMetaData = sQLClientHandler.getMetaData();
            this.appendStatusMessage("-- URL      " + databaseMetaData.getURL());
            this.appendStatusMessage("-- Driver   " + databaseMetaData.getDriverName());
            this.appendStatusMessage("-- Version  " + databaseMetaData.getDriverVersion());
            this.appendStatusMessage("-- Database " + databaseMetaData.getDatabaseProductName());
            this.appendStatusMessage("-- Version  " + databaseMetaData.getDatabaseProductVersion());
            this.appendStatusMessage("-- ReadOnly " + (databaseMetaData.isReadOnly() ? "Yes" : "No"));
            return;
        }
        catch (SQLException sQLException) {
            this.appendStatusMessage("-- Driver does not support Database Meta Data.");
            return;
        }
    }

    private void establishContents() {
        int n = 0;
        ((Container)((Object)this)).setLayout(new GridBagLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder((Border)new CompoundBorder((Border)new EtchedBorder(0), (Border)new EmptyBorder(6, 6, 6, 6)));
        AWTUtilities.constrain((Container)((Object)this), (Component)jPanel, 2, 11, 0, 0, 1, 1, 1.0, 0.0);
        JLabel jLabel = new JLabel("Hostname:");
        AWTUtilities.constrain((Container)jPanel, (Component)jLabel, 0, 17, 0, n, 1, 1, 0.0, 0.0);
        String string = UserProperties.getProperty("sqlHostname", "");
        this.hostText = new JTextField(string);
        AWTUtilities.constrain((Container)jPanel, (Component)this.hostText, 2, 10, 1, n, 1, 1, 1.0, 0.0);
        jLabel = new JLabel("Port:");
        AWTUtilities.constrain((Container)jPanel, (Component)jLabel, 0, 17, 0, ++n, 1, 1, 0.0, 0.0);
        String string2 = UserProperties.getProperty("sqlPort", "3306");
        this.portText = new JTextField(string2);
        AWTUtilities.constrain((Container)jPanel, (Component)this.portText, 2, 10, 1, n, 1, 1, 1.0, 0.0);
        jLabel = new JLabel("Username:");
        AWTUtilities.constrain((Container)jPanel, (Component)jLabel, 0, 17, 0, ++n, 1, 1, 0.0, 0.0);
        String string3 = UserProperties.getProperty("sqlUsername", null);
        if (string3 == null) {
            string3 = UserProperties.getProperty("user.name", "");
        }
        this.userText = new JTextField(string3);
        AWTUtilities.constrain((Container)jPanel, (Component)this.userText, 2, 10, 1, n, 1, 1, 1.0, 0.0);
        jLabel = new JLabel("Password:");
        AWTUtilities.constrain((Container)jPanel, (Component)jLabel, 0, 17, 0, ++n, 1, 1, 0.0, 0.0);
        String string4 = UserProperties.getProperty("sqlPassword", "");
        this.passText = new JTextField(string4);
        AWTUtilities.constrain((Container)jPanel, (Component)this.passText, 2, 17, 1, n, 1, 1, 1.0, 0.0);
        jLabel = new JLabel("Database:");
        AWTUtilities.constrain((Container)jPanel, (Component)jLabel, 0, 17, 0, ++n, 1, 1, 0.0, 0.0);
        String string5 = UserProperties.getProperty("sqlDatabase", "mysql");
        this.dbText = new JTextField(string5);
        AWTUtilities.constrain((Container)jPanel, (Component)this.dbText, 2, 10, 1, n, 1, 1, 1.0, 0.0);
        jLabel = new JLabel("SQL Handler:");
        AWTUtilities.constrain((Container)jPanel, (Component)jLabel, 0, 17, 0, ++n, 1, 1, 0.0, 0.0);
        this.handlerList = new JComboBox();
        String[] stringArray = SQLClientHandler.getAllHandlerNames();
        int n2 = 0;
        while (n2 < stringArray.length) {
            this.handlerList.addItem((Object)stringArray[n2]);
            ++n2;
        }
        AWTUtilities.constrain((Container)jPanel, (Component)this.handlerList, 2, 10, 1, n, 1, 1, 1.0, 0.0);
        ++n;
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        AWTUtilities.constrain((Container)((Object)this), (Component)jPanel2, 3, 11, 1, 0, 1, 1, 0.0, 0.0);
        jPanel2.setBorder((Border)new CompoundBorder((Border)new EtchedBorder(0), (Border)new EmptyBorder(6, 6, 6, 6)));
        n = 0;
        jLabel = new JLabel("Profile:");
        AWTUtilities.constrain((Container)jPanel2, (Component)jLabel, 0, 18, 0, n++, 1, 1, 0.0, 0.0);
        this.profileList = new JComboBox();
        this.profileList.setEditable(false);
        this.profileList.addItemListener((ItemListener)this);
        this.addProfiles(this.profileList);
        AWTUtilities.constrain((Container)jPanel2, (Component)this.profileList, 2, 11, 0, n++, 1, 1, 1.0, 0.0);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridBagLayout());
        jPanel3.setBorder((Border)new EmptyBorder(6, 10, 4, 8));
        AWTUtilities.constrain((Container)jPanel2, (Component)jPanel3, 2, 15, 0, n++, 1, 1, 1.0, 0.0);
        this.connButton = new JButton("Connect");
        this.connButton.setActionCommand("CONNECT");
        this.connButton.addActionListener((ActionListener)this);
        this.connButton.setEnabled(true);
        AWTUtilities.constrain((Container)jPanel3, (Component)this.connButton, 2, 10, 0, 0, 1, 1, 1.0, 0.0);
        jPanel3 = new JPanel();
        jPanel3.setLayout(new GridBagLayout());
        jPanel3.setBorder((Border)new EmptyBorder(6, 10, 4, 8));
        AWTUtilities.constrain((Container)jPanel2, (Component)jPanel3, 2, 15, 0, n++, 1, 1, 1.0, 0.0);
        this.disconnButton = new JButton("DisConnect");
        this.disconnButton.setActionCommand("DISCONNECT");
        this.disconnButton.addActionListener((ActionListener)this);
        this.disconnButton.setEnabled(false);
        AWTUtilities.constrain((Container)jPanel3, (Component)this.disconnButton, 2, 10, 0, 0, 1, 1, 1.0, 0.0);
        this.statusText = new JTextArea();
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().add((Component)this.statusText);
        jScrollPane.setBorder((Border)new EtchedBorder());
        AWTUtilities.constrain((Container)((Object)this), (Component)jScrollPane, 1, 10, 0, 1, 2, 1, 1.0, 1.0);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            String string = (String)this.profileList.getSelectedItem();
            Vector vector = (Vector)this.profileTable.get(string);
            if (vector == null) {
                System.err.println("ERROR, why is profile '" + string + "' null?");
                return;
            }
            this.hostText.setText((String)vector.elementAt(1));
            this.portText.setText((String)vector.elementAt(2));
            this.userText.setText((String)vector.elementAt(3));
            this.passText.setText((String)vector.elementAt(4));
            this.dbText.setText((String)vector.elementAt(5));
            if (vector.size() > 6) {
                this.handlerList.setSelectedItem((Object)((String)vector.elementAt(6)));
            }
        }
    }

    private void addProfiles(JComboBox jComboBox) {
        String string;
        if (this.profileNames.size() < 1) {
            jComboBox.setEnabled(false);
            return;
        }
        int n = 0;
        while (n < this.profileNames.size()) {
            string = (String)this.profileNames.elementAt(n);
            jComboBox.addItem((Object)string);
            ++n;
        }
        string = UserProperties.getProperty("sqlProfile", null);
        if (string == null) {
            jComboBox.setSelectedIndex(0);
            return;
        }
        jComboBox.setSelectedItem((Object)string);
    }

    private void loadProfiles() {
        this.profileNames = new Vector();
        this.profileTable = new Hashtable();
        String string = UserProperties.getProperty("profiles", null);
        if (string == null) {
            return;
        }
        String[] stringArray = StringUtilities.splitString(string, ":");
        if (stringArray.length < 1) {
            return;
        }
        int n = 0;
        while (n < stringArray.length) {
            String string2 = stringArray[n];
            String string3 = UserProperties.getProperty("profile." + string2, null);
            if (string3 == null) {
                System.err.println("ERROR profile definition '" + string2 + "' not found.");
            } else {
                Vector vector = StringUtilities.vectorString(string3, ":");
                if (vector == null || vector.size() < 6) {
                    System.err.println("ERROR profile definition '" + string2 + "' has only " + vector.size() + " fields.");
                } else {
                    this.profileNames.addElement(string2);
                    this.profileTable.put(string2, vector);
                }
            }
            ++n;
        }
    }
}

