#!/usr/bin/perl -T
########################################################################
#                                                                      #
#    acctimport.pl                InnerCite                            #
#                                 Mike Machado <mike@innercite.com>    #
#                                 22 October 1999                      #
#                                                                      #
#    Exports standard RADIUS detail files from ICRADIUS                #
#                                                                      #
#                   Copyright under same terms as Cistron RADIUS       #
#                                                                      #
########################################################################
#
#	this script was hacked from a script
#	called radlog written by 
#	Carl Rigney; cdr@livingston.com
#			
#	all credit goes to him.
#

use DBI;
use strict;

my $dbusername = 'root';
my $dbpassword = 'mysqliscool';

my $dbh = DBI->connect("DBI:mysql:radius",$dbusername, $dbpassword);
my $sth;

require 'timelocal.pl';

my @wdays = ('Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat');
my %months = ( 'Jan', 0,
            'Feb', 1,
            'Mar', 2,
            'Apr', 3,
            'May', 4,
            'Jun', 5,
            'Jul', 6,
            'Aug', 7,
            'Sep', 8,
            'Oct', 9,
            'Nov', 10,
            'Dec', 11 );

$/ = '';                # read paragraph at a time

my %DETAIL = ();
while (<>) {
  	next if /Acct-Session-Id = "00000000"/;
  	%DETAIL = ();
	my $startsessid = '';
	my $stopsessid = '';
	
	if (/Acct-Status-Type = (\S+)/) {
	  $DETAIL{'Acct-Status-Type'} = $1;
	}

	if (/Acct-Session-Id = "([^"]+)"/) {
	  $DETAIL{'Acct-Session-Id'} = $1;
	}

	if (/User-Name = "([^"]+)"/) {
      	   $DETAIL{'User-Name'} = $1;
    	}

	if (/NAS-IP-Address = (\S+)/) {
	   $DETAIL{'NAS-IP-Address'} = $1;
	}
	
	if (/NAS-Port-Id = (\d+)/) {
	   $DETAIL{'NAS-Port-Id'} = $1;
	}

	if (/NAS-Port-Type = (\S+)/) {
	   $DETAIL{'NAS-Port-Type'} = $1;
	}

	$DETAIL{'Time'} = timelocal ($6, $5, $4, $3, $months{$2}, $7) if
	(/^(\w{3})\s(\w{3})\s{1,2}(\d{1,2})\s(\d{2}):(\d{2}):(\d{2})\s19(\d{2})\n/
	&& (grep {$1 eq $_} @wdays) && (grep {$2 eq $_} keys %months));
	
	if (/Acct-Session-Time = (\d+)/) {
	   $DETAIL{'Acct-Session-Time'} = $1;
    	}

	if (/Acct-Authentic = (\S+)/) {
	   $DETAIL{'Acct-Authentic'} = $1;
	}

	if (/Acct-Input-Octets = (\d+)/ ){
	   $DETAIL{'Acct-Input-Octets'} = $1;
	}

	if (/Acct-Output-Octets = (\d+)/) {
	   $DETAIL{'Acct-Output-Octets'} = $1;
	}
	
	if (/Called-Station-Id = "([^"]+)"/) {
	   $DETAIL{'Called-Station-Id'} = $1;
    	}

	if (/Calling-Station-Id = "([^"]+)"/) {
	   $DETAIL{'Calling-Station-Id'} = $1;
    	}

	if (/Connect-Info = "([^"]+)"/) {
	   $DETAIL{'Connect-Info'} = $1;
    	}

	if (/Acct-Terminate-Cause = (\S+)/) {
	   $DETAIL{'Acct-Terminate-Cause'} = $1;
    	}

	if (/Service-Type = (\S+)/) {
	   $DETAIL{'Service-Type'} = $1;
    	}

	if (/Framed-Protocol = (\S+)/) {
	   $DETAIL{'Framed-Protocol'} = $1;
    	}

	if (/Framed-IP-Address = (\S+)/) {
	   $DETAIL{'Framed-IP-Address'} = $1;
    	}

	if (/Acct-Delay-Time = (\d+)/) {
	   $DETAIL{'Acct-Delay-Time'} = $1;
    	}

	if ($DETAIL{'Acct-Status-Type'} eq 'Start') {
		$sth = $dbh->prepare("SELECT RadAcctId FROM radacct WHERE AcctSessionId = '$DETAIL{'Acct-Session-Id'}' AND UserName = '$DETAIL{'User-Name'}' AND NASIPAddress = '$DETAIL{'NAS-IP-Address'}' AND NASPortId = '$DETAIL{'NAS-Port-Id'}' AND AcctStartTime = 0");
		$sth->execute || print "Error: ".$dbh->errstr();
		($startsessid) = $sth->fetchrow_array;
		$sth->finish;
		if ($startsessid) {
			$sth = $dbh->do("UPDATE radacct SET AcctStartTime = FROM_UNIXTIME('$DETAIL{'Time'}'), AcctStartDelay = '$DETAIL{'Acct-Delay-Time'}' WHERE RadAcctId = '$startsessid'") || print "Error: ".$dbh->errstr();
		} else {
			$sth = $dbh->do("INSERT INTO radacct VALUES ('','$DETAIL{'Acct-Session-Id'}','$DETAIL{'User-Name'}','','$DETAIL{'NAS-IP-Address'}',$DETAIL{'NAS-Port-Id'},'$DETAIL{'NAS-Port-Type'}',FROM_UNIXTIME('$DETAIL{'Time'}'), 0, 0, '$DETAIL{'Acct-Authentic'}','$DETAIL{'Connect-Info'}',0, 0, '$DETAIL{'Called-Station-Id'}','$DETAIL{'Calling-Station-Id'}','','$DETAIL{'Service-Type'}','$DETAIL{'Framed-Protocol'}','$DETAIL{'Framed-IP-Address'}',$DETAIL{'Acct-Delay-Time'}, 0)") || print "Error: ".$dbh->errstr();
		}
	} elsif ($DETAIL{'Acct-Status-Type'} eq 'Stop') {
		$sth = $dbh->prepare("SELECT RadAcctId FROM radacct WHERE AcctSessionId = '$DETAIL{'Acct-Session-Id'}' AND UserName = '$DETAIL{'User-Name'}' AND NASIPAddress = '$DETAIL{'NAS-IP-Address'}' AND NASPortId = '$DETAIL{'NAS-Port-Id'}' AND AcctStopTime = 0") || print "Error: ".$dbh->errstr();
		$sth->execute || print "Error: ".$dbh->errstr();
		($stopsessid) = $sth->fetchrow_array;
		$sth->finish;
		if ($stopsessid) {
			$sth = $dbh->do("UPDATE radacct SET AcctStopTime = FROM_UNIXTIME('$DETAIL{'Time'}'), AcctStopDelay = '$DETAIL{'Acct-Delay-Time'}', AcctSessionTime = $DETAIL{'Acct-Session-Time'}, AcctInputOctets = $DETAIL{'Acct-Input-Octets'}, AcctOutputOctets = $DETAIL{'Acct-Output-Octets'}, AcctTerminateCause = '$DETAIL{'Acct-Terminate-Cause'}' WHERE RadAcctId = '$stopsessid'") || print "Error: ".$dbh->errstr();
		} else {
			$sth = $dbh->do("INSERT INTO radacct VALUES ('','$DETAIL{'Acct-Session-Id'}','$DETAIL{'User-Name'}','','$DETAIL{'NAS-IP-Address'}',$DETAIL{'NAS-Port-Id'},'$DETAIL{'NAS-Port-Type'}', 0, FROM_UNIXTIME('$DETAIL{'Time'}'), $DETAIL{'Acct-Session-Time'}, '$DETAIL{'Acct-Authentic'}','$DETAIL{'Connect-Info'}',$DETAIL{'Acct-Input-Octets'}, $DETAIL{'Acct-Output-Octets'}, '$DETAIL{'Called-Station-Id'}','$DETAIL{'Calling-Station-Id'}','$DETAIL{'Acct-Terminate-Cause'}','$DETAIL{'Service-Type'}','$DETAIL{'Framed-Protocol'}','$DETAIL{'Framed-IP-Address'}', 0, $DETAIL{'Acct-Delay-Time'})") || print "Error: ".$dbh->errstr();
		}
	}
}
$dbh->disconnect;
