#include <ctype.h>

#include "cgi_stream_string.h"
#include "cgi_die.h"


ostream& operator <<(ostream& os, const CgiStreamString& str)
 {
  unsigned int i;

  for(i = 0; i < str.length(); ++i)
   {
    char c = str[i];
    int escaped = 0;

    switch(c)
    {
     case '\\':
      if(escaped)
       {
        escaped = 0;
        break;
       }
      else
       {
        escaped = 1;
        continue;
       }

     case '\n':
      os << "\\";
      break;

     case '"':
      os << '\\';
      break;

     case '$':
      if(!escaped)
       {
        os << "\"; *active_os << ";
        i++;
        while(str[i] != '$' && i < str.length())
         {
          os << str[i++];
         }

	if(str[i] != '$')
	 die("Parse error in embedded C++ expression, missing \
	   closing $ in: %s", str.c_str);

        os << "; *active_os << \"";
        continue;
       }
      break;
    }

    escaped = 0;
    os << c;
   }
 
  return os;
 }

#ifdef DEBUG

int main(int arc, char ** argv)
 {
  CgiStreamString s1("hello, world"), s2("Hello $var"), 
   s3("$var hello"), s4("hello $var hello");
  ofstream os(1);


  os << s1 << endl;
  os << s2 << endl;
  os << s3 << endl;
  os << s4 << endl;

  return 0;
 }

#endif
