/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.install.artifact.internal;

import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.eclipse.virgo.kernel.artifact.fs.ArtifactFS;
import org.eclipse.virgo.kernel.artifact.fs.ArtifactFSFactory;
import org.eclipse.virgo.kernel.install.artifact.ArtifactStorage;
import org.eclipse.virgo.kernel.install.artifact.internal.ArtifactStore;
import org.eclipse.virgo.kernel.install.artifact.internal.FileMovingArtifactStore;
import org.eclipse.virgo.kernel.install.artifact.internal.GenerationalArtifactStore;
import org.eclipse.virgo.medic.eventlog.EventLogger;
import org.eclipse.virgo.medic.eventlog.LogEvent;
import org.eclipse.virgo.nano.deployer.api.core.DeployerLogEvents;
import org.eclipse.virgo.util.io.JarUtils;
import org.eclipse.virgo.util.io.PathReference;

final class StandardArtifactStorage
implements ArtifactStorage {
    private static final String DEPLOYER_UNPACK_BUNDLES_TRUE = "true";
    private static final List<String> CONSTANT_PATH_EXTENSIONS = Arrays.asList("par", "zip");
    private static final List<String> ALWAYS_UNPACKED_EXTENSIONS = Arrays.asList("par", "zip");
    private static final List<String> CONFIGURABLY_UNPACKED_EXTENSIONS = Arrays.asList("jar", "war");
    private final PathReference sourcePathReference;
    private final ArtifactFSFactory artifactFSFactory;
    private final EventLogger eventLogger;
    private final boolean unpackBundles;
    private final ArtifactStore pathGenerator;

    public StandardArtifactStorage(PathReference sourcePathReference, PathReference baseStagingPathReference, ArtifactFSFactory artifactFSFactory, EventLogger eventLogger, String unpackBundlesOption) {
        this.sourcePathReference = sourcePathReference;
        this.artifactFSFactory = artifactFSFactory;
        this.eventLogger = eventLogger;
        this.unpackBundles = unpackBundlesOption == null || DEPLOYER_UNPACK_BUNDLES_TRUE.equalsIgnoreCase(unpackBundlesOption);
        this.pathGenerator = CONSTANT_PATH_EXTENSIONS.contains(StandardArtifactStorage.getFileExtension(sourcePathReference)) ? new FileMovingArtifactStore(baseStagingPathReference) : new GenerationalArtifactStore(baseStagingPathReference);
        PathReference currentPathReference = this.pathGenerator.getCurrentPath();
        currentPathReference.delete(true);
        this.synchronize(this.sourcePathReference);
    }

    @Override
    public void synchronize() {
        this.pathGenerator.save();
        this.synchronize(this.sourcePathReference);
    }

    @Override
    public ArtifactFS getArtifactFS() {
        return this.artifactFSFactory.create(this.pathGenerator.getCurrentPath().toFile());
    }

    @Override
    public void synchronize(URI sourceUri) {
        this.pathGenerator.save();
        this.synchronize(new PathReference(sourceUri));
    }

    @Override
    public void rollBack() {
        this.pathGenerator.restore();
    }

    @Override
    public void delete() {
        PathReference currentPathReference = this.pathGenerator.getCurrentPath();
        currentPathReference.delete(true);
    }

    private void synchronize(PathReference normalizedSourcePathReference) {
        PathReference currentPathReference = this.pathGenerator.getCurrentPath();
        if (normalizedSourcePathReference != null && !normalizedSourcePathReference.isDirectory() && this.needsUnpacking(normalizedSourcePathReference)) {
            try {
                JarUtils.unpackTo((PathReference)normalizedSourcePathReference, (PathReference)currentPathReference);
            }
            catch (IOException e) {
                this.eventLogger.log((LogEvent)DeployerLogEvents.JAR_UNPACK_ERROR, (Throwable)e, new Object[]{normalizedSourcePathReference});
                throw new RuntimeException(String.format("Exception unpacking '%s'", normalizedSourcePathReference), e);
            }
        } else if (normalizedSourcePathReference != null) {
            normalizedSourcePathReference.copy(currentPathReference, true);
        } else {
            currentPathReference.createDirectory();
        }
    }

    private boolean needsUnpacking(PathReference pathReference) {
        String fileExtension = StandardArtifactStorage.getFileExtension(pathReference);
        if (fileExtension == null) {
            return false;
        }
        return ALWAYS_UNPACKED_EXTENSIONS.contains(fileExtension) || this.unpackBundles && CONFIGURABLY_UNPACKED_EXTENSIONS.contains(fileExtension);
    }

    private static String getFileExtension(PathReference pathReference) {
        if (pathReference == null) {
            return null;
        }
        String name = pathReference.getName();
        String fileName = name.toLowerCase(Locale.ENGLISH);
        int dotLocation = fileName.lastIndexOf(46);
        if (dotLocation == -1) {
            return null;
        }
        return fileName.substring(dotLocation + 1);
    }
}

