/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.console.ssh;

import java.io.IOException;
import org.apache.felix.service.command.CommandProcessor;
import org.apache.sshd.SshServer;
import org.apache.sshd.common.Factory;
import org.apache.sshd.common.KeyPairProvider;
import org.apache.sshd.server.PasswordAuthenticator;
import org.apache.sshd.server.jaas.JaasPasswordAuthenticator;
import org.apache.sshd.server.keyprovider.SimpleGeneratorHostKeyProvider;
import org.eclipse.equinox.console.ssh.SshShellFactory;
import org.osgi.framework.BundleContext;

public class SshServ
extends Thread {
    private int port;
    private String host;
    private SshServer sshServer = null;
    private SshShellFactory shellFactory = null;
    private static final String SSH_KEYSTORE_PROP = "ssh.server.keystore";
    private static final String SSH_KEYSTORE_PROP_DEFAULT = "hostkey.ser";
    private static final String EQUINOX_CONSOLE_DOMAIN = "equinox_console";

    public SshServ(CommandProcessor processor, BundleContext context, String host, int port) {
        this.host = host;
        this.port = port;
        this.shellFactory = new SshShellFactory(processor, context);
    }

    public void run() throws RuntimeException {
        try {
            this.sshServer = SshServer.setUpDefaultServer();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            System.out.println("SSH bundles not available! If you want to use SSH, please install Apache sshd-core, Apache mina-core, slf4j-api and a slf4j logger implementation bundles");
            throw new RuntimeException("SSH bundles not available");
        }
        if (this.host != null) {
            this.sshServer.setHost(this.host);
        }
        this.sshServer.setPort(this.port);
        this.sshServer.setKeyPairProvider((KeyPairProvider)new SimpleGeneratorHostKeyProvider(System.getProperty(SSH_KEYSTORE_PROP, SSH_KEYSTORE_PROP_DEFAULT)));
        this.sshServer.setShellFactory((Factory)this.shellFactory);
        this.sshServer.setPasswordAuthenticator(this.createJaasPasswordAuthenticator());
        try {
            this.sshServer.start();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public synchronized void stopSshServer() {
        try {
            this.sshServer.stop(true);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private PasswordAuthenticator createJaasPasswordAuthenticator() {
        JaasPasswordAuthenticator jaasPasswordAuthenticator = new JaasPasswordAuthenticator();
        jaasPasswordAuthenticator.setDomain(EQUINOX_CONSOLE_DOMAIN);
        return jaasPasswordAuthenticator;
    }
}

