/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config;

import java.util.Map;
import javax.enterprise.inject.spi.BeanManager;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.config.AppModule;
import org.apache.openejb.config.ClientModule;
import org.apache.openejb.config.DeploymentModule;
import org.apache.openejb.config.DynamicDeployer;
import org.apache.openejb.config.EjbModule;
import org.apache.openejb.config.WebModule;
import org.apache.openejb.jee.ApplicationClient;
import org.apache.openejb.jee.EjbJar;
import org.apache.openejb.jee.EnterpriseBean;
import org.apache.openejb.jee.EnvEntry;
import org.apache.openejb.jee.JndiConsumer;
import org.apache.openejb.jee.JndiReference;
import org.apache.openejb.jee.ResourceEnvRef;

public class BuiltInEnvironmentEntries
implements DynamicDeployer {
    @Override
    public AppModule deploy(AppModule appModule) throws OpenEJBException {
        ApplicationClient consumer;
        for (ClientModule clientModule : appModule.getClientModules()) {
            consumer = clientModule.getApplicationClient();
            if (consumer == null) continue;
            this.add((JndiConsumer)consumer, clientModule, appModule);
        }
        for (WebModule webModule : appModule.getWebModules()) {
            consumer = webModule.getWebApp();
            if (consumer == null) continue;
            this.add((JndiConsumer)consumer, webModule, appModule);
        }
        for (EjbModule ejbModule : appModule.getEjbModules()) {
            EjbJar ejbJar = ejbModule.getEjbJar();
            if (ejbJar == null) continue;
            for (EnterpriseBean consumer2 : ejbJar.getEnterpriseBeans()) {
                this.add((JndiConsumer)consumer2, ejbModule, appModule);
            }
        }
        return appModule;
    }

    private void add(JndiConsumer jndi, DeploymentModule module, DeploymentModule app) {
        this.add(jndi.getEnvEntryMap(), new EnvEntry().name("java:module/ModuleName").value(module.getModuleId()).type(String.class));
        this.add(jndi.getEnvEntryMap(), new EnvEntry().name("java:app/AppName").value(app.getModuleId()).type(String.class));
        this.add(jndi.getResourceEnvRefMap(), new ResourceEnvRef().name("java:comp/BeanManager").type(BeanManager.class));
        this.add(jndi.getResourceEnvRefMap(), new ResourceEnvRef().name("java:comp/Validator").type(Validator.class));
        this.add(jndi.getResourceEnvRefMap(), new ResourceEnvRef().name("java:comp/ValidatorFactory").type(ValidatorFactory.class));
        this.add(jndi.getResourceEnvRefMap(), new ResourceEnvRef().name("java:comp/TransactionManager").type(TransactionManager.class));
        this.add(jndi.getResourceEnvRefMap(), new ResourceEnvRef().name("java:comp/TransactionSynchronizationRegistry").type(TransactionSynchronizationRegistry.class));
        this.add(jndi.getEnvEntryMap(), new EnvEntry().name("java:comp/ComponentName").value(jndi.getJndiConsumerName()).type(String.class));
    }

    private <E extends JndiReference> void add(Map<String, E> map, E entry) {
        JndiReference existing = (JndiReference)map.get(entry.getKey());
        map.put((String)entry.getKey(), entry);
        if (existing != null) {
            entry.getInjectionTarget().addAll(existing.getInjectionTarget());
        }
    }
}

