/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.shell.internal.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.virgo.kernel.osgi.quasi.QuasiBundle;
import org.eclipse.virgo.kernel.osgi.quasi.QuasiExportPackage;
import org.eclipse.virgo.kernel.osgi.quasi.QuasiFramework;
import org.eclipse.virgo.kernel.osgi.quasi.QuasiFrameworkFactory;
import org.eclipse.virgo.kernel.osgi.quasi.QuasiImportPackage;
import org.eclipse.virgo.shell.Command;
import org.eclipse.virgo.shell.internal.commands.AbstractInstallArtifactBasedCommands;
import org.eclipse.virgo.shell.internal.formatting.PackageCommandFormatter;
import org.eclipse.virgo.shell.internal.util.PackageHolder;
import org.osgi.framework.Version;

@Command(value="package")
public final class PackageCommands {
    private final QuasiFrameworkFactory quasiFrameworkFactory;
    private final PackageCommandFormatter formatter;

    public PackageCommands(QuasiFrameworkFactory quasiFrameworkFactory) {
        this.quasiFrameworkFactory = quasiFrameworkFactory;
        this.formatter = new PackageCommandFormatter();
    }

    @Command(value="list")
    public List<String> list() {
        return this.formatter.formatList(this.getAllPackages());
    }

    @Command(value="examine")
    public List<String> examine(String name, String versionString) {
        Version version;
        ArrayList<QuasiExportPackage> matchingExports = new ArrayList<QuasiExportPackage>();
        try {
            version = AbstractInstallArtifactBasedCommands.convertToVersion(versionString);
        }
        catch (IllegalArgumentException iae) {
            return Arrays.asList(iae.getMessage());
        }
        PackageHolder packages = this.getPackages(name);
        for (QuasiExportPackage exportPackage : packages.getExporters()) {
            if (!exportPackage.getVersion().equals((Object)version)) continue;
            matchingExports.add(exportPackage);
        }
        if (matchingExports.isEmpty()) {
            return Arrays.asList(String.format("No package with name '%s' and version '%s' was found", name, version));
        }
        return this.formatter.formatExamine(matchingExports);
    }

    private List<QuasiExportPackage> getAllPackages() {
        ArrayList<QuasiExportPackage> packages = new ArrayList<QuasiExportPackage>();
        for (QuasiBundle bundle : this.quasiFrameworkFactory.create().getBundles()) {
            packages.addAll(bundle.getExportPackages());
        }
        return packages;
    }

    private PackageHolder getPackages(String packageName) {
        QuasiFramework framework = this.quasiFrameworkFactory.create();
        if (packageName != null) {
            ArrayList<QuasiImportPackage> importers = new ArrayList<QuasiImportPackage>();
            ArrayList<QuasiExportPackage> exporters = new ArrayList<QuasiExportPackage>();
            List bundles = framework.getBundles();
            for (QuasiBundle qBundle : bundles) {
                QuasiExportPackage exportPackage;
                QuasiImportPackage importPackage = this.processImporters(qBundle, packageName);
                if (importPackage != null) {
                    importers.add(importPackage);
                }
                if ((exportPackage = this.processExporters(qBundle, packageName)) == null) continue;
                exporters.add(exportPackage);
            }
            return new PackageHolder(exporters, importers, packageName);
        }
        return null;
    }

    private QuasiImportPackage processImporters(QuasiBundle qBundle, String packageName) {
        for (QuasiImportPackage qImportPackage : qBundle.getImportPackages()) {
            if (!qImportPackage.getPackageName().equals(packageName)) continue;
            return qImportPackage;
        }
        return null;
    }

    private QuasiExportPackage processExporters(QuasiBundle qBundle, String packageName) {
        for (QuasiExportPackage qExportPackage : qBundle.getExportPackages()) {
            if (!qExportPackage.getPackageName().equals(packageName)) continue;
            return qExportPackage;
        }
        return null;
    }
}

