/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.format.datetime.joda;

import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.springframework.format.FormatterRegistrar;
import org.springframework.format.FormatterRegistry;
import org.springframework.format.datetime.joda.DateTimeParser;
import org.springframework.format.datetime.joda.JodaDateTimeFormatAnnotationFormatterFactory;
import org.springframework.format.datetime.joda.JodaTimeConverters;
import org.springframework.format.datetime.joda.ReadableInstantPrinter;
import org.springframework.format.datetime.joda.ReadablePartialPrinter;

public class JodaTimeFormatterRegistrar
implements FormatterRegistrar {
    private String dateStyle;
    private String timeStyle;
    private String dateTimeStyle;
    private boolean useIsoFormat;

    public void setDateStyle(String dateStyle) {
        this.dateStyle = dateStyle;
    }

    public void setTimeStyle(String timeStyle) {
        this.timeStyle = timeStyle;
    }

    public void setDateTimeStyle(String dateTimeStyle) {
        this.dateTimeStyle = dateTimeStyle;
    }

    public void setUseIsoFormat(boolean useIsoFormat) {
        this.useIsoFormat = useIsoFormat;
    }

    public void registerFormatters(FormatterRegistry registry) {
        JodaTimeConverters.registerConverters(registry);
        DateTimeFormatter jodaDateFormatter = this.getJodaDateFormatter();
        registry.addFormatterForFieldType(LocalDate.class, new ReadablePartialPrinter(jodaDateFormatter), new DateTimeParser(jodaDateFormatter));
        DateTimeFormatter jodaTimeFormatter = this.getJodaTimeFormatter();
        registry.addFormatterForFieldType(LocalTime.class, new ReadablePartialPrinter(jodaTimeFormatter), new DateTimeParser(jodaTimeFormatter));
        DateTimeFormatter jodaDateTimeFormatter = this.getJodaDateTimeFormatter();
        DateTimeParser dateTimeParser = new DateTimeParser(jodaDateTimeFormatter);
        registry.addFormatterForFieldType(LocalDateTime.class, new ReadablePartialPrinter(jodaDateTimeFormatter), dateTimeParser);
        ReadableInstantPrinter readableInstantPrinter = new ReadableInstantPrinter(jodaDateTimeFormatter);
        registry.addFormatterForFieldType(ReadableInstant.class, readableInstantPrinter, dateTimeParser);
        registry.addFormatterForFieldAnnotation(new JodaDateTimeFormatAnnotationFormatterFactory());
    }

    private DateTimeFormatter getJodaDateFormatter() {
        if (this.useIsoFormat) {
            return ISODateTimeFormat.date();
        }
        if (this.dateStyle != null) {
            return DateTimeFormat.forStyle((String)(String.valueOf(this.dateStyle) + "-"));
        }
        return DateTimeFormat.shortDate();
    }

    private DateTimeFormatter getJodaTimeFormatter() {
        if (this.useIsoFormat) {
            return ISODateTimeFormat.time();
        }
        if (this.timeStyle != null) {
            return DateTimeFormat.forStyle((String)("-" + this.timeStyle));
        }
        return DateTimeFormat.shortTime();
    }

    private DateTimeFormatter getJodaDateTimeFormatter() {
        if (this.useIsoFormat) {
            return ISODateTimeFormat.dateTime();
        }
        if (this.dateTimeStyle != null) {
            return DateTimeFormat.forStyle((String)this.dateTimeStyle);
        }
        return DateTimeFormat.shortDateTime();
    }
}

