/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scheduling.config;

import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.JdkVersion;
import org.springframework.core.task.TaskExecutor;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskExecutorFactoryBean
implements FactoryBean<TaskExecutor>,
BeanNameAware {
    private volatile TaskExecutor target;
    private volatile BeanWrapper beanWrapper;
    private volatile String poolSize;
    private volatile Integer queueCapacity;
    private volatile Object rejectedExecutionHandler;
    private volatile Integer keepAliveSeconds;
    private volatile String beanName;
    private final Object initializationMonitor = new Object();

    public void setPoolSize(String poolSize) {
        this.poolSize = poolSize;
    }

    public void setQueueCapacity(int queueCapacity) {
        this.queueCapacity = queueCapacity;
    }

    public void setRejectedExecutionHandler(Object rejectedExecutionHandler) {
        this.rejectedExecutionHandler = rejectedExecutionHandler;
    }

    public void setKeepAliveSeconds(int keepAliveSeconds) {
        this.keepAliveSeconds = keepAliveSeconds;
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public Class<? extends TaskExecutor> getObjectType() {
        if (this.target != null) {
            return this.target.getClass();
        }
        return TaskExecutor.class;
    }

    public TaskExecutor getObject() throws Exception {
        if (this.target == null) {
            this.initializeExecutor();
        }
        return this.target;
    }

    public boolean isSingleton() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeExecutor() throws Exception {
        Object object = this.initializationMonitor;
        synchronized (object) {
            if (this.target != null) {
                return;
            }
            String executorClassName = this.shouldUseBackport(this.poolSize) ? "org.springframework.scheduling.backportconcurrent.ThreadPoolTaskExecutor" : "org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor";
            Class<?> executorClass = this.getClass().getClassLoader().loadClass(executorClassName);
            this.beanWrapper = new BeanWrapperImpl(executorClass);
            this.setValueIfNotNull("queueCapacity", this.queueCapacity);
            this.setValueIfNotNull("keepAliveSeconds", this.keepAliveSeconds);
            this.setValueIfNotNull("rejectedExecutionHandler", this.rejectedExecutionHandler);
            Integer[] range = this.determinePoolSizeRange();
            if (range != null) {
                this.setValueIfNotNull("corePoolSize", range[0]);
                this.setValueIfNotNull("maxPoolSize", range[1]);
            }
            this.target = (TaskExecutor)this.beanWrapper.getWrappedInstance();
            if (this.target instanceof InitializingBean) {
                ((InitializingBean)this.target).afterPropertiesSet();
            }
        }
    }

    private void setValueIfNotNull(String name, Object value) {
        Assert.notNull((Object)this.beanWrapper, (String)"Property values cannot be set until the BeanWrapper has been created.");
        if (value != null) {
            this.beanWrapper.setPropertyValue(name, value);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Integer[] determinePoolSizeRange() {
        if (!StringUtils.hasText((String)this.poolSize)) {
            return null;
        }
        Integer[] range = null;
        try {
            int separatorIndex = this.poolSize.indexOf(45);
            if (separatorIndex != -1) {
                range = new Integer[]{Integer.valueOf(this.poolSize.substring(0, separatorIndex)), Integer.valueOf(this.poolSize.substring(separatorIndex + 1, this.poolSize.length()))};
                if (range[0] > range[1]) {
                    throw new BeanCreationException(this.beanName, "Lower bound of pool-size range must not exceed the upper bound.");
                }
                if (this.queueCapacity != null) return range;
                if (range[0] != 0) throw new BeanCreationException(this.beanName, "A non-zero lower bound for the size range requires a queue-capacity value.");
                this.setValueIfNotNull("allowCoreThreadTimeOut", true);
                range[0] = range[1];
                return range;
            }
            Integer value = Integer.valueOf(this.poolSize);
            return new Integer[]{value, value};
        }
        catch (NumberFormatException ex) {
            throw new BeanCreationException(this.beanName, "Invalid pool-size value [" + this.poolSize + "]: only single maximum integer " + "(e.g. \"5\") and minimum-maximum range (e.g. \"3-5\") are supported.", (Throwable)ex);
        }
    }

    private boolean shouldUseBackport(String poolSize) {
        return StringUtils.hasText((String)poolSize) && poolSize.startsWith("0") && JdkVersion.getMajorJavaVersion() < 3;
    }
}

