/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.bundlor.util;

import java.util.regex.Pattern;

public final class MatchUtils {
    public static final int NO_MATCH = -1;
    private static final String WILDCARD = "*";
    private static final String DOT_WILDCARD = ".*";
    private static final String PACKAGE_SEPARATOR = ".";
    private static final String REGEX_ESCAPED_PACKAGE_SEPARATOR = "\\.";
    private static final String REGEX_WILDCARD = ".*";
    private static final String REGEX_OPTIONAL_DOT_WILDCARD = "(\\..*)?";
    private static final String REGEX_OPTIONAL_WILDCARD = "(\\.)?(.*)?";

    public static boolean matches(String candidate, String pattern) {
        if (WILDCARD.equals(pattern)) {
            return true;
        }
        boolean wildcard = pattern.endsWith(WILDCARD);
        boolean dotWildcard = pattern.endsWith(".*");
        String matchString = wildcard ? MatchUtils.stripWildcard(pattern) : pattern;
        matchString = matchString.replace(PACKAGE_SEPARATOR, REGEX_ESCAPED_PACKAGE_SEPARATOR);
        matchString = matchString.replace(WILDCARD, ".*");
        if (dotWildcard) {
            matchString = String.valueOf(matchString) + REGEX_OPTIONAL_DOT_WILDCARD;
        } else if (wildcard) {
            matchString = String.valueOf(matchString) + REGEX_OPTIONAL_WILDCARD;
        }
        return Pattern.matches(matchString, candidate);
    }

    public static int rankedMatch(String candidate, String pattern) {
        String matchString;
        if (pattern == null || pattern.length() == 0) {
            return -1;
        }
        if (WILDCARD.equals(pattern)) {
            return 0;
        }
        boolean wildcard = pattern.endsWith(WILDCARD);
        String string = matchString = wildcard ? MatchUtils.stripWildcard(pattern) : pattern;
        if (!wildcard && candidate.equals(pattern) || wildcard && candidate.startsWith(matchString)) {
            String[] candidateComponents = candidate.split(REGEX_ESCAPED_PACKAGE_SEPARATOR);
            String[] matchStringComponents = matchString.split(REGEX_ESCAPED_PACKAGE_SEPARATOR);
            if (matchStringComponents[matchStringComponents.length - 1].equals(candidateComponents[matchStringComponents.length - 1])) {
                int specificity = 0;
                int x = -1;
                while ((x = pattern.indexOf(46, x + 1)) > -1) {
                    ++specificity;
                }
                return specificity;
            }
            return -1;
        }
        return -1;
    }

    private static String stripWildcard(String pattern) {
        int lastIndex = pattern.length() - WILDCARD.length();
        if (lastIndex > 0 && pattern.charAt(lastIndex - 1) == '.') {
            --lastIndex;
        }
        return pattern.substring(0, lastIndex);
    }
}

