/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.ctf.core.tests.trace;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.ctf.core.CTFException;
import org.eclipse.tracecompass.ctf.core.event.io.BitBuffer;
import org.eclipse.tracecompass.ctf.core.event.scope.IDefinitionScope;
import org.eclipse.tracecompass.ctf.core.event.scope.ILexicalScope;
import org.eclipse.tracecompass.ctf.core.event.types.IDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.IntegerDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.IntegerDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.StructDeclaration;
import org.eclipse.tracecompass.ctf.core.trace.CTFTrace;
import org.eclipse.tracecompass.ctf.core.trace.ICTFPacketDescriptor;
import org.eclipse.tracecompass.internal.ctf.core.event.EventDeclaration;
import org.eclipse.tracecompass.internal.ctf.core.event.EventDefinition;
import org.eclipse.tracecompass.internal.ctf.core.trace.CTFPacketReader;
import org.eclipse.tracecompass.internal.ctf.core.trace.StreamInputPacketIndexEntry;
import org.junit.Assert;
import org.junit.Test;

public class CTFPacketReaderTest {
    private static final StructDeclaration EMPTY_STRUCT = new StructDeclaration(8L);

    private static @NonNull BitBuffer createBitBuffer(byte[] bytes) {
        return new BitBuffer(ByteBuffer.wrap(bytes));
    }

    @Test
    public void testPacket() throws CTFException {
        byte[] byArray = new byte[8];
        byArray[4] = 1;
        byArray[5] = -1;
        byArray[6] = -1;
        byArray[7] = -91;
        byte[] bytes = byArray;
        BitBuffer input = CTFPacketReaderTest.createBitBuffer(bytes);
        StreamInputPacketIndexEntry packetContext = new StreamInputPacketIndexEntry(0L, EMPTY_STRUCT.createDefinition(null, ILexicalScope.TRACE, new BitBuffer()), 8L, 0L, 0L);
        StructDeclaration eventHeaderDeclaration = new StructDeclaration(8L);
        eventHeaderDeclaration.addField("timestamp", (IDeclaration)IntegerDeclaration.INT_8_DECL);
        EventDeclaration eventDec = new EventDeclaration();
        eventDec.setName("Hello");
        StructDeclaration fields = new StructDeclaration(8L);
        fields.addField("field1", (IDeclaration)IntegerDeclaration.UINT_16L_DECL);
        fields.addField("field2", (IDeclaration)IntegerDeclaration.UINT_8_DECL);
        eventDec.setFields(fields);
        eventDec.setLogLevel(4L);
        List<@Nullable EventDeclaration> declarations = Collections.singletonList(eventDec);
        CTFTrace trace = new CTFTrace();
        CTFPacketReader cpr = new CTFPacketReader(input, (ICTFPacketDescriptor)packetContext, declarations, (IDeclaration)eventHeaderDeclaration, null, null, (IDefinitionScope)trace);
        Assert.assertNotNull((Object)cpr);
        Assert.assertTrue((boolean)cpr.hasMoreEvents());
        EventDefinition event = cpr.readNextEvent();
        Assert.assertEquals((long)0L, (long)event.getTimestamp());
        Assert.assertEquals((long)0L, (long)((IntegerDefinition)event.getFields().getDefinition("field1")).getValue());
        Assert.assertEquals((long)0L, (long)((IntegerDefinition)event.getFields().getDefinition("field2")).getValue());
        Assert.assertNotNull((Object)cpr);
        Assert.assertTrue((boolean)cpr.hasMoreEvents());
        event = cpr.readNextEvent();
        Assert.assertEquals((long)1L, (long)event.getTimestamp());
        Assert.assertEquals((long)65535L, (long)((IntegerDefinition)event.getFields().getDefinition("field1")).getValue());
        Assert.assertEquals((long)165L, (long)((IntegerDefinition)event.getFields().getDefinition("field2")).getValue());
        Assert.assertFalse((boolean)cpr.hasMoreEvents());
    }

    @Test
    public void testPacketWithContext() throws CTFException {
        byte[] byArray = new byte[8];
        byArray[4] = 1;
        byArray[5] = -1;
        byArray[6] = -1;
        byArray[7] = -91;
        byte[] bytes = byArray;
        BitBuffer input = CTFPacketReaderTest.createBitBuffer(bytes);
        StreamInputPacketIndexEntry packetContext = new StreamInputPacketIndexEntry(0L, EMPTY_STRUCT.createDefinition(null, ILexicalScope.TRACE, new BitBuffer()), 8L, 0L, 0L);
        StructDeclaration eventHeaderDeclaration = new StructDeclaration(8L);
        eventHeaderDeclaration.addField("timestamp", (IDeclaration)IntegerDeclaration.INT_8_DECL);
        EventDeclaration eventDec = new EventDeclaration();
        eventDec.setName("Hello");
        StructDeclaration context = new StructDeclaration(8L);
        context.addField("field1", (IDeclaration)IntegerDeclaration.UINT_16L_DECL);
        StructDeclaration fields = new StructDeclaration(8L);
        fields.addField("field2", (IDeclaration)IntegerDeclaration.UINT_8_DECL);
        eventDec.setContext(context);
        eventDec.setFields(fields);
        eventDec.setLogLevel(5L);
        List<@Nullable EventDeclaration> declarations = Collections.singletonList(eventDec);
        CTFTrace trace = new CTFTrace();
        CTFPacketReader cpr = new CTFPacketReader(input, (ICTFPacketDescriptor)packetContext, declarations, (IDeclaration)eventHeaderDeclaration, null, null, (IDefinitionScope)trace);
        Assert.assertNotNull((Object)cpr);
        Assert.assertTrue((boolean)cpr.hasMoreEvents());
        EventDefinition event = cpr.readNextEvent();
        Assert.assertEquals((long)0L, (long)event.getTimestamp());
        Assert.assertEquals((long)0L, (long)((IntegerDefinition)event.getContext().getDefinition("field1")).getValue());
        Assert.assertEquals((long)0L, (long)((IntegerDefinition)event.getFields().getDefinition("field2")).getValue());
        Assert.assertNotNull((Object)cpr);
        Assert.assertTrue((boolean)cpr.hasMoreEvents());
        event = cpr.readNextEvent();
        Assert.assertEquals((long)1L, (long)event.getTimestamp());
        Assert.assertEquals((long)65535L, (long)((IntegerDefinition)event.getContext().getDefinition("field1")).getValue());
        Assert.assertEquals((long)165L, (long)((IntegerDefinition)event.getFields().getDefinition("field2")).getValue());
        Assert.assertFalse((boolean)cpr.hasMoreEvents());
    }

    @Test
    public void testPacketNoHeader() throws CTFException {
        byte[] byArray = new byte[8];
        byArray[4] = 1;
        byArray[5] = -1;
        byArray[6] = -1;
        byArray[7] = -91;
        byte[] bytes = byArray;
        BitBuffer input = CTFPacketReaderTest.createBitBuffer(bytes);
        StreamInputPacketIndexEntry packetContext = new StreamInputPacketIndexEntry(0L, new StructDeclaration(8L).createDefinition(null, ILexicalScope.TRACE, new BitBuffer()), 8L, 0L, 0L);
        EventDeclaration eventDec = new EventDeclaration();
        eventDec.setName("Hello");
        StructDeclaration fields = new StructDeclaration(8L);
        fields.addField("timestamp", (IDeclaration)IntegerDeclaration.INT_8_DECL);
        fields.addField("field1", (IDeclaration)IntegerDeclaration.UINT_16L_DECL);
        fields.addField("field2", (IDeclaration)IntegerDeclaration.UINT_8_DECL);
        eventDec.setFields(fields);
        List<@Nullable EventDeclaration> declarations = Collections.singletonList(eventDec);
        CTFTrace trace = new CTFTrace();
        CTFPacketReader cpr = new CTFPacketReader(input, (ICTFPacketDescriptor)packetContext, declarations, null, null, null, (IDefinitionScope)trace);
        Assert.assertNotNull((Object)cpr);
        Assert.assertTrue((boolean)cpr.hasMoreEvents());
        EventDefinition event = cpr.readNextEvent();
        Assert.assertEquals((long)0L, (long)event.getTimestamp());
        Assert.assertEquals((long)0L, (long)((IntegerDefinition)event.getFields().getDefinition("field1")).getValue());
        Assert.assertEquals((long)0L, (long)((IntegerDefinition)event.getFields().getDefinition("field2")).getValue());
        Assert.assertNotNull((Object)cpr);
        Assert.assertTrue((boolean)cpr.hasMoreEvents());
        event = cpr.readNextEvent();
        Assert.assertEquals((long)1L, (long)event.getTimestamp());
        Assert.assertEquals((long)65535L, (long)((IntegerDefinition)event.getFields().getDefinition("field1")).getValue());
        Assert.assertEquals((long)165L, (long)((IntegerDefinition)event.getFields().getDefinition("field2")).getValue());
        Assert.assertFalse((boolean)cpr.hasMoreEvents());
    }

    @Test
    public void testPacketWithPacketContextAndLostEvents() throws CTFException {
        byte[] byArray = new byte[8];
        byArray[1] = 2;
        byArray[4] = 1;
        byArray[6] = 1;
        byArray[7] = 90;
        byte[] bytes = byArray;
        BitBuffer input = CTFPacketReaderTest.createBitBuffer(bytes);
        StructDeclaration packetHeader = new StructDeclaration(8L);
        packetHeader.addField("events_discarded", (IDeclaration)IntegerDeclaration.UINT_16L_DECL);
        StreamInputPacketIndexEntry packetContext = new StreamInputPacketIndexEntry(0L, packetHeader.createDefinition(null, ILexicalScope.TRACE, input), 8L, 0L, 16L);
        EventDeclaration eventDec = new EventDeclaration();
        eventDec.setName("Hello");
        StructDeclaration fields = new StructDeclaration(8L);
        fields.addField("timestamp", (IDeclaration)IntegerDeclaration.UINT_16L_DECL);
        fields.addField("field", (IDeclaration)IntegerDeclaration.UINT_8_DECL);
        eventDec.setFields(fields);
        List<@Nullable EventDeclaration> declarations = Collections.singletonList(eventDec);
        CTFTrace trace = new CTFTrace();
        CTFPacketReader cpr = new CTFPacketReader(input, (ICTFPacketDescriptor)packetContext, declarations, null, null, null, (IDefinitionScope)trace);
        Assert.assertNotNull((Object)cpr);
        Assert.assertTrue((boolean)cpr.hasMoreEvents());
        EventDefinition event = cpr.readNextEvent();
        Assert.assertEquals((long)0L, (long)event.getTimestamp());
        Assert.assertEquals((long)1L, (long)((IntegerDefinition)event.getFields().getDefinition("field")).getValue());
        Assert.assertNotNull((Object)cpr);
        Assert.assertTrue((boolean)cpr.hasMoreEvents());
        event = cpr.readNextEvent();
        Assert.assertEquals((long)256L, (long)event.getTimestamp());
        Assert.assertEquals((long)90L, (long)((IntegerDefinition)event.getFields().getDefinition("field")).getValue());
        Assert.assertTrue((boolean)cpr.hasMoreEvents());
        event = cpr.readNextEvent();
        Assert.assertEquals((long)256L, (long)event.getTimestamp());
        Assert.assertEquals((Object)event.getDeclaration().getName(), (Object)"Lost event");
        Assert.assertEquals((long)512L, (long)((IntegerDefinition)event.getFields().getDefinition("Lost events")).getValue());
        Assert.assertFalse((boolean)cpr.hasMoreEvents());
    }
}

