/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.remote.internal.core.services.local;

import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteFileService;
import org.eclipse.remote.core.IRemoteProcessService;

public class LocalFileService
implements IRemoteFileService {
    private final IRemoteConnection connection;

    public LocalFileService(IRemoteConnection connection) {
        this.connection = connection;
    }

    @Override
    public IRemoteConnection getRemoteConnection() {
        return this.connection;
    }

    @Override
    public String getDirectorySeparator() {
        return System.getProperty("file.separator", "/");
    }

    @Override
    public IFileStore getResource(String path) {
        return EFS.getLocalFileSystem().getStore(Path.fromOSString((String)path));
    }

    @Override
    public String getBaseDirectory() {
        return this.connection.getService(IRemoteProcessService.class).getWorkingDirectory();
    }

    @Override
    public void setBaseDirectory(String path) {
        this.connection.getService(IRemoteProcessService.class).setWorkingDirectory(path);
    }

    @Override
    public String toPath(URI uri) {
        return URIUtil.toPath((URI)uri).toString();
    }

    @Override
    public URI toURI(IPath path) {
        return URIUtil.toURI((IPath)path);
    }

    @Override
    public URI toURI(String path) {
        return URIUtil.toURI((String)path);
    }

    public static class Factory
    implements IRemoteConnection.Service.Factory {
        @Override
        public <T extends IRemoteConnection.Service> T getService(IRemoteConnection remoteConnection, Class<T> service) {
            if (IRemoteFileService.class.equals(service)) {
                return (T)new LocalFileService(remoteConnection);
            }
            return null;
        }
    }
}

