/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl;

import com.google.gson.JsonObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.ctf.core.event.types.BlobDeclaration;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.ICommonTreeParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.JsonStructureFieldMemberMetadataNode;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.ParseException;
import org.eclipse.tracecompass.internal.ctf.core.event.types.ICTFMetadataNode;

public final class BlobDeclarationParser
implements ICommonTreeParser {
    public static final BlobDeclarationParser INSTANCE = new BlobDeclarationParser();
    private static final @NonNull String LENGTH = "length";
    private static final @NonNull String MEDIA_TYPE = "media-type";
    private static final String DEFAULT_MEDIA_TYPE = "application/octet-stream";

    private BlobDeclarationParser() {
    }

    @Override
    public BlobDeclaration parse(ICTFMetadataNode blob, ICommonTreeParser.ICommonTreeParserParameter unused) throws ParseException {
        long length = 0L;
        String mediaType = DEFAULT_MEDIA_TYPE;
        String role = null;
        JsonStructureFieldMemberMetadataNode member = (JsonStructureFieldMemberMetadataNode)blob;
        JsonObject fieldClass = member.getFieldClass().getAsJsonObject();
        length = fieldClass.get(LENGTH).getAsInt();
        if (length <= 0L) {
            throw new ParseException("Invalid length attribute in Blob: " + length);
        }
        if (fieldClass.has(mediaType)) {
            mediaType = fieldClass.get(MEDIA_TYPE).getAsString();
        }
        role = member.getRole();
        return new BlobDeclaration((int)length, mediaType, role);
    }
}

