/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.ShapeField;
import org.apache.lucene.document.XYShapeDocValuesField;
import org.apache.lucene.document.XYShapeDocValuesQuery;
import org.apache.lucene.document.XYShapeQuery;
import org.apache.lucene.geo.Tessellator;
import org.apache.lucene.geo.XYCircle;
import org.apache.lucene.geo.XYEncodingUtils;
import org.apache.lucene.geo.XYGeometry;
import org.apache.lucene.geo.XYLine;
import org.apache.lucene.geo.XYPoint;
import org.apache.lucene.geo.XYPolygon;
import org.apache.lucene.geo.XYRectangle;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;

public class XYShape {
    private XYShape() {
    }

    public static Field[] createIndexableFields(String fieldName, XYPolygon polygon) {
        return XYShape.createIndexableFields(fieldName, polygon, false);
    }

    public static XYShapeDocValuesField createDocValueField(String fieldName, XYPolygon polygon) {
        return XYShape.createDocValueField(fieldName, polygon, false);
    }

    public static Field[] createIndexableFields(String fieldName, XYPolygon polygon, boolean checkSelfIntersections) {
        List<Tessellator.Triangle> tessellation = Tessellator.tessellate(polygon, checkSelfIntersections);
        Field[] fields = new ShapeField.Triangle[tessellation.size()];
        for (int i = 0; i < tessellation.size(); ++i) {
            fields[i] = new ShapeField.Triangle(fieldName, tessellation.get(i));
        }
        return fields;
    }

    public static XYShapeDocValuesField createDocValueField(String fieldName, XYPolygon polygon, boolean checkSelfIntersections) {
        List<Tessellator.Triangle> tessellation = Tessellator.tessellate(polygon, checkSelfIntersections);
        ArrayList<ShapeField.DecodedTriangle> triangles = new ArrayList<ShapeField.DecodedTriangle>(tessellation.size());
        for (Tessellator.Triangle t : tessellation) {
            ShapeField.DecodedTriangle dt = new ShapeField.DecodedTriangle();
            dt.type = ShapeField.DecodedTriangle.TYPE.TRIANGLE;
            dt.setValues(t.getEncodedX(0), t.getEncodedY(0), t.isEdgefromPolygon(0), t.getEncodedX(1), t.getEncodedY(1), t.isEdgefromPolygon(0), t.getEncodedX(2), t.getEncodedY(2), t.isEdgefromPolygon(2));
            triangles.add(dt);
        }
        return new XYShapeDocValuesField(fieldName, triangles);
    }

    public static Field[] createIndexableFields(String fieldName, XYLine line) {
        int numPoints = line.numPoints();
        Field[] fields = new Field[numPoints - 1];
        int i = 0;
        for (int j = 1; j < numPoints; ++j) {
            fields[i] = new ShapeField.Triangle(fieldName, XYEncodingUtils.encode(line.getX(i)), XYEncodingUtils.encode(line.getY(i)), XYEncodingUtils.encode(line.getX(j)), XYEncodingUtils.encode(line.getY(j)), XYEncodingUtils.encode(line.getX(i)), XYEncodingUtils.encode(line.getY(i)));
            ++i;
        }
        return fields;
    }

    public static XYShapeDocValuesField createDocValueField(String fieldName, XYLine line) {
        int numPoints = line.numPoints();
        ArrayList<ShapeField.DecodedTriangle> triangles = new ArrayList<ShapeField.DecodedTriangle>(numPoints - 1);
        int i = 0;
        for (int j = 1; j < numPoints; ++j) {
            ShapeField.DecodedTriangle t = new ShapeField.DecodedTriangle();
            t.type = ShapeField.DecodedTriangle.TYPE.LINE;
            t.setValues(XYEncodingUtils.encode(line.getX(i)), XYEncodingUtils.encode(line.getY(i)), true, XYEncodingUtils.encode(line.getX(j)), XYEncodingUtils.encode(line.getY(j)), true, XYEncodingUtils.encode(line.getX(i)), XYEncodingUtils.encode(line.getY(i)), true);
            triangles.add(t);
            ++i;
        }
        return new XYShapeDocValuesField(fieldName, triangles);
    }

    public static Field[] createIndexableFields(String fieldName, float x, float y) {
        return new Field[]{new ShapeField.Triangle(fieldName, XYEncodingUtils.encode(x), XYEncodingUtils.encode(y), XYEncodingUtils.encode(x), XYEncodingUtils.encode(y), XYEncodingUtils.encode(x), XYEncodingUtils.encode(y))};
    }

    public static XYShapeDocValuesField createDocValueField(String fieldName, float x, float y) {
        ArrayList<ShapeField.DecodedTriangle> triangles = new ArrayList<ShapeField.DecodedTriangle>(1);
        ShapeField.DecodedTriangle t = new ShapeField.DecodedTriangle();
        t.type = ShapeField.DecodedTriangle.TYPE.POINT;
        t.setValues(XYEncodingUtils.encode(x), XYEncodingUtils.encode(y), true, XYEncodingUtils.encode(x), XYEncodingUtils.encode(y), true, XYEncodingUtils.encode(x), XYEncodingUtils.encode(y), true);
        triangles.add(t);
        return new XYShapeDocValuesField(fieldName, triangles);
    }

    public static XYShapeDocValuesField createDocValueField(String fieldName, BytesRef binaryValue) {
        return new XYShapeDocValuesField(fieldName, binaryValue);
    }

    public static XYShapeDocValuesField createDocValueField(String fieldName, List<ShapeField.DecodedTriangle> tessellation) {
        return new XYShapeDocValuesField(fieldName, tessellation);
    }

    public static Query newBoxQuery(String field, ShapeField.QueryRelation queryRelation, float minX, float maxX, float minY, float maxY) {
        XYRectangle rectangle = new XYRectangle(minX, maxX, minY, maxY);
        return XYShape.newGeometryQuery(field, queryRelation, rectangle);
    }

    public static Query newSlowDocValuesBoxQuery(String field, ShapeField.QueryRelation queryRelation, float minX, float maxX, float minY, float maxY) {
        return new XYShapeDocValuesQuery(field, queryRelation, new XYRectangle(minX, maxX, minY, maxY));
    }

    public static Query newLineQuery(String field, ShapeField.QueryRelation queryRelation, XYLine ... lines) {
        return XYShape.newGeometryQuery(field, queryRelation, lines);
    }

    public static Query newPolygonQuery(String field, ShapeField.QueryRelation queryRelation, XYPolygon ... polygons) {
        return XYShape.newGeometryQuery(field, queryRelation, polygons);
    }

    public static Query newPointQuery(String field, ShapeField.QueryRelation queryRelation, float[] ... points) {
        XYGeometry[] pointArray = new XYPoint[points.length];
        for (int i = 0; i < points.length; ++i) {
            pointArray[i] = new XYPoint(points[i][0], points[i][1]);
        }
        return XYShape.newGeometryQuery(field, queryRelation, pointArray);
    }

    public static Query newDistanceQuery(String field, ShapeField.QueryRelation queryRelation, XYCircle ... circle) {
        return XYShape.newGeometryQuery(field, queryRelation, circle);
    }

    public static Query newGeometryQuery(String field, ShapeField.QueryRelation queryRelation, XYGeometry ... xyGeometries) {
        if (queryRelation == ShapeField.QueryRelation.CONTAINS && xyGeometries.length > 1) {
            BooleanQuery.Builder builder = new BooleanQuery.Builder();
            for (int i = 0; i < xyGeometries.length; ++i) {
                builder.add(XYShape.newGeometryQuery(field, queryRelation, xyGeometries[i]), BooleanClause.Occur.MUST);
            }
            return new ConstantScoreQuery(builder.build());
        }
        return new XYShapeQuery(field, queryRelation, xyGeometries);
    }
}

