/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.browser;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.browser.WebBrowserUIPlugin;
import org.eclipse.ui.internal.browser.WebBrowserUtil;
import org.osgi.service.prefs.BackingStoreException;

public class WebBrowserPreference {
    protected static final String PREF_BROWSER_HISTORY = "webBrowserHistory";
    protected static final String PREF_INTERNAL_WEB_BROWSER_HISTORY = "internalWebBrowserHistory";
    protected static final String PREF_BROWSER_CHOICE = "browser-choice";
    private static final String INTERNAL_BROWSER_ID = "org.eclipse.ui.browser.editor";
    private static final String BROWSER_SUPPORT_ID = "org.eclipse.ui.browser.editorSupport";
    public static final int INTERNAL = 0;
    public static final int EXTERNAL = 1;

    private WebBrowserPreference() {
    }

    protected static IPreferenceStore getPreferenceStore() {
        return WebBrowserUIPlugin.getInstance().getPreferenceStore();
    }

    public static List<String> getInternalWebBrowserHistory() {
        String temp = WebBrowserPreference.getPreferenceStore().getString(PREF_INTERNAL_WEB_BROWSER_HISTORY);
        StringTokenizer st = new StringTokenizer(temp, "|*|");
        ArrayList<String> l = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            l.add(s);
        }
        return l;
    }

    public static void setInternalWebBrowserHistory(List<String> list) {
        StringBuilder sb = new StringBuilder();
        if (list != null) {
            for (String s : list) {
                sb.append(s);
                sb.append("|*|");
            }
        }
        IScopeContext instanceScope = InstanceScope.INSTANCE;
        IEclipsePreferences prefs = instanceScope.getNode("org.eclipse.ui.browser");
        prefs.put(PREF_INTERNAL_WEB_BROWSER_HISTORY, sb.toString());
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            WebBrowserUIPlugin.logError(e.getMessage(), e);
        }
    }

    public static boolean isDefaultUseInternalBrowser() {
        return WebBrowserUtil.canUseInternalWebBrowser();
    }

    public static boolean isDefaultUseSystemBrowser() {
        return WebBrowserUtil.canUseSystemBrowser();
    }

    public static int getBrowserChoice() {
        int choice = WebBrowserPreference.getPreferenceStore().getInt(PREF_BROWSER_CHOICE);
        if (choice == 2) {
            return 1;
        }
        if (choice == 0 && !WebBrowserUtil.canUseInternalWebBrowser()) {
            return 1;
        }
        return choice;
    }

    public static void setBrowserChoice(int choice) {
        IScopeContext instanceScope = InstanceScope.INSTANCE;
        IEclipsePreferences prefs = instanceScope.getNode("org.eclipse.ui.browser");
        prefs.putInt(PREF_BROWSER_CHOICE, choice);
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            WebBrowserUIPlugin.logError(e.getMessage(), e);
        }
        WebBrowserPreference.updateDefaultEditor(choice);
    }

    private static void updateDefaultEditor(int choice) {
        String[][] extensions;
        IEditorRegistry registry = PlatformUI.getWorkbench().getEditorRegistry();
        String oldId = choice == 0 ? BROWSER_SUPPORT_ID : INTERNAL_BROWSER_ID;
        String newId = choice == 0 ? INTERNAL_BROWSER_ID : BROWSER_SUPPORT_ID;
        String[][] stringArrayArray = extensions = new String[][]{{"a.html", "*.html"}, {"a.htm", "*.htm"}, {"a.shtml", "*.shtml"}};
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            String[] ext = stringArrayArray[n2];
            IEditorDescriptor ddesc = registry.getDefaultEditor(ext[0]);
            if (ddesc != null && ddesc.getId().equals(oldId)) {
                registry.setDefaultEditor(ext[1], newId);
            }
            ++n2;
        }
    }
}

