/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.internal.ui;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.part.IContributedContentsView;
import org.eclipse.wst.validation.internal.ConfigurationManager;
import org.eclipse.wst.validation.internal.DisabledResourceManager;
import org.eclipse.wst.validation.internal.ValManager;
import org.eclipse.wst.validation.internal.ValType;
import org.eclipse.wst.validation.internal.ValidationSelectionHandlerRegistryReader;
import org.eclipse.wst.validation.internal.ui.SaveFilesDialog;
import org.eclipse.wst.validation.internal.ui.SaveFilesHelper;
import org.eclipse.wst.validation.internal.ui.ValidateAction;
import org.eclipse.wst.validation.internal.ui.ValidationUIMessages;
import org.eclipse.wst.validation.internal.ui.plugin.ValidationUIPlugin;
import org.eclipse.wst.validation.ui.internal.ManualValidationRunner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidationHandler
extends AbstractHandler {
    private IResourceVisitor _folderVisitor;
    private IResourceVisitor _projectVisitor;
    private Map<IProject, Set<IResource>> _selectedResources = new HashMap<IProject, Set<IResource>>();

    void addSelected(IResource selected) {
        IProject project = selected.getProject();
        boolean added = this._selectedResources.containsKey(project);
        Set<IResource> changedRes = null;
        if (added) {
            changedRes = this._selectedResources.get(project);
            if (changedRes == null) {
                return;
            }
        } else {
            changedRes = new HashSet<IResource>();
        }
        if (changedRes.add(selected)) {
            this._selectedResources.put(project, changedRes);
        }
    }

    private void addSelected(ValidateAction action, Object selected) {
        if (selected instanceof IProject) {
            this.addVisitor((IProject)selected);
        } else if (selected instanceof IFile) {
            this.addSelected((IResource)((IFile)selected));
        } else if (selected instanceof IFolder) {
            this.addVisitor((IFolder)selected);
        } else if (this.isValidType(this.getExtendedType(selected))) {
            this.addSelected(action, this.getExtendedType(selected));
        } else {
            IResource resource;
            IResource[] resources;
            boolean valid = false;
            if (action != null && (resources = action.getResource(selected)) != null) {
                valid = true;
                int i = 0;
                while (i < resources.length) {
                    this.addSelected(action, resources[i]);
                    ++i;
                }
            }
            if (!valid && (resource = (IResource)Platform.getAdapterManager().getAdapter(selected, IResource.class)) != null) {
                valid = true;
                this.addSelected(action, resource);
            }
            if (!valid) {
                this._selectedResources.clear();
            }
        }
    }

    private void addVisitor(IFolder selected) {
        try {
            selected.accept(this.getFolderVisitor());
        }
        catch (CoreException exc) {
            ValidationUIPlugin.getPlugin().handleException(exc);
            return;
        }
    }

    private void addVisitor(IProject selected) {
        if (!selected.isAccessible()) {
            return;
        }
        try {
            selected.accept(this.getProjectVisitor());
        }
        catch (CoreException exc) {
            ValidationUIPlugin.getPlugin().handleException(exc);
            return;
        }
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Shell activeShell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        IWorkbenchPart interestedPart = HandlerUtil.getActivePart((ExecutionEvent)event);
        IStructuredSelection sel = HandlerUtil.getCurrentStructuredSelection((ExecutionEvent)event);
        Map<IProject, Set<IResource>> projects = this.loadSelected(sel);
        if (projects == null || projects.isEmpty()) {
            IResource resource;
            IEditorInput editorInput;
            IContributedContentsView contributedContentsView;
            if (!(interestedPart instanceof IEditorPart) && (contributedContentsView = (IContributedContentsView)interestedPart.getAdapter(IContributedContentsView.class)) != null) {
                interestedPart = contributedContentsView.getContributingPart();
            }
            if (interestedPart instanceof IEditorPart && (editorInput = HandlerUtil.getActiveEditorInput((ExecutionEvent)event)) != null && (resource = (IResource)editorInput.getAdapter(IResource.class)) != null) {
                sel = new StructuredSelection((Object)resource);
            }
            projects = this.loadSelected(sel);
        }
        if (projects == null || projects.isEmpty()) {
            return null;
        }
        if (!this.handleFilesToSave(projects, activeShell)) {
            return null;
        }
        boolean confirm = ValManager.getDefault().getGlobalPreferences().getConfirmDialog();
        ManualValidationRunner.validate(projects, ValType.Manual, confirm);
        return null;
    }

    private Object getExtendedType(Object selected) {
        Object result = ValidationSelectionHandlerRegistryReader.getInstance().getExtendedType(selected);
        return result == null ? selected : result;
    }

    private IResourceVisitor getFolderVisitor() {
        if (this._folderVisitor == null) {
            this._folderVisitor = new IResourceVisitor(){

                public boolean visit(IResource res) {
                    if (res instanceof IFile) {
                        ValidationHandler.this.addSelected(res);
                    } else if (res instanceof IFolder) {
                        ValidationHandler.this.addSelected(res);
                    }
                    return true;
                }
            };
        }
        return this._folderVisitor;
    }

    protected List<IFile> getIFiles(Map<IProject, Set<IResource>> projects) {
        LinkedList<IFile> fileList = new LinkedList<IFile>();
        for (IProject project : projects.keySet()) {
            for (IResource resource : projects.get(project)) {
                if (!(resource instanceof IFile)) continue;
                fileList.add((IFile)resource);
            }
        }
        return fileList;
    }

    private IResourceVisitor getProjectVisitor() {
        if (this._projectVisitor == null) {
            this._projectVisitor = new IResourceVisitor(){

                public boolean visit(IResource res) {
                    if (DisabledResourceManager.getDefault().isDisabled(res)) {
                        return false;
                    }
                    if (res instanceof IFile) {
                        ValidationHandler.this.addSelected(res);
                    } else if (res instanceof IFolder) {
                        ValidationHandler.this.addSelected(res);
                    } else if (res instanceof IProject) {
                        ValidationHandler.this.addSelected(res);
                    }
                    return true;
                }
            };
        }
        return this._projectVisitor;
    }

    protected boolean handleFilesToSave(Map<IProject, Set<IResource>> projects, Shell shell) {
        List<IFile> fileList = this.getIFiles(projects);
        final IEditorPart[] dirtyEditors = SaveFilesHelper.getDirtyEditors(fileList);
        if (dirtyEditors == null || dirtyEditors.length == 0) {
            return true;
        }
        boolean saveAutomatically = false;
        try {
            saveAutomatically = ConfigurationManager.getManager().getGlobalConfiguration().getSaveAutomatically();
        }
        catch (InvocationTargetException invocationTargetException) {}
        SaveFilesDialog sfDialog = null;
        if (!saveAutomatically) {
            sfDialog = new SaveFilesDialog(ValidationUIPlugin.getPlugin().getWorkbench().getActiveWorkbenchWindow().getShell());
            sfDialog.setInput(Arrays.asList(dirtyEditors));
        }
        if (saveAutomatically || sfDialog.open() == 0) {
            ProgressMonitorDialog ctx = new ProgressMonitorDialog(shell);
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        SubMonitor submonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)ValidationUIMessages.SaveFilesDialog_saving, (int)dirtyEditors.length);
                        int i = 0;
                        while (i < dirtyEditors.length) {
                            dirtyEditors[i].doSave((IProgressMonitor)submonitor.newChild(1));
                            ++i;
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            };
            try {
                ctx.run(false, true, runnable);
                return true;
            }
            catch (InvocationTargetException e) {
                ValidationUIPlugin.getPlugin().handleException(e);
            }
            catch (InterruptedException e) {
                ValidationUIPlugin.getPlugin().handleException(e);
            }
        }
        return false;
    }

    private boolean isValidType(Object object) {
        return object instanceof IProject || object instanceof IFile || object instanceof IFolder;
    }

    private Map<IProject, Set<IResource>> loadSelected(IStructuredSelection selection) {
        Object[] elements;
        this._selectedResources.clear();
        if (selection == null || selection.isEmpty()) {
            return null;
        }
        Object[] objectArray = elements = selection.toArray();
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element != null) {
                this.addSelected(null, element);
            }
            ++n2;
        }
        return this._selectedResources;
    }
}

