/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.ctf.core.event.types;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.ctf.core.CTFException;
import org.eclipse.tracecompass.ctf.core.event.io.BitBuffer;
import org.eclipse.tracecompass.ctf.core.event.scope.IDefinitionScope;
import org.eclipse.tracecompass.ctf.core.event.scope.ILexicalScope;
import org.eclipse.tracecompass.ctf.core.event.types.Declaration;
import org.eclipse.tracecompass.ctf.core.event.types.Definition;
import org.eclipse.tracecompass.ctf.core.event.types.ICompositeDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.IDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.IDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.StructDefinition;
import org.eclipse.tracecompass.internal.ctf.core.CtfCoreLoggerUtil;

public class StructDeclaration
extends Declaration {
    private @NonNull String[] fFieldNames;
    private @NonNull IDeclaration[] fFields;
    private long fMaxAlign;
    private static final Pattern EVENT_HEADER = Pattern.compile(String.valueOf(ILexicalScope.EVENT_HEADER.getPath().replaceAll("\\.", "\\\\.")) + "\\.");

    public StructDeclaration(long align) {
        this.fMaxAlign = Math.max(align, 1L);
        this.fFieldNames = new String[0];
        this.fFields = new IDeclaration[0];
    }

    public long getMaxAlign() {
        return this.fMaxAlign;
    }

    public boolean hasField(String name) {
        return Arrays.asList(this.fFieldNames).contains(name);
    }

    public @Nullable IDeclaration getField(String fieldName) {
        int indexOf = Arrays.asList(this.fFieldNames).indexOf(fieldName);
        if (indexOf == -1) {
            return null;
        }
        return this.fFields[indexOf];
    }

    public @NonNull Iterable<@NonNull String> getFieldsList() {
        return Arrays.asList(this.fFieldNames);
    }

    @Override
    public long getAlignment() {
        return this.fMaxAlign;
    }

    @Override
    public int getMaximumSize() {
        long maxSize = 0L;
        IDeclaration[] iDeclarationArray = this.fFields;
        int n = this.fFields.length;
        int n2 = 0;
        while (n2 < n) {
            IDeclaration field = iDeclarationArray[n2];
            maxSize += (long)field.getMaximumSize();
            ++n2;
        }
        return (int)Math.min(maxSize, Integer.MAX_VALUE);
    }

    @Override
    public StructDefinition createDefinition(IDefinitionScope definitionScope, String fieldName, BitBuffer input) throws CTFException {
        this.alignRead(input);
        IDefinition[] myFields = new Definition[this.fFields.length];
        StructDefinition structDefinition = null;
        if (definitionScope == null) {
            InternalDef localDefinitionScope = new InternalDef(null, null);
            structDefinition = new StructDefinition(this, (IDefinitionScope)localDefinitionScope, fieldName, (Definition[])myFields);
            localDefinitionScope.setDefinition(structDefinition);
        } else {
            structDefinition = new StructDefinition(this, definitionScope, fieldName, (Definition[])myFields);
        }
        this.fillStruct(input, myFields, structDefinition);
        return structDefinition;
    }

    public StructDefinition createDefinition(IDefinitionScope definitionScope, ILexicalScope fieldScope, @NonNull BitBuffer input) throws CTFException {
        this.alignRead(input);
        IDefinition[] myFields = new Definition[this.fFields.length];
        StructDefinition structDefinition = new StructDefinition(this, definitionScope, fieldScope, fieldScope.getName(), Arrays.asList(this.fFieldNames), (Definition[])myFields);
        this.fillStruct(input, myFields, structDefinition);
        return structDefinition;
    }

    public void addField(@NonNull String name, @NonNull IDeclaration declaration) {
        if (this.hasField(name)) {
            CtfCoreLoggerUtil.logWarning("Struct already contains a field named " + name);
            return;
        }
        int length = this.fFieldNames.length;
        @NonNull String[] names = Arrays.copyOf(this.fFieldNames, length + 1);
        @NonNull IDeclaration[] fields = Arrays.copyOf(this.fFields, length + 1);
        names[length] = name;
        fields[length] = declaration;
        this.fFieldNames = names;
        this.fFields = fields;
        this.fMaxAlign = Math.max(this.fMaxAlign, declaration.getAlignment());
    }

    private void fillStruct(@NonNull BitBuffer input, IDefinition[] myFields, StructDefinition structDefinition) throws CTFException {
        @NonNull String[] fieldNames = this.fFieldNames;
        @NonNull IDeclaration[] fields = this.fFields;
        int i = 0;
        while (i < fields.length) {
            myFields[i] = fields[i].createDefinition(structDefinition, fieldNames[i], input);
            ++i;
        }
    }

    public StructDefinition createFieldDefinition(ICompositeDefinition eventHeaderDef, IDefinitionScope definitionScope, ILexicalScope fields, @NonNull BitBuffer input) throws CTFException {
        this.alignRead(input);
        IDefinition[] myFields = new Definition[this.fFields.length];
        IDefinitionScope merged = definitionScope;
        if (eventHeaderDef != null) {
            merged = new InternalDef(definitionScope, eventHeaderDef);
        }
        StructDefinition structDefinition = new StructDefinition(this, merged, fields, fields.getName(), Arrays.asList(this.fFieldNames), (Definition[])myFields);
        if (merged instanceof InternalDef) {
            InternalDef internalDef = (InternalDef)merged;
            internalDef.setDefinition(structDefinition);
        }
        this.fillStruct(input, myFields, structDefinition);
        return structDefinition;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[declaration] struct[");
        int i = 0;
        while (i < this.fFields.length) {
            sb.append(this.fFieldNames[i]).append(':').append(this.fFields[i]);
            ++i;
        }
        sb.append(']');
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        int i = 0;
        while (i < this.fFields.length) {
            result = 31 * result + this.fFieldNames[i].hashCode();
            result = 31 * result + this.fFields[i].hashCode();
            ++i;
        }
        result = 31 * result + (int)(this.fMaxAlign ^ this.fMaxAlign >>> 32);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StructDeclaration)) {
            return false;
        }
        StructDeclaration other = (StructDeclaration)obj;
        if (this.fFields.length != other.fFields.length) {
            return false;
        }
        List<String> localFieldNames = Arrays.asList(this.fFieldNames);
        List<IDeclaration> localDecs = Arrays.asList(this.fFields);
        List<String> otherFieldNames = Arrays.asList(other.fFieldNames);
        List<IDeclaration> otherDecs = Arrays.asList(other.fFields);
        int i = 0;
        while (i < this.fFields.length) {
            if (!localFieldNames.get(i).equals(otherFieldNames.get(i)) || !otherDecs.get(i).equals(localDecs.get(i))) {
                return false;
            }
            ++i;
        }
        return this.fMaxAlign == other.fMaxAlign;
    }

    @Override
    public boolean isBinaryEquivalent(IDeclaration obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StructDeclaration)) {
            return false;
        }
        StructDeclaration other = (StructDeclaration)obj;
        if (this.fFields.length != other.fFields.length) {
            return false;
        }
        List<IDeclaration> localDecs = Arrays.asList(this.fFields);
        List<IDeclaration> otherDecs = Arrays.asList(other.fFields);
        int i = 0;
        while (i < this.fFields.length) {
            if (!otherDecs.get(i).isBinaryEquivalent(localDecs.get(i))) {
                return false;
            }
            ++i;
        }
        return this.fMaxAlign == other.fMaxAlign;
    }

    static class InternalDef
    implements IDefinitionScope {
        private final ICompositeDefinition fEventHeaderDef;
        private final IDefinitionScope fTraceDef;
        private StructDefinition fDefinition;

        public InternalDef(IDefinitionScope definitionScope, ICompositeDefinition eventHeaderDef) {
            this.fTraceDef = definitionScope;
            this.fEventHeaderDef = eventHeaderDef;
        }

        @Override
        public ILexicalScope getScopePath() {
            return ILexicalScope.EVENT;
        }

        @Override
        public IDefinition lookupDefinition(String lookupPath) {
            IDefinition lookupDefinition = null;
            if (this.fTraceDef != null) {
                lookupDefinition = this.fTraceDef.lookupDefinition(lookupPath);
            }
            if (lookupDefinition == null && this.fEventHeaderDef != null) {
                String[] paths = EVENT_HEADER.split(lookupPath);
                if (paths.length > 1) {
                    String[] childLookup = paths[1].split("\\.");
                    return this.getRecursiveDef(this.fEventHeaderDef.getDefinition(childLookup[0]), childLookup, 1);
                }
                if (this.fDefinition != null) {
                    return this.fDefinition.lookupDefinition(lookupPath);
                }
            }
            return lookupDefinition;
        }

        public IDefinition lookupDefinitionBreakLoop(String lookupPath) {
            String[] paths;
            IDefinition lookupDefinition = null;
            if (this.fTraceDef != null) {
                lookupDefinition = this.fTraceDef.lookupDefinition(lookupPath);
            }
            if (lookupDefinition == null && this.fEventHeaderDef != null && (paths = EVENT_HEADER.split(lookupPath)).length > 1) {
                String[] childLookup = paths[1].split("\\.");
                return this.getRecursiveDef(this.fEventHeaderDef.getDefinition(childLookup[0]), childLookup, 1);
            }
            return lookupDefinition;
        }

        private IDefinition getRecursiveDef(Definition definition, String[] childLookup, int i) {
            if (i == childLookup.length) {
                return definition;
            }
            if (definition instanceof ICompositeDefinition) {
                ICompositeDefinition compositeDefinition = (ICompositeDefinition)((Object)definition);
                return this.getRecursiveDef(compositeDefinition.getDefinition(childLookup[i]), childLookup, i + 1);
            }
            return null;
        }

        public void setDefinition(StructDefinition definition) {
            this.fDefinition = definition;
        }
    }
}

