/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.dialogs;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.ui.ProvUIActivator;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.p2.ui.viewers.CertificateLabelProvider;
import org.eclipse.equinox.internal.provisional.security.ui.X509CertificateViewDialog;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeNode;
import org.eclipse.jface.viewers.TreeNodeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.SelectionDialog;

public class TrustCertificateDialog
extends SelectionDialog {
    private Object inputElement;
    private IStructuredContentProvider contentProvider;
    private ILabelProvider labelProvider;
    private static final int SIZING_SELECTION_WIDGET_HEIGHT = 250;
    private static final int SIZING_SELECTION_WIDGET_WIDTH = 300;
    CheckboxTableViewer listViewer;
    private TreeViewer certificateChainViewer;
    private Button detailsButton;
    protected TreeNode parentElement;
    protected Object selectedCertificate;

    public TrustCertificateDialog(Shell parentShell, Object input, ILabelProvider labelProvider, ITreeContentProvider contentProvider) {
        super(parentShell);
        this.inputElement = input;
        this.contentProvider = contentProvider;
        this.labelProvider = labelProvider;
        this.setTitle(ProvUIMessages.TrustCertificateDialog_Title);
        this.setMessage(ProvUIMessages.TrustCertificateDialog_Message);
        this.setShellStyle(0x870 | TrustCertificateDialog.getDefaultOrientation());
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = this.createUpperDialogArea(parent);
        this.certificateChainViewer = new TreeViewer(composite, 2048);
        GridLayout layout = new GridLayout();
        this.certificateChainViewer.getTree().setLayout((Layout)layout);
        GridData data = new GridData(1808);
        data.grabExcessHorizontalSpace = true;
        this.certificateChainViewer.getTree().setLayoutData((Object)data);
        this.certificateChainViewer.setAutoExpandLevel(-1);
        this.certificateChainViewer.setContentProvider((IContentProvider)new TreeNodeContentProvider());
        this.certificateChainViewer.setLabelProvider((IBaseLabelProvider)new CertificateLabelProvider());
        this.certificateChainViewer.addSelectionChangedListener(this.getChainSelectionListener());
        if (this.inputElement instanceof Object[]) {
            StructuredSelection selection = null;
            Object[] nodes = (Object[])this.inputElement;
            if (nodes.length > 0) {
                selection = new StructuredSelection(nodes[0]);
                this.certificateChainViewer.setInput((Object)new TreeNode[]{(TreeNode)nodes[0]});
                this.selectedCertificate = nodes[0];
            }
            this.listViewer.setSelection(selection);
        }
        this.listViewer.addDoubleClickListener(this.getDoubleClickListener());
        this.listViewer.addSelectionChangedListener(this.getParentSelectionListener());
        this.createButtons(composite);
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, ProvUIMessages.TrustCertificateDialog_AcceptSelectedButtonLabel, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        super.getOkButton().setEnabled(false);
    }

    private void createButtons(Composite composite) {
        Composite buttonComposite = new Composite(composite, 0);
        buttonComposite.setLayout((Layout)new RowLayout());
        this.detailsButton = new Button(buttonComposite, 0);
        this.detailsButton.setText(ProvUIMessages.TrustCertificateDialog_Details);
        this.detailsButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                Object o = TrustCertificateDialog.this.selectedCertificate;
                if (TrustCertificateDialog.this.selectedCertificate instanceof TreeNode) {
                    o = ((TreeNode)TrustCertificateDialog.this.selectedCertificate).getValue();
                }
                if (o instanceof X509Certificate) {
                    X509Certificate cert = (X509Certificate)o;
                    X509CertificateViewDialog certificateDialog = new X509CertificateViewDialog(TrustCertificateDialog.this.getShell(), cert);
                    certificateDialog.open();
                }
            }

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }
        });
        Button exportButton = new Button(buttonComposite, 0);
        exportButton.setText(ProvUIMessages.TrustCertificateDialog_Export);
        exportButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                Object o = TrustCertificateDialog.this.selectedCertificate;
                if (TrustCertificateDialog.this.selectedCertificate instanceof TreeNode) {
                    o = ((TreeNode)TrustCertificateDialog.this.selectedCertificate).getValue();
                }
                if (o instanceof X509Certificate) {
                    X509Certificate cert = (X509Certificate)o;
                    FileDialog destination = new FileDialog(TrustCertificateDialog.this.detailsButton.getShell(), 8192);
                    destination.setFilterExtensions(new String[]{"*.der"});
                    destination.setText(ProvUIMessages.TrustCertificateDialog_Export);
                    String path = destination.open();
                    if (path == null) {
                        return;
                    }
                    File destinationFile = new File(path);
                    try {
                        Throwable throwable = null;
                        Object var8_10 = null;
                        try (FileOutputStream output = new FileOutputStream(destinationFile);){
                            output.write(cert.getEncoded());
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (IOException | CertificateEncodingException ex) {
                        ProvUIActivator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.equinox.p2.ui", ex.getMessage(), (Throwable)ex));
                    }
                }
            }

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }
        });
    }

    private Composite createUpperDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.initializeDialogUnits((Control)composite);
        this.createMessageArea(composite);
        this.listViewer = CheckboxTableViewer.newCheckList((Composite)composite, (int)2048);
        GridData data = new GridData(1808);
        data.heightHint = 250;
        data.widthHint = 300;
        this.listViewer.getTable().setLayoutData((Object)data);
        this.listViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.listViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.addSelectionButtons(composite);
        this.listViewer.setInput(this.inputElement);
        if (!this.getInitialElementSelections().isEmpty()) {
            this.checkInitialSelections();
        }
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    private void checkInitialSelections() {
        Iterator itemsToCheck = this.getInitialElementSelections().iterator();
        while (itemsToCheck.hasNext()) {
            this.listViewer.setChecked(itemsToCheck.next(), true);
        }
    }

    private void addSelectionButtons(Composite composite) {
        Composite buttonComposite = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        buttonComposite.setLayout((Layout)layout);
        buttonComposite.setLayoutData((Object)new GridData(0x1000008, 128, true, false));
        Button selectButton = this.createButton(buttonComposite, 18, ProvUIMessages.TrustCertificateDialog_SelectAll, false);
        SelectionListener listener = SelectionListener.widgetSelectedAdapter(e -> {
            this.listViewer.setAllChecked(true);
            this.getOkButton().setEnabled(true);
        });
        selectButton.addSelectionListener(listener);
        Button deselectButton = this.createButton(buttonComposite, 19, ProvUIMessages.TrustCertificateDialog_DeselectAll, false);
        listener = SelectionListener.widgetSelectedAdapter(e -> {
            this.listViewer.setAllChecked(false);
            this.getOkButton().setEnabled(false);
        });
        deselectButton.addSelectionListener(listener);
    }

    private ISelectionChangedListener getChainSelectionListener() {
        return event -> {
            ISelection selection = event.getSelection();
            if (selection instanceof StructuredSelection) {
                this.selectedCertificate = ((StructuredSelection)selection).getFirstElement();
            }
        };
    }

    public TreeViewer getCertificateChainViewer() {
        return this.certificateChainViewer;
    }

    private IDoubleClickListener getDoubleClickListener() {
        return event -> {
            StructuredSelection selection = (StructuredSelection)event.getSelection();
            Object selectedElement = selection.getFirstElement();
            if (selectedElement instanceof TreeNode) {
                TreeNode treeNode = (TreeNode)selectedElement;
                X509CertificateViewDialog certificateViewDialog = new X509CertificateViewDialog(this.getShell(), (X509Certificate)treeNode.getValue());
                certificateViewDialog.open();
            }
        };
    }

    private ISelectionChangedListener getParentSelectionListener() {
        return event -> {
            ISelection selection = event.getSelection();
            if (selection instanceof StructuredSelection) {
                TreeNode firstElement = (TreeNode)((StructuredSelection)selection).getFirstElement();
                this.getCertificateChainViewer().setInput((Object)new TreeNode[]{firstElement});
                this.getOkButton().setEnabled(this.listViewer.getChecked((Object)firstElement));
                this.getCertificateChainViewer().refresh();
            }
        };
    }

    protected void okPressed() {
        Object[] children = this.contentProvider.getElements(this.inputElement);
        if (children != null) {
            ArrayList<Object> list = new ArrayList<Object>();
            Object[] objectArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                if (this.listViewer.getChecked(element)) {
                    list.add(element);
                }
                ++n2;
            }
            this.setResult(list);
        }
        super.okPressed();
    }
}

