/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.views.shell.dropins;

import java.time.Duration;
import org.eclipse.ease.IExecutionListener;
import org.eclipse.ease.IReplEngine;
import org.eclipse.ease.IScriptEngine;
import org.eclipse.ease.IScriptEngineProvider;
import org.eclipse.ease.Script;
import org.eclipse.ease.ui.views.shell.dropins.IShellDropin;
import org.eclipse.jface.util.Throttler;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPartSite;

public abstract class AbstractDropin
implements IShellDropin,
IExecutionListener,
IScriptEngineProvider {
    public static final ISelectionProvider EMPTY_SELECTION_PROVIDER = new ISelectionProvider(){

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
        }

        public ISelection getSelection() {
            return StructuredSelection.EMPTY;
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        }

        public void setSelection(ISelection selection) {
        }
    };
    private IReplEngine fEngine;
    private final Throttler fUiUpdater = new Throttler(Display.getDefault(), Duration.ofMillis(500L), this::update);
    private boolean fIsActive = false;
    private boolean fGloballyHidden = false;
    private Composite fComposite = null;

    @Override
    public void setScriptEngine(IReplEngine engine) {
        if (this.fEngine != null) {
            this.fEngine.removeExecutionListener((IExecutionListener)this);
        }
        this.fEngine = engine;
        if (this.fEngine != null) {
            this.fEngine.addExecutionListener((IExecutionListener)this);
        }
    }

    public IScriptEngine getScriptEngine() {
        return this.fEngine;
    }

    @Override
    public Composite getPartControl(IWorkbenchPartSite site, Composite parent) {
        if (this.fComposite == null) {
            this.fComposite = this.createComposite(site, parent);
            this.fIsActive = true;
            this.fComposite.addListener(23, event -> {
                boolean bl = this.fIsActive = false;
            });
            this.fComposite.addListener(22, event -> {
                this.fIsActive = true;
                this.update();
            });
        }
        return this.fComposite;
    }

    public void notify(IScriptEngine engine, Script script, int status) {
        switch (status) {
            case 4: {
                this.fUiUpdater.throttledExec();
                break;
            }
            case 2: {
                engine.removeExecutionListener((IExecutionListener)this);
                break;
            }
        }
    }

    protected void update() {
        if (!this.fGloballyHidden && this.fIsActive) {
            this.updateUI();
        }
    }

    @Override
    public void setHidden(boolean hidden) {
        this.fGloballyHidden = hidden;
    }

    @Override
    public ISelectionProvider getSelectionProvider() {
        return EMPTY_SELECTION_PROVIDER;
    }

    protected abstract void updateUI();

    protected abstract Composite createComposite(IWorkbenchPartSite var1, Composite var2);
}

