/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.internal.workbench.swt;

import jakarta.inject.Inject;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.internal.workbench.swt.AbstractPartRenderer;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MPopupMenu;
import org.eclipse.e4.ui.services.EMenuService;
import org.eclipse.e4.ui.workbench.swt.factories.IRendererFactory;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;

public class MenuService
implements EMenuService {
    @Inject
    private MPart myPart;

    public boolean registerContextMenu(Object parent, String menuId) {
        if (!(parent instanceof Control)) {
            return false;
        }
        Control parentControl = (Control)parent;
        for (MMenu mmenu : this.myPart.getMenus()) {
            if (!menuId.equals(mmenu.getElementId()) || !(mmenu instanceof MPopupMenu)) continue;
            Menu menu = MenuService.registerMenu(parentControl, (MPopupMenu)mmenu, this.myPart.getContext());
            if (menu != null) {
                parentControl.setMenu(menu);
                return true;
            }
            return false;
        }
        return false;
    }

    public static Menu registerMenu(Control parentControl, MPopupMenu mmenu, IEclipseContext context) {
        AbstractPartRenderer parentRenderer;
        Object widget;
        if (mmenu.getWidget() != null) {
            return (Menu)mmenu.getWidget();
        }
        IRendererFactory rendererFactory = (IRendererFactory)context.get(IRendererFactory.class);
        AbstractPartRenderer renderer = rendererFactory.getRenderer((MUIElement)mmenu, parentControl);
        mmenu.setRenderer((Object)renderer);
        IEclipseContext popupContext = context.createChild("popup:" + mmenu.getElementId());
        mmenu.setContext(popupContext);
        if (mmenu.getParent() == null) {
            mmenu.getTransientData().put("Rendering Parent", parentControl);
        }
        if (!((widget = renderer.createWidget((MUIElement)mmenu, parentControl)) instanceof Menu)) {
            mmenu.getTransientData().remove("Rendering Parent");
            return null;
        }
        renderer.bindWidget((MUIElement)mmenu, widget);
        renderer.hookControllerLogic((MUIElement)mmenu);
        MPopupMenu castObject = mmenu;
        MElementContainer container = (MElementContainer)castObject;
        renderer.processContents((MElementContainer<MUIElement>)container);
        renderer.postProcess((MUIElement)mmenu);
        MElementContainer parentElement = mmenu.getParent();
        if (parentElement != null && (parentRenderer = rendererFactory.getRenderer((MUIElement)parentElement, null)) != null) {
            parentRenderer.childRendered((MElementContainer<MUIElement>)parentElement, (MUIElement)mmenu);
        }
        return (Menu)widget;
    }
}

