/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.extensions.internal.support;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColorCellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swtchart.ISeries;
import org.eclipse.swtchart.extensions.core.BaseChart;
import org.eclipse.swtchart.extensions.core.ISeriesSettings;
import org.eclipse.swtchart.extensions.core.ResourceSupport;
import org.eclipse.swtchart.extensions.core.SeriesLabelProvider;
import org.eclipse.swtchart.extensions.core.SeriesListUI;
import org.eclipse.swtchart.extensions.core.SeriesMapper;

public class SeriesEditingSupport
extends EditingSupport {
    private SeriesListUI seriesListUI;
    private String title = "";

    public SeriesEditingSupport(SeriesListUI seriesListUI, String title) {
        super((ColumnViewer)seriesListUI);
        this.seriesListUI = seriesListUI;
        this.title = title;
    }

    protected boolean canEdit(Object element) {
        boolean canEdit;
        switch (this.title) {
            case "Visible": {
                canEdit = true;
                break;
            }
            case "Visible In Legend": {
                canEdit = true;
                break;
            }
            case "Color": {
                canEdit = true;
                break;
            }
            case "Description": {
                canEdit = true;
                break;
            }
            case "Mapping Status": {
                canEdit = true;
                break;
            }
            default: {
                canEdit = false;
            }
        }
        return canEdit;
    }

    protected CellEditor getCellEditor(Object element) {
        CheckboxCellEditor cellEditor;
        switch (this.title) {
            case "Visible": {
                cellEditor = new CheckboxCellEditor((Composite)this.seriesListUI.getTable());
                break;
            }
            case "Visible In Legend": {
                cellEditor = new CheckboxCellEditor((Composite)this.seriesListUI.getTable());
                break;
            }
            case "Color": {
                cellEditor = new ColorCellEditor((Composite)this.seriesListUI.getTable());
                break;
            }
            case "Description": {
                cellEditor = new TextCellEditor((Composite)this.seriesListUI.getTable());
                break;
            }
            case "Mapping Status": {
                cellEditor = new CheckboxCellEditor((Composite)this.seriesListUI.getTable());
                break;
            }
            default: {
                cellEditor = null;
            }
        }
        return cellEditor;
    }

    protected Object getValue(Object element) {
        Object object;
        block19: {
            object = null;
            if (!(element instanceof ISeries)) break block19;
            ISeries series = (ISeries)element;
            BaseChart baseChart = this.seriesListUI.getBaseChart();
            ISeriesSettings seriesSettings = baseChart.getSeriesSettings(series.getId());
            switch (this.title) {
                case "Visible": {
                    object = seriesSettings.isVisible();
                    break;
                }
                case "Visible In Legend": {
                    object = seriesSettings.isVisibleInLegend();
                    break;
                }
                case "Color": {
                    Color color = SeriesLabelProvider.getColor(seriesSettings);
                    object = color != null ? color.getRGB() : null;
                    break;
                }
                case "Description": {
                    object = seriesSettings.getDescription();
                    break;
                }
                case "Mapping Status": {
                    object = SeriesMapper.get(series, baseChart) != null;
                    break;
                }
                default: {
                    object = null;
                }
            }
        }
        return object;
    }

    protected void setValue(Object element, Object object) {
        block20: {
            if (!(element instanceof ISeries)) break block20;
            ISeries series = (ISeries)element;
            BaseChart baseChart = this.getBaseChart();
            ISeriesSettings seriesSettings = baseChart.getSeriesSettings(series.getId());
            switch (this.title) {
                case "Visible": {
                    seriesSettings.setVisible(Boolean.valueOf(object.toString()));
                    break;
                }
                case "Visible In Legend": {
                    seriesSettings.setVisibleInLegend(Boolean.valueOf(object.toString()));
                    break;
                }
                case "Color": {
                    if (!(object instanceof RGB)) break;
                    RGB rgbNew = (RGB)object;
                    Color color = ResourceSupport.getColor(rgbNew);
                    SeriesLabelProvider.setColor(seriesSettings, color);
                    break;
                }
                case "Description": {
                    seriesSettings.setDescription(object.toString());
                    break;
                }
                case "Mapping Status": {
                    boolean map = Boolean.valueOf(object.toString());
                    if (map) {
                        SeriesMapper.map(series, baseChart);
                        break;
                    }
                    SeriesMapper.unmap(series, baseChart);
                }
            }
            baseChart.applySeriesSettings(series, seriesSettings, true);
            this.refresh();
        }
    }

    private BaseChart getBaseChart() {
        return this.seriesListUI.getBaseChart();
    }

    private void refresh() {
        this.getBaseChart().redraw();
        this.seriesListUI.refresh();
    }
}

