/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.refactoring.descriptors;

import org.eclipse.core.runtime.Assert;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.refactoring.descriptors.JavaScriptRefactoringDescriptor;
import org.eclipse.wst.jsdt.internal.core.refactoring.descriptors.DescriptorMessages;

public final class MoveStaticMembersDescriptor
extends JavaScriptRefactoringDescriptor {
    private static final String ATTRIBUTE_DELEGATE = "delegate";
    private static final String ATTRIBUTE_DEPRECATE = "deprecate";
    private boolean fDelegate = false;
    private boolean fDeprecate = false;
    private IMember[] fMembers;
    private IType fType = null;

    public MoveStaticMembersDescriptor() {
        super("org.eclipse.wst.jsdt.ui.move.static");
    }

    @Override
    protected void populateArgumentMap() {
        super.populateArgumentMap();
        this.fArguments.put("input", MoveStaticMembersDescriptor.elementToHandle(this.getProject(), (IJavaScriptElement)this.fType));
        this.fArguments.put(ATTRIBUTE_DELEGATE, Boolean.valueOf(this.fDelegate).toString());
        this.fArguments.put(ATTRIBUTE_DEPRECATE, Boolean.valueOf(this.fDeprecate).toString());
        int index = 0;
        while (index < this.fMembers.length) {
            this.fArguments.put("element" + (index + 1), MoveStaticMembersDescriptor.elementToHandle(this.getProject(), (IJavaScriptElement)this.fMembers[index]));
            ++index;
        }
    }

    public void setDeprecateDelegate(boolean deprecate) {
        this.fDeprecate = deprecate;
    }

    public void setDestinationType(IType type) {
        Assert.isNotNull((Object)type);
        this.fType = type;
    }

    public void setKeepOriginal(boolean delegate) {
        this.fDelegate = delegate;
    }

    public void setMembers(IMember[] members) {
        Assert.isNotNull((Object)members);
        this.fMembers = members;
    }

    @Override
    public RefactoringStatus validateDescriptor() {
        RefactoringStatus status = super.validateDescriptor();
        if (this.fType == null) {
            status.merge(RefactoringStatus.createFatalErrorStatus((String)DescriptorMessages.MoveStaticMembersDescriptor_no_type));
        }
        if (this.fMembers == null) {
            status.merge(RefactoringStatus.createFatalErrorStatus((String)DescriptorMessages.MoveStaticMembersDescriptor_no_members));
        } else {
            int index = 0;
            while (index < this.fMembers.length) {
                if (this.fMembers[index] == null) {
                    status.merge(RefactoringStatus.createFatalErrorStatus((String)DescriptorMessages.MoveStaticMembersDescriptor_invalid_members));
                    break;
                }
                ++index;
            }
        }
        return status;
    }
}

