/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.scripts.dialogs;

import java.io.File;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ease.ui.scripts.Messages;
import org.eclipse.ease.ui.scripts.preferences.PreferencesHelper;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;

public class SelectScriptStorageDialog
extends Dialog {
    private Text fTxtWorkspace;
    private Text fTxtFileSystem;
    private Button fBtnStoreInSettings;
    private Button fBtnStoreInWorkspace;
    private Button fBtnStoreOnFileSystem;
    private String fLocation = null;

    public SelectScriptStorageDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.SelectScriptStorageDialog_storageLocation);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        container.setLayout((Layout)new GridLayout(2, false));
        Label lblWhereDoYou = new Label(container, 0);
        lblWhereDoYou.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        lblWhereDoYou.setText(Messages.SelectScriptStorageDialog_storageDescription);
        this.fBtnStoreInSettings = new Button(container, 16);
        this.fBtnStoreInSettings.setSelection(true);
        this.fBtnStoreInSettings.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
        GridData gd_btnStoreInSettings = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_btnStoreInSettings.verticalIndent = 20;
        this.fBtnStoreInSettings.setLayoutData((Object)gd_btnStoreInSettings);
        this.fBtnStoreInSettings.setText(Messages.SelectScriptStorageDialog_storeInSettings);
        new Label(container, 0);
        this.fBtnStoreInWorkspace = new Button(container, 16);
        this.fBtnStoreInWorkspace.setText(Messages.SelectScriptStorageDialog_storeInWorkspace);
        new Label(container, 0);
        this.fTxtWorkspace = new Text(container, 2048);
        GridData gd_txtWorkspace = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_txtWorkspace.horizontalIndent = 17;
        this.fTxtWorkspace.setLayoutData((Object)gd_txtWorkspace);
        Button btnNewButton = new Button(container, 0);
        btnNewButton.setText(Messages.SelectScriptStorageDialog_browse);
        btnNewButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object[] result;
                ContainerSelectionDialog dialog = new ContainerSelectionDialog(SelectScriptStorageDialog.this.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), true, Messages.SelectScriptStorageDialog_selectFolder);
                if (dialog.open() == 0 && (result = dialog.getResult()).length > 0 && result[0] instanceof IPath) {
                    SelectScriptStorageDialog.this.fTxtWorkspace.setText(result[0].toString());
                }
            }
        });
        this.fBtnStoreOnFileSystem = new Button(container, 16);
        this.fBtnStoreOnFileSystem.setText(Messages.SelectScriptStorageDialog_fileSystem);
        new Label(container, 0);
        this.fTxtFileSystem = new Text(container, 2048);
        GridData gd_txtFileSystem = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_txtFileSystem.horizontalIndent = 17;
        this.fTxtFileSystem.setLayoutData((Object)gd_txtFileSystem);
        Button btnNewButton_1 = new Button(container, 0);
        btnNewButton_1.setText(Messages.SelectScriptStorageDialog_browse);
        btnNewButton_1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(SelectScriptStorageDialog.this.getShell());
                String path = dialog.open();
                if (path != null) {
                    SelectScriptStorageDialog.this.fTxtFileSystem.setText(new File(path).toURI().toString());
                }
            }
        });
        return container;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Point getInitialSize() {
        return new Point(450, 300);
    }

    protected void okPressed() {
        if (this.fBtnStoreInSettings.getSelection()) {
            this.fLocation = PreferencesHelper.getDefaultScriptStorageLocation();
        } else if (this.fBtnStoreInWorkspace.getSelection()) {
            this.fLocation = this.fTxtWorkspace.getText().startsWith("/") ? "workspace:/" + this.fTxtWorkspace.getText() : "workspace://" + this.fTxtWorkspace.getText();
        } else if (this.fBtnStoreOnFileSystem.getSelection()) {
            this.fLocation = this.fTxtFileSystem.getText();
        }
        super.okPressed();
    }

    public String getLocation() {
        return this.fLocation;
    }
}

