/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.ui.view;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.concurrent.TimeUnit;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class Measurement
implements Serializable,
IPropertySource {
    private static final long serialVersionUID = -8418765797403500502L;
    private static final DecimalFormat FORMAT = new DecimalFormat("0.###");
    private final double duration;
    private final TimeUnit timeUnit;
    private transient IPropertyDescriptor[] propertyDescriptors;

    public Measurement(double duration, TimeUnit timeUnit) {
        this.duration = duration;
        this.timeUnit = timeUnit;
    }

    public double getDuration() {
        return this.duration;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public Object getEditableValue() {
        return this;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        if (this.propertyDescriptors == null) {
            PropertyDescriptor durationProperty = new PropertyDescriptor((Object)Properties.Duration, Properties.Duration.name());
            PropertyDescriptor productivityProperty = new PropertyDescriptor((Object)Properties.Productivity, Properties.Productivity.name());
            this.propertyDescriptors = new IPropertyDescriptor[]{durationProperty, productivityProperty};
        }
        return this.propertyDescriptors;
    }

    public Object getPropertyValue(Object id) {
        switch ((Properties)((Object)id)) {
            case Duration: {
                return this.toString();
            }
            case Productivity: {
                return this.toProductivityString();
            }
        }
        return null;
    }

    public boolean isPropertySet(Object id) {
        return true;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }

    public Measurement scale() {
        if (this.duration < 1.0) {
            int index = this.timeUnit.ordinal() - 1;
            while (index >= 0) {
                TimeUnit scaledUnit = TimeUnit.values()[index];
                double scaledDuration = this.scaleTime(scaledUnit);
                if (scaledDuration >= 1.0) {
                    return new Measurement(scaledDuration, scaledUnit);
                }
                --index;
            }
        } else {
            int index = this.timeUnit.ordinal() + 1;
            while (index < TimeUnit.values().length) {
                if (this.scaleTime(TimeUnit.values()[index]) < 1.0) {
                    return this.scale(TimeUnit.values()[index - 1]);
                }
                ++index;
            }
        }
        return this;
    }

    public Measurement scale(TimeUnit scaledUnit) {
        if (scaledUnit == this.timeUnit) {
            return this;
        }
        return new Measurement(this.scaleTime(scaledUnit), scaledUnit);
    }

    private double scaleTime(TimeUnit scaledUnit) {
        if (scaledUnit == this.timeUnit) {
            return this.duration;
        }
        if (scaledUnit.compareTo(this.timeUnit) > 0) {
            return this.duration / (double)this.timeUnit.convert(1L, scaledUnit);
        }
        return this.duration * (double)scaledUnit.convert(1L, this.timeUnit);
    }

    public String toProductivityString() {
        TimeUnit productivityTimeUnit = switch (this.timeUnit) {
            case TimeUnit.NANOSECONDS, TimeUnit.MICROSECONDS -> TimeUnit.SECONDS;
            case TimeUnit.MILLISECONDS -> TimeUnit.MINUTES;
            case TimeUnit.SECONDS -> TimeUnit.HOURS;
            default -> TimeUnit.DAYS;
        };
        double productivity = (double)this.timeUnit.convert(1L, productivityTimeUnit) / this.duration;
        return FORMAT.format(productivity) + " per " + this.asLongString(productivityTimeUnit);
    }

    public String toString() {
        return FORMAT.format(this.duration) + " " + this.asShortString(this.timeUnit);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.duration);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.timeUnit == null ? 0 : this.timeUnit.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Measurement other = (Measurement)obj;
        if (Double.doubleToLongBits(this.duration) != Double.doubleToLongBits(other.duration)) {
            return false;
        }
        return this.timeUnit == other.timeUnit;
    }

    protected String asShortString(TimeUnit timeUnit) {
        switch (timeUnit) {
            case NANOSECONDS: {
                return "ns";
            }
            case MICROSECONDS: {
                return "us";
            }
            case MILLISECONDS: {
                return "ms";
            }
            case SECONDS: {
                return "s";
            }
            case MINUTES: {
                return "min";
            }
            case HOURS: {
                return "hr";
            }
            case DAYS: {
                return "day";
            }
        }
        throw new IllegalStateException();
    }

    protected String asLongString(TimeUnit timeUnit) {
        switch (timeUnit) {
            case NANOSECONDS: {
                return "nanosecond";
            }
            case MICROSECONDS: {
                return "microsecond";
            }
            case MILLISECONDS: {
                return "millisecond";
            }
            case SECONDS: {
                return "second";
            }
            case MINUTES: {
                return "minute";
            }
            case HOURS: {
                return "hour";
            }
            case DAYS: {
                return "day";
            }
        }
        throw new IllegalStateException();
    }

    private static enum Properties {
        Duration,
        Productivity;

    }
}

