/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.ui.view;

import java.awt.Component;
import java.awt.Frame;
import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.awt.SWT_AWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;

public class ChartView
extends ViewPart {
    public static final String VIEW_ID = ChartView.class.getName() + ".id";
    private Frame frame;

    public void createPartControl(Composite parent) {
        this.frame = SWT_AWT.new_Frame((Composite)new Composite(parent, 0x1040000));
    }

    public void setFocus() {
    }

    public void dispose() {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    ChartView.this.frame.dispose();
                }
            });
        }
        catch (InterruptedException | InvocationTargetException exception) {
            // empty catch block
        }
        super.dispose();
    }

    private void setResult(JFreeChart chart) {
        this.frame.add((Component)new ChartPanel(chart));
    }

    public static synchronized void showChart(final JFreeChart chart, final String title, final String tip) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        workbench.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    ChartView view = (ChartView)page.showView(VIEW_ID, Long.toHexString(System.currentTimeMillis()), 1);
                    view.setPartName(title);
                    view.setTitleToolTip(tip);
                    view.setResult(chart);
                }
                catch (PartInitException e) {
                    ErrorDialog.openError(null, (String)"Error", (String)"Failed to open chart view", (IStatus)e.getStatus());
                }
            }
        });
    }
}

