/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.common.jfreechart.chart.labels;

import java.util.function.Function;
import org.eclipse.trace4cps.common.jfreechart.chart.labels.LabeledDataItem;
import org.eclipse.trace4cps.common.jfreechart.data.xy.XYDataItemResolver;
import org.jfree.chart.labels.XYItemLabelGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.data.xy.XYDataset;

public class XYDataItemLabelGenerator
implements XYItemLabelGenerator,
XYToolTipGenerator {
    public static final XYDataItemLabelGenerator DEFAULT = new XYDataItemLabelGenerator(XYDataItemLabelGenerator::toString, XYDataItemResolver.DEFAULT);
    private final Function<Object, String> labelSupplier;
    private final XYDataItemResolver xyDataItemResolver;

    public XYDataItemLabelGenerator(Function<Object, String> labelSupplier) {
        this(labelSupplier, XYDataItemResolver.DEFAULT);
    }

    public XYDataItemLabelGenerator(Function<Object, String> labelSupplier, XYDataItemResolver xyDataItemResolver) {
        this.labelSupplier = labelSupplier;
        this.xyDataItemResolver = xyDataItemResolver;
    }

    public String generateLabel(XYDataset dataset, int series, int item) {
        return XYDataItemLabelGenerator.nullIfEmpty(this.generateLabel(this.xyDataItemResolver.resolveDataItem(dataset, series, item)));
    }

    public String generateToolTip(XYDataset dataset, int series, int item) {
        return XYDataItemLabelGenerator.nullIfEmpty(this.generateLabel(this.xyDataItemResolver.resolveDataItem(dataset, series, item)));
    }

    protected String generateLabel(Object dataItem) {
        String itemLabel;
        if (dataItem == null) {
            return null;
        }
        if (dataItem instanceof LabeledDataItem && (itemLabel = ((LabeledDataItem)dataItem).getItemLabel()) != null) {
            return itemLabel;
        }
        return this.labelSupplier.apply(dataItem);
    }

    public static String toString(Object o) {
        return o == null ? null : o.toString();
    }

    public static String nullIfEmpty(String s) {
        return s == null || s.isEmpty() ? null : s;
    }
}

