"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.sendSourceBreakpointInsert = exports.sendFunctionBreakpointInsert = exports.sendBreakList = exports.sendBreakDelete = exports.sendBreakpointInsert = exports.functionBreakpointLocation = exports.sourceBreakpointLocation = void 0;
const standardEscape_1 = require("../util/standardEscape");
function cleanupBreakpointResponse(raw) {
    if (Array.isArray(raw.bkpt)) {
        const bkpt = raw.bkpt[0];
        const multiple = raw.bkpt.slice(1);
        return {
            _class: raw._class,
            bkpt,
            multiple,
        };
    }
    return {
        _class: raw._class,
        bkpt: raw.bkpt,
    };
}
function sourceBreakpointLocation(gdb, source, line = '', forInsert = false) {
    const version8 = gdb.gdbVersionAtLeast('8.0');
    if (forInsert) {
        if (version8) {
            return `--source ${(0, standardEscape_1.standardEscape)(source)} --line ${line}`;
        }
        else {
            // double-escaping/quoting needed for old GDBs
            const location = `"${source}:${line}"`;
            return `${(0, standardEscape_1.standardEscape)(location, true)}`;
        }
    }
    else {
        return version8
            ? `-source ${source} -line ${line}`
            : `${source}:${line}`;
    }
}
exports.sourceBreakpointLocation = sourceBreakpointLocation;
function functionBreakpointLocation(gdb, fn, forInsert = false) {
    const version8 = gdb.gdbVersionAtLeast('8.0');
    if (forInsert) {
        return version8 ? `--function ${fn}` : fn;
    }
    else {
        return version8 ? `-function ${fn}` : fn;
    }
}
exports.functionBreakpointLocation = functionBreakpointLocation;
function sendBreakpointInsert(gdb, location, options) {
    return __awaiter(this, void 0, void 0, function* () {
        // Todo: lots of options
        const temp = (options === null || options === void 0 ? void 0 : options.temporary) ? '-t ' : '';
        const ignore = (options === null || options === void 0 ? void 0 : options.ignoreCount) ? `-i ${options === null || options === void 0 ? void 0 : options.ignoreCount} ` : '';
        const hwBreakpoint = (options === null || options === void 0 ? void 0 : options.hardware) ? '-h ' : '';
        const pend = (options === null || options === void 0 ? void 0 : options.pending) ? '-f ' : '';
        const command = `-break-insert ${temp}${hwBreakpoint}${ignore}${pend}${location}`;
        const result = yield gdb.sendCommand(command);
        const clean = cleanupBreakpointResponse(result);
        if (options === null || options === void 0 ? void 0 : options.condition) {
            yield gdb.sendCommand(`-break-condition ${clean.bkpt.number} ${options.condition}`);
        }
        return clean;
    });
}
exports.sendBreakpointInsert = sendBreakpointInsert;
function sendBreakDelete(gdb, request) {
    return gdb.sendCommand(`-break-delete ${request.breakpoints.join(' ')}`);
}
exports.sendBreakDelete = sendBreakDelete;
function sendBreakList(gdb) {
    return gdb.sendCommand('-break-list');
}
exports.sendBreakList = sendBreakList;
function sendFunctionBreakpointInsert(gdb, fn, options) {
    return __awaiter(this, void 0, void 0, function* () {
        const location = yield functionBreakpointLocation(gdb, fn, true);
        return sendBreakpointInsert(gdb, location, options);
    });
}
exports.sendFunctionBreakpointInsert = sendFunctionBreakpointInsert;
function sendSourceBreakpointInsert(gdb, source, line, options) {
    return __awaiter(this, void 0, void 0, function* () {
        const location = yield sourceBreakpointLocation(gdb, source, line, true);
        return sendBreakpointInsert(gdb, location, options);
    });
}
exports.sendSourceBreakpointInsert = sendSourceBreakpointInsert;
//# sourceMappingURL=breakpoint.js.map