/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib.containers.docker;

import jdk.test.lib.Platform;

public class DockerfileConfig {
    public static boolean isUbsan() {
        return Boolean.getBoolean("jdk.test.docker.image.isUbsan");
    }

    public static String getBaseImageName() {
        String name = System.getProperty("jdk.test.docker.image.name");
        if (name != null) {
            System.out.println("DockerfileConfig: using custom image name: " + name);
            return name;
        }
        switch (Platform.getOsArch()) {
            case "aarch64": {
                return "arm64v8/ubuntu";
            }
            case "ppc64le": {
                return "ppc64le/ubuntu";
            }
            case "s390x": {
                return "s390x/ubuntu";
            }
        }
        return "ubuntu";
    }

    public static String getBaseImageVersion() {
        String version = System.getProperty("jdk.test.docker.image.version");
        if (version != null) {
            System.out.println("DockerfileConfig: using custom image version: " + version);
            return version;
        }
        if (Platform.isPPC()) {
            return "20.04";
        }
        return "latest";
    }
}

