/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.ui.text;

import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.internal.ui.editor.EditorUtility;
import org.eclipse.dltk.internal.ui.editor.ScriptSourceViewer;
import org.eclipse.dltk.internal.ui.text.ScriptElementProvider;
import org.eclipse.dltk.tcl.internal.ui.hierarchy.TclHierarchyInformationControl;
import org.eclipse.dltk.tcl.internal.ui.text.TclAutoEditStrategy;
import org.eclipse.dltk.tcl.internal.ui.text.TclCodeScanner;
import org.eclipse.dltk.tcl.internal.ui.text.TclOutlineInformationControl;
import org.eclipse.dltk.tcl.internal.ui.text.TclStringScanner;
import org.eclipse.dltk.tcl.internal.ui.text.TclTextTools;
import org.eclipse.dltk.tcl.internal.ui.text.completion.TclContentAssistPreference;
import org.eclipse.dltk.tcl.internal.ui.text.completion.TclScriptCompletionProcessor;
import org.eclipse.dltk.tcl.ui.text.TclPartitions;
import org.eclipse.dltk.ui.text.AbstractScriptScanner;
import org.eclipse.dltk.ui.text.IColorManager;
import org.eclipse.dltk.ui.text.ScriptCorrectionAssistant;
import org.eclipse.dltk.ui.text.ScriptPresentationReconciler;
import org.eclipse.dltk.ui.text.ScriptSourceViewerConfiguration;
import org.eclipse.dltk.ui.text.completion.ContentAssistPreference;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.AbstractInformationControlManager;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.information.IInformationPresenter;
import org.eclipse.jface.text.information.IInformationProvider;
import org.eclipse.jface.text.information.InformationPresenter;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.quickassist.IQuickAssistAssistant;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class TclSourceViewerConfiguration
extends ScriptSourceViewerConfiguration {
    private TclTextTools fTextTools;
    private TclCodeScanner fCodeScanner;
    private AbstractScriptScanner fStringScanner;
    private AbstractScriptScanner fCommentScanner;

    public TclSourceViewerConfiguration(IColorManager colorManager, IPreferenceStore preferenceStore, ITextEditor editor, String partitioning) {
        super(colorManager, preferenceStore, editor, partitioning);
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return TclPartitions.TCL_PARTITION_TYPES;
    }

    private IInformationControlCreator getHierarchyPresenterControlCreator(ISourceViewer sourceViewer) {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                int shellStyle = 16;
                int treeStyle = 768;
                return new TclHierarchyInformationControl(parent, shellStyle, treeStyle);
            }
        };
    }

    public IInformationPresenter getHierarchyPresenter(ScriptSourceViewer sourceViewer, boolean doCodeResolve) {
        if (this.getEditor() != null && this.getEditor().getEditorInput() != null && EditorUtility.getEditorInputModelElement((IEditorPart)this.getEditor(), (boolean)true) == null) {
            return null;
        }
        InformationPresenter presenter = new InformationPresenter(this.getHierarchyPresenterControlCreator((ISourceViewer)sourceViewer));
        presenter.setDocumentPartitioning(this.getConfiguredDocumentPartitioning((ISourceViewer)sourceViewer));
        presenter.setAnchor(AbstractInformationControlManager.ANCHOR_GLOBAL);
        ScriptElementProvider provider = new ScriptElementProvider((IEditorPart)this.getEditor(), doCodeResolve);
        presenter.setInformationProvider((IInformationProvider)provider, "__dftl_partition_content_type");
        presenter.setSizeConstraints(50, 20, true, false);
        return presenter;
    }

    protected void initializeScanners() {
        Assert.isTrue((boolean)this.isNewSetup());
        this.fCodeScanner = new TclCodeScanner(this.getColorManager(), this.fPreferenceStore);
        this.fStringScanner = new TclStringScanner(this.getColorManager(), this.fPreferenceStore);
        this.fCommentScanner = this.createCommentScanner("DLTK_single_line_comment", "DLTK_comment_task_tag");
    }

    private boolean isNewSetup() {
        return this.fTextTools == null;
    }

    protected RuleBasedScanner getStringScanner() {
        return this.fStringScanner;
    }

    protected RuleBasedScanner getCommentScanner() {
        return this.fCommentScanner;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        ScriptPresentationReconciler reconciler = new ScriptPresentationReconciler();
        reconciler.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)this.fCodeScanner);
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getStringScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__tcl_string");
        reconciler.setRepairer((IPresentationRepairer)dr, "__tcl_string");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getCommentScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__tcl_comment");
        reconciler.setRepairer((IPresentationRepairer)dr, "__tcl_comment");
        return reconciler;
    }

    public void handlePropertyChangeEvent(PropertyChangeEvent event) {
        Assert.isTrue((boolean)this.isNewSetup());
        if (this.fCodeScanner.affectsBehavior(event)) {
            this.fCodeScanner.adaptToPreferenceChange(event);
        }
        if (this.fStringScanner.affectsBehavior(event)) {
            this.fStringScanner.adaptToPreferenceChange(event);
        }
        if (this.fCommentScanner.affectsBehavior(event)) {
            this.fCommentScanner.adaptToPreferenceChange(event);
        }
    }

    public boolean affectsTextPresentation(PropertyChangeEvent event) {
        return this.fCodeScanner.affectsBehavior(event) || this.fStringScanner.affectsBehavior(event) || this.fCommentScanner.affectsBehavior(event);
    }

    public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer sourceViewer, String contentType) {
        String partitioning = this.getConfiguredDocumentPartitioning(sourceViewer);
        return new IAutoEditStrategy[]{new TclAutoEditStrategy(this.fPreferenceStore, partitioning)};
    }

    protected void alterContentAssistant(ContentAssistant assistant) {
        TclScriptCompletionProcessor scriptProcessor = new TclScriptCompletionProcessor((IEditorPart)this.getEditor(), assistant, "__dftl_partition_content_type");
        assistant.setContentAssistProcessor((IContentAssistProcessor)scriptProcessor, "__dftl_partition_content_type");
        TclScriptCompletionProcessor singleLineProcessor = new TclScriptCompletionProcessor((IEditorPart)this.getEditor(), assistant, "__tcl_comment");
        assistant.setContentAssistProcessor((IContentAssistProcessor)singleLineProcessor, "__tcl_comment");
        TclScriptCompletionProcessor stringProcessor = new TclScriptCompletionProcessor((IEditorPart)this.getEditor(), assistant, "__tcl_string");
        assistant.setContentAssistProcessor((IContentAssistProcessor)stringProcessor, "__tcl_string");
    }

    protected ContentAssistPreference getContentAssistPreference() {
        return TclContentAssistPreference.getDefault();
    }

    protected IInformationControlCreator getOutlinePresenterControlCreator(ISourceViewer sourceViewer, final String commandId) {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                int shellStyle = 16;
                int treeStyle = 768;
                return new TclOutlineInformationControl(parent, shellStyle, treeStyle, commandId);
            }
        };
    }

    protected void initializeQuickOutlineContexts(InformationPresenter presenter, IInformationProvider provider) {
        presenter.setInformationProvider(provider, "__tcl_comment");
        presenter.setInformationProvider(provider, "__tcl_inner_code");
        presenter.setInformationProvider(provider, "__tcl_string");
    }

    public IQuickAssistAssistant getQuickAssistAssistant(ISourceViewer sourceViewer) {
        if (this.getEditor() != null) {
            return new ScriptCorrectionAssistant(this.getEditor(), this.fPreferenceStore, this.getColorManager());
        }
        return null;
    }
}

