/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.docmlet.wikitext.core.source;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.mylyn.wikitext.parser.Attributes;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.parser.Locator;
import org.eclipse.statet.docmlet.wikitext.core.markup.IMarkupLanguage;
import org.eclipse.statet.docmlet.wikitext.core.markup.IWikitextLocator;
import org.eclipse.statet.docmlet.wikitext.core.markup.MarkupParser2;
import org.eclipse.statet.docmlet.wikitext.core.source.SourceElementDetail;
import org.eclipse.statet.docmlet.wikitext.core.source.WikitextPartitionNodeType;
import org.eclipse.statet.ecommons.text.core.treepartitioner.ITreePartitionNode;
import org.eclipse.statet.ecommons.text.core.treepartitioner.ITreePartitionNodeScan;
import org.eclipse.statet.ecommons.text.core.treepartitioner.ITreePartitionNodeScanner;
import org.eclipse.statet.ecommons.text.core.treepartitioner.ITreePartitionNodeType;
import org.eclipse.statet.ltk.core.SourceContent;

public class WikitextPartitionNodeScanner
extends DocumentBuilder
implements ITreePartitionNodeScanner {
    private IMarkupLanguage markupLanguage;
    private final int markupLanguageMode;
    private ITreePartitionNodeScan scan;
    private ITreePartitionNode node;
    private int startOffset;
    private int endOffset;
    private IWikitextLocator locator2;
    private int ignoreCounter;
    private final List<Attributes> attributeStack = new ArrayList<Attributes>();

    public WikitextPartitionNodeScanner(IMarkupLanguage markupLanguage) {
        this(markupLanguage, 0);
    }

    public WikitextPartitionNodeScanner(IMarkupLanguage markupLanguage, int markupLanguageMode) {
        this.markupLanguageMode = markupLanguageMode;
        this.setMarkupLanguage(markupLanguage);
    }

    public IMarkupLanguage getMarkupLanguage() {
        return this.markupLanguage;
    }

    public void setMarkupLanguage(IMarkupLanguage markupLanguage) {
        if (this.markupLanguage != null && this.markupLanguage.getName() == markupLanguage.getName() && this.markupLanguage.getClass() == markupLanguage.getClass()) {
            this.markupLanguage.setMarkupConfig(markupLanguage.getMarkupConfig());
            if (this.markupLanguage.equals(markupLanguage)) {
                return;
            }
        }
        this.markupLanguage = markupLanguage.clone("Doc/Partitioner", this.markupLanguageMode);
    }

    protected boolean isTemplateMode() {
        return (this.markupLanguageMode & 0x10) != 0;
    }

    public void setLocator(Locator locator) {
        super.setLocator(locator);
        this.locator2 = (IWikitextLocator)locator;
    }

    public int getRestartOffset(ITreePartitionNode node, IDocument document, int offset) throws BadLocationException {
        WikitextPartitionNodeType rootType = this.getDefaultRootType();
        ITreePartitionNode parent = node.getParent();
        if (parent != null) {
            while (parent.getType() != rootType) {
                node = parent;
                parent = node.getParent();
            }
            int idx = parent.indexOfChild(node);
            do {
                int line = document.getLineOfOffset(node.getStartOffset());
                offset = document.getLineOffset(line);
            } while (idx > 0 && offset < (node = parent.getChild(--idx)).getEndOffset());
        }
        return offset;
    }

    public WikitextPartitionNodeType getDefaultRootType() {
        return WikitextPartitionNodeType.DEFAULT_ROOT;
    }

    public void execute(ITreePartitionNodeScan scan) throws ITreePartitionNodeScan.BreakException {
        this.scan = scan;
        this.node = null;
        this.setRange(scan.getStartOffset(), scan.getEndOffset());
        this.init();
        assert (this.node != null);
        this.process();
    }

    protected ITreePartitionNodeScan getScan() {
        return this.scan;
    }

    protected void setRange(int startOffset, int endOffset) {
        this.startOffset = startOffset;
        this.endOffset = endOffset;
    }

    protected void init() {
        ITreePartitionNode beginNode = this.getScan().getBeginNode();
        if (beginNode.getType() instanceof WikitextPartitionNodeType) {
            this.node = beginNode;
        } else {
            this.node = beginNode;
            this.addNode((ITreePartitionNodeType)this.getDefaultRootType(), this.getScan().getStartOffset());
        }
    }

    protected final int getStartOffset() {
        return this.startOffset;
    }

    protected final void initNode(ITreePartitionNode node) {
        if (this.node != null) {
            throw new IllegalStateException();
        }
        this.node = node;
    }

    protected final void addNode(ITreePartitionNodeType type, int offset) {
        this.node = this.scan.add(type, this.node, offset, 0);
    }

    protected final ITreePartitionNode getNode() {
        return this.node;
    }

    protected final void exitNode(int offset, int flags) {
        this.scan.expand(this.node, offset, flags, true);
        this.node = this.node.getParent();
    }

    protected final void exitNode() {
        this.node = this.node.getParent();
    }

    private void process() {
        try {
            try {
                WikitextPartitionNodeScanner builder = this;
                MarkupParser2 markupParser = new MarkupParser2(this.markupLanguage, builder);
                this.configure(markupParser);
                SourceContent content = new SourceContent(0L, this.scan.getDocument().get(this.startOffset, this.endOffset - this.startOffset), this.startOffset);
                markupParser.parse(content, false);
            }
            catch (BadLocationException e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            this.attributeStack.clear();
        }
    }

    protected void configure(MarkupParser2 markupParser) {
        markupParser.disable(256);
        markupParser.enable(4096);
        markupParser.disable(112);
    }

    protected final int getEventBeginOffset() {
        return this.startOffset + this.locator2.getBeginOffset();
    }

    protected final int getEventEndOffset() {
        return this.startOffset + this.locator2.getEndOffset();
    }

    protected final int getEventFlags(Attributes attributes) {
        if (attributes instanceof SourceElementDetail) {
            return ((SourceElementDetail)attributes).getSourceElementDetail() & 0x100;
        }
        return 0;
    }

    public void beginDocument() {
    }

    public void endDocument() {
    }

    public void beginBlock(DocumentBuilder.BlockType type, Attributes attributes) {
        if (this.ignoreCounter > 0 || this.ignore(type)) {
            ++this.ignoreCounter;
            return;
        }
        this.addNode((ITreePartitionNodeType)WikitextPartitionNodeType.BLOCK_TYPES.get(type), this.getEventBeginOffset());
        this.attributeStack.add(attributes);
    }

    private boolean ignore(DocumentBuilder.BlockType type) {
        switch (type) {
            case LIST_ITEM: 
            case TABLE_ROW: 
            case TABLE_CELL_HEADER: 
            case TABLE_CELL_NORMAL: 
            case DEFINITION_ITEM: {
                return true;
            }
        }
        return this.node != null && this.node.getType() instanceof WikitextPartitionNodeType && ((WikitextPartitionNodeType)this.node.getType()).getBlockType() == DocumentBuilder.BlockType.QUOTE;
    }

    public void endBlock() {
        if (this.ignoreCounter > 0) {
            --this.ignoreCounter;
            return;
        }
        Attributes attributes = this.attributeStack.remove(this.attributeStack.size() - 1);
        this.exitNode(this.getEventEndOffset(), this.getEventFlags(attributes));
    }

    public void beginSpan(DocumentBuilder.SpanType type, Attributes attributes) {
        this.scan.expand(this.node, this.getEventBeginOffset(), 0, false);
    }

    public void endSpan() {
        this.scan.expand(this.node, this.getEventEndOffset(), 0, false);
    }

    public void beginHeading(int level, Attributes attributes) {
        this.addNode((ITreePartitionNodeType)WikitextPartitionNodeType.HEADING_TYPES.get(level), this.getEventBeginOffset());
        this.attributeStack.add(attributes);
    }

    public void endHeading() {
        Attributes attributes = this.attributeStack.remove(this.attributeStack.size() - 1);
        this.exitNode(this.getEventEndOffset(), this.getEventFlags(attributes));
    }

    public void characters(String text) {
    }

    public void charactersUnescaped(String literal) {
    }

    public void entityReference(String entity) {
    }

    public void image(Attributes attributes, String url) {
    }

    public void link(Attributes attributes, String hrefOrHashName, String text) {
    }

    public void imageLink(Attributes linkAttributes, Attributes imageAttributes, String href, String imageUrl) {
    }

    public void acronym(String text, String definition) {
    }

    public void lineBreak() {
    }
}

