/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.docmlet.wikitext.commonmark.core;

import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Objects;
import org.eclipse.core.runtime.Platform;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.parser.IdGenerator;
import org.eclipse.mylyn.wikitext.parser.MarkupParser;
import org.eclipse.mylyn.wikitext.parser.builder.MultiplexingDocumentBuilder;
import org.eclipse.mylyn.wikitext.parser.markup.IdGenerationStrategy;
import org.eclipse.mylyn.wikitext.parser.markup.MarkupLanguage;
import org.eclipse.statet.docmlet.wikitext.commonmark.core.ICommonmarkConfig;
import org.eclipse.statet.docmlet.wikitext.core.WikitextProblemReporter;
import org.eclipse.statet.docmlet.wikitext.core.markup.IMarkupConfig;
import org.eclipse.statet.docmlet.wikitext.core.markup.IMarkupLanguage;
import org.eclipse.statet.docmlet.wikitext.core.markup.MarkupLanguageExtension2;
import org.eclipse.statet.docmlet.wikitext.core.markup.MarkupParser2;
import org.eclipse.statet.docmlet.wikitext.core.source.IMarkupSourceFormatAdapter;
import org.eclipse.statet.docmlet.wikitext.core.source.MarkupEventPrinter;
import org.eclipse.statet.docmlet.wikitext.core.source.extdoc.IExtdocMarkupLanguage;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.Commonmark;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.CommonmarkIdGenerationStrategy;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.ContentLineSequence;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.NullIdGenerator;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.ProcessingContext;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.SourceBlockItem;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.SourceBlocks;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines.InlineParser;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.source.CommonmarkSourceFormatAdapter;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.ltk.core.SourceContent;

@NonNullByDefault
public class CommonmarkLanguage
extends MarkupLanguage
implements IMarkupLanguage,
MarkupLanguageExtension2,
IExtdocMarkupLanguage {
    protected static final String COMMONMARK_LANGUAGE_NAME = "CommonMark\u2002[StatET]";
    public static final int MARKDOWN_COMPAT_MODE = 65536;
    private static final boolean DEBUG_LOG_EVENTS = Boolean.parseBoolean(Platform.getDebugOption((String)"org.eclipse.statet.docmlet.wikitext.commonmark/debug/Parser/logEvents"));
    private @Nullable String scope;
    private int mode;
    private @Nullable ICommonmarkConfig config;
    private @Nullable SourceBlocks sourceBlocks;
    private @Nullable InlineParser inlineParser;
    private @Nullable WikitextProblemReporter validator;
    private @Nullable CommonmarkSourceFormatAdapter sourceAdapter;

    public CommonmarkLanguage() {
        this(null, 0, null);
    }

    public CommonmarkLanguage(String scope, int mode, @Nullable IMarkupConfig config) {
        this.scope = scope;
        this.mode = mode;
        this.setName(COMMONMARK_LANGUAGE_NAME);
        this.setMarkupConfig(config);
    }

    public CommonmarkLanguage clone() {
        CommonmarkLanguage clone = (CommonmarkLanguage)super.clone();
        clone.mode = this.mode;
        clone.config = this.config;
        return clone;
    }

    public CommonmarkLanguage clone(String scope, int mode) {
        CommonmarkLanguage clone = (CommonmarkLanguage)super.clone();
        clone.scope = scope;
        clone.mode = mode;
        clone.config = this.config;
        return clone;
    }

    public @Nullable String getScope() {
        return this.scope;
    }

    public int getMode() {
        return this.mode;
    }

    public boolean isModeEnabled(int modeMask) {
        return (this.mode & modeMask) != 0;
    }

    public void setMarkupConfig(@Nullable IMarkupConfig config) {
        if (config != null) {
            config.seal();
        }
        if (this.config != config) {
            this.config = (ICommonmarkConfig)config;
            this.sourceBlocks = null;
            this.inlineParser = null;
        }
    }

    public @Nullable ICommonmarkConfig getMarkupConfig() {
        return this.config;
    }

    public void processContent(MarkupParser2 parser, SourceContent content, boolean asDocument) {
        if (parser == null) {
            throw new NullPointerException("parser");
        }
        if (content == null) {
            throw new NullPointerException("content");
        }
        if (parser.getBuilder() == null) {
            throw new NullPointerException("parser.builder");
        }
        if (DEBUG_LOG_EVENTS) {
            StringWriter out = new StringWriter();
            try {
                MarkupEventPrinter printer = new MarkupEventPrinter(content.getText(), (MarkupLanguage)this, (Writer)out);
                MarkupParser2 debugParser = new MarkupParser2((IMarkupLanguage)this, (DocumentBuilder)new MultiplexingDocumentBuilder(new DocumentBuilder[]{printer, parser.getBuilder()}), parser.getFlags());
                this.doProcessContent(debugParser, content, asDocument);
                System.out.println(out.toString());
            }
            catch (Exception e) {
                System.out.println(out.toString());
                e.printStackTrace();
            }
        } else {
            this.doProcessContent(parser, content, asDocument);
        }
    }

    protected void doProcessContent(MarkupParser2 parser, SourceContent content, boolean asDocument) {
        DocumentBuilder builder = (DocumentBuilder)ObjectUtils.nonNullAssert((Object)parser.getBuilder());
        ContentLineSequence lineSequence = new ContentLineSequence(content.getText(), content.getLines());
        ProcessingContext context = this.createContext();
        if (asDocument) {
            builder.beginDocument();
        }
        if (parser.isEnabled(4096)) {
            context.getSourceBlocks().parseSourceStruct(context, lineSequence, builder);
        } else {
            List<SourceBlockItem<?>> items = context.getSourceBlocks().createItems(lineSequence);
            context.getSourceBlocks().initializeContext(context, items);
            context.getSourceBlocks().emit(context, items, builder);
        }
        if (asDocument) {
            builder.endDocument();
        }
    }

    public void processContent(MarkupParser parser, String markupContent, boolean asDocument) {
        this.processContent(new MarkupParser2(parser), new SourceContent(0L, markupContent), asDocument);
    }

    public WikitextProblemReporter getProblemReporter() {
        WikitextProblemReporter validator = this.validator;
        if (validator == null) {
            this.validator = validator = new WikitextProblemReporter();
        }
        return validator;
    }

    public IMarkupSourceFormatAdapter getSourceFormatAdapter() {
        CommonmarkSourceFormatAdapter sourceAdapter = this.sourceAdapter;
        if (sourceAdapter == null) {
            this.sourceAdapter = sourceAdapter = new CommonmarkSourceFormatAdapter();
        }
        return sourceAdapter;
    }

    public @Nullable IdGenerationStrategy getIdGenerationStrategy() {
        return (this.mode & 0x100) != 0 ? new CommonmarkIdGenerationStrategy() : null;
    }

    private IdGenerator createIdGenerator() {
        IdGenerationStrategy idGenerationStrategy = this.getIdGenerationStrategy();
        if (idGenerationStrategy != null) {
            IdGenerator generator = new IdGenerator();
            generator.setGenerationStrategy(idGenerationStrategy);
            return generator;
        }
        return new NullIdGenerator();
    }

    private ProcessingContext createContext() {
        InlineParser inlineParser;
        SourceBlocks sourceBlocks = this.sourceBlocks;
        if (sourceBlocks == null) {
            this.sourceBlocks = sourceBlocks = Commonmark.newSourceBlocks(this.config);
        }
        if ((inlineParser = this.inlineParser) == null) {
            this.inlineParser = inlineParser = (this.mode & 0x10000) != 0 ? Commonmark.newInlineParserMarkdown() : Commonmark.newInlineParserCommonMark(this.config);
        }
        ProcessingContext context = new ProcessingContext(sourceBlocks, inlineParser, this.createIdGenerator(), 1);
        return context;
    }

    public int hashCode() {
        return this.getName().hashCode() + this.mode;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj != null && obj.getClass() == ((Object)((Object)this)).getClass()) {
            CommonmarkLanguage other = (CommonmarkLanguage)((Object)obj);
            return this.getName().equals(other.getName()) && this.mode == other.mode && Objects.equals(this.config, other.getMarkupConfig());
        }
        return false;
    }
}

