/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.operation;

import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BiConsumer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.scout.sdk.core.imports.IImportCollector;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.SdkException;
import org.eclipse.scout.sdk.s2e.environment.EclipseEnvironment;
import org.eclipse.scout.sdk.s2e.environment.EclipseProgress;
import org.eclipse.scout.sdk.s2e.util.JdtUtils;

public class ImportsCreateOperation
implements BiConsumer<EclipseEnvironment, EclipseProgress> {
    private final Set<String> m_importsToCreate = new TreeSet<String>();
    private final ICompilationUnit m_icu;

    public ImportsCreateOperation(ICompilationUnit icu) {
        this.m_icu = icu;
    }

    public ImportsCreateOperation(ICompilationUnit icu, IImportCollector validator) {
        this(icu);
        if (validator != null) {
            validator.getImports().map(StringBuilder::toString).forEach(this::addImportToCreate);
        }
    }

    @Override
    public void accept(EclipseEnvironment env, EclipseProgress progress) {
        Ensure.isTrue((boolean)JdtUtils.exists((IJavaElement)this.getCompilationUnit()));
        try {
            for (String s : this.m_importsToCreate) {
                this.getCompilationUnit().createImport(s, null, (IProgressMonitor)progress.monitor());
            }
        }
        catch (JavaModelException e) {
            throw new SdkException((Throwable)e);
        }
    }

    public ICompilationUnit getCompilationUnit() {
        return this.m_icu;
    }

    public boolean addImportToCreate(String imp) {
        return this.m_importsToCreate.add(imp);
    }

    public boolean removeImportToCreate(String imp) {
        return this.m_importsToCreate.remove(imp);
    }

    public void setImportsToCreate(Collection<String> imports) {
        this.m_importsToCreate.clear();
        this.m_importsToCreate.addAll(imports);
    }

    public String toString() {
        return "Create imports";
    }
}

