/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.forms.internal.widgets.formtextkit;

import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.rap.json.JsonArray;
import org.eclipse.rap.json.JsonObject;
import org.eclipse.rap.json.JsonValue;
import org.eclipse.rap.rwt.internal.lifecycle.AbstractWidgetLCA;
import org.eclipse.rap.rwt.internal.lifecycle.ControlLCAUtil;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetLCAUtil;
import org.eclipse.rap.rwt.internal.protocol.RemoteObjectFactory;
import org.eclipse.rap.rwt.remote.OperationHandler;
import org.eclipse.rap.rwt.remote.RemoteObject;
import org.eclipse.rap.rwt.widgets.WidgetUtil;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.graphics.ImageFactory;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.HyperlinkSettings;
import org.eclipse.ui.forms.internal.widgets.IAggregateHyperlinkSegmentAdapter;
import org.eclipse.ui.forms.internal.widgets.IBulletParagraphAdapter;
import org.eclipse.ui.forms.internal.widgets.IFormTextAdapter;
import org.eclipse.ui.forms.internal.widgets.ITextSegmentAdapter;
import org.eclipse.ui.forms.internal.widgets.formtextkit.FormTextOperationHandler;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.internal.forms.widgets.AggregateHyperlinkSegment;
import org.eclipse.ui.internal.forms.widgets.BulletParagraph;
import org.eclipse.ui.internal.forms.widgets.ImageHyperlinkSegment;
import org.eclipse.ui.internal.forms.widgets.ImageSegment;
import org.eclipse.ui.internal.forms.widgets.Paragraph;
import org.eclipse.ui.internal.forms.widgets.ParagraphSegment;
import org.eclipse.ui.internal.forms.widgets.TextHyperlinkSegment;
import org.eclipse.ui.internal.forms.widgets.TextSegment;

public class FormTextLCA
extends AbstractWidgetLCA {
    private static final String TYPE = "forms.widgets.FormText";
    private static final Pattern FONT_NAME_FILTER_PATTERN = Pattern.compile("\"|\\\\");
    private static final String PREFIX = "resource/widget/rap/formtext/";
    private static final String BULLET_CIRCLE_GIF = "resource/widget/rap/formtext/bullet_circle.gif";
    private static final String PROP_BOUNDS = "bounds";
    private static final String PROP_TEXT = "text";
    private static final String PROP_HYPERLINK_SETTINGS = "hyperlinkSettings";
    private static final String PROP_HYPERLINK_UNDERLINE_MODE = "hyperlinkUnderlineMode";
    private static final String PROP_HYPERLINK_FOREGROUND = "hyperlinkForeground";
    private static final String PROP_HYPERLINK_ACTIVE_FOREGROUND = "hyperlinkActiveForeground";
    private static final String PROP_RESOURCE_TABLE = "resourceTable";

    public void preserveValues(Widget widget) {
        FormText formText = (FormText)widget;
        ControlLCAUtil.preserveValues((Control)formText);
        WidgetLCAUtil.preserveCustomVariant((Widget)formText);
        HyperlinkSettings settings = formText.getHyperlinkSettings();
        WidgetLCAUtil.preserveProperty((Widget)formText, (String)PROP_HYPERLINK_UNDERLINE_MODE, (int)settings.getHyperlinkUnderlineMode());
        WidgetLCAUtil.preserveProperty((Widget)formText, (String)PROP_HYPERLINK_FOREGROUND, (Object)settings.getForeground());
        WidgetLCAUtil.preserveProperty((Widget)formText, (String)PROP_HYPERLINK_ACTIVE_FOREGROUND, (Object)settings.getActiveForeground());
        WidgetLCAUtil.preserveProperty((Widget)widget, (String)PROP_RESOURCE_TABLE, (Object)FormTextLCA.getResourceTable(formText));
    }

    public void renderInitialization(Widget widget) throws IOException {
        FormText formText = (FormText)widget;
        RemoteObject remoteObject = RemoteObjectFactory.createRemoteObject((Widget)formText, (String)TYPE);
        remoteObject.setHandler((OperationHandler)new FormTextOperationHandler(formText));
        remoteObject.set("parent", WidgetUtil.getId((Widget)formText.getParent()));
    }

    public void renderChanges(Widget widget) throws IOException {
        FormText formText = (FormText)widget;
        ControlLCAUtil.renderChanges((Control)formText);
        WidgetLCAUtil.renderCustomVariant((Widget)formText);
        FormTextLCA.renderHyperlinkSettings(formText);
        FormTextLCA.renderText(formText);
    }

    private static void renderHyperlinkSettings(FormText formText) {
        if (FormTextLCA.hasHyperlinkSettingsChanged(formText)) {
            HyperlinkSettings newValue = formText.getHyperlinkSettings();
            int underlineMode = newValue.getHyperlinkUnderlineMode();
            Color foreground = newValue.getForeground();
            Color activeForeground = newValue.getActiveForeground();
            JsonArray args = new JsonArray().add(underlineMode).add(FormTextLCA.getColorAsArray(foreground)).add(FormTextLCA.getColorAsArray(activeForeground));
            RemoteObjectFactory.getRemoteObject((Widget)formText).set(PROP_HYPERLINK_SETTINGS, (JsonValue)args);
        }
    }

    private static void renderText(FormText formText) {
        if (FormTextLCA.hasLayoutChanged(formText) || FormTextLCA.hasResourceTableChanged(formText) || FormTextLCA.hasBoundsChanged(formText)) {
            Paragraph[] paragraphs = FormTextLCA.getParagraphs(formText);
            JsonArray buffer = new JsonArray();
            int i = 0;
            while (i < paragraphs.length) {
                Paragraph paragraph = paragraphs[i];
                if (paragraph instanceof BulletParagraph) {
                    BulletParagraph bullet = (BulletParagraph)paragraph;
                    FormTextLCA.appendBullet(formText, bullet, buffer);
                }
                ParagraphSegment[] segments = paragraph.getSegments();
                FormTextLCA.appendSegments(formText, segments, buffer);
                ++i;
            }
            RemoteObjectFactory.getRemoteObject((Widget)formText).set(PROP_TEXT, (JsonValue)buffer);
        }
    }

    private static void appendBullet(FormText formText, BulletParagraph bullet, JsonArray buffer) {
        int style = bullet.getBulletStyle();
        Image image = FormTextLCA.getBulletImage(formText, bullet);
        String imageName = ImageFactory.getImagePath((Image)image);
        String text = bullet.getBulletText();
        Rectangle bounds = FormTextLCA.getBulletBounds(bullet);
        if (bounds != null) {
            JsonArray args = new JsonArray().add("bullet").add(style).add(imageName).add(text).add((JsonValue)FormTextLCA.getBoundsAsArray(bounds));
            buffer.add((JsonValue)args);
        }
    }

    private static void appendSegments(FormText formText, ParagraphSegment[] segments, JsonArray buffer) {
        int i = 0;
        while (i < segments.length) {
            ParagraphSegment segment = segments[i];
            if (segment instanceof TextHyperlinkSegment) {
                FormTextLCA.appendTextHyperlinkSegment(formText, (TextHyperlinkSegment)segment, buffer);
            } else if (segment instanceof TextSegment) {
                FormTextLCA.appendTextSegment(formText, (TextSegment)segment, buffer);
            } else if (segment instanceof ImageHyperlinkSegment) {
                FormTextLCA.appendImageHyperlinkSegment(formText, (ImageHyperlinkSegment)segment, buffer);
            } else if (segment instanceof ImageSegment) {
                FormTextLCA.appendImageSegment(formText, (ImageSegment)segment, buffer);
            } else if (segment instanceof AggregateHyperlinkSegment) {
                FormTextLCA.appendAggregateHyperlinkSegment(formText, (AggregateHyperlinkSegment)segment, buffer);
            }
            ++i;
        }
    }

    private static void appendTextHyperlinkSegment(FormText formText, TextHyperlinkSegment segment, JsonArray buffer) {
        String[] textFragments = FormTextLCA.getTextFragments(segment);
        String tooltipText = segment.getTooltipText();
        Rectangle[] textFragmentsBounds = FormTextLCA.getTextFragmentsBounds(segment);
        String fontId = FormTextLCA.getFontId(segment);
        Font font = null;
        if (fontId != null) {
            font = (Font)FormTextLCA.getResourceTable(formText).get(fontId);
        }
        int i = 0;
        while (i < textFragments.length) {
            JsonArray args = new JsonArray().add("textHyperlink").add(textFragments[i]).add(tooltipText).add((JsonValue)FormTextLCA.getBoundsAsArray(textFragmentsBounds[i])).add(FormTextLCA.getFontAsArray(font));
            buffer.add((JsonValue)args);
            ++i;
        }
    }

    private static void appendTextSegment(FormText formText, TextSegment segment, JsonArray buffer) {
        String[] textFragments = FormTextLCA.getTextFragments(segment);
        Rectangle[] textFragmentsBounds = FormTextLCA.getTextFragmentsBounds(segment);
        String fontId = FormTextLCA.getFontId(segment);
        Font font = null;
        if (fontId != null) {
            font = (Font)FormTextLCA.getResourceTable(formText).get(fontId);
        }
        String colorId = segment.getColorId();
        Color color = null;
        if (colorId != null) {
            color = (Color)FormTextLCA.getResourceTable(formText).get(colorId);
        }
        int i = 0;
        while (i < textFragments.length) {
            JsonArray args = new JsonArray().add(PROP_TEXT).add(textFragments[i]).add((JsonValue)FormTextLCA.getBoundsAsArray(textFragmentsBounds[i])).add(FormTextLCA.getFontAsArray(font)).add(FormTextLCA.getColorAsArray(color));
            buffer.add((JsonValue)args);
            ++i;
        }
    }

    private static void appendImageHyperlinkSegment(FormText formText, ImageHyperlinkSegment segment, JsonArray buffer) {
        String tooltipText = segment.getTooltipText();
        Rectangle bounds = segment.getBounds();
        Image image = segment.getImage(FormTextLCA.getResourceTable(formText));
        String imageName = ImageFactory.getImagePath((Image)image);
        JsonArray args = new JsonArray().add("imageHyperlink").add(imageName).add(tooltipText).add((JsonValue)FormTextLCA.getBoundsAsArray(bounds));
        buffer.add((JsonValue)args);
    }

    private static void appendImageSegment(FormText formText, ImageSegment segment, JsonArray buffer) {
        Rectangle bounds = segment.getBounds();
        Image image = segment.getImage(FormTextLCA.getResourceTable(formText));
        String imageName = ImageFactory.getImagePath((Image)image);
        JsonArray args = new JsonArray().add("image").add(imageName).add((JsonValue)FormTextLCA.getBoundsAsArray(bounds));
        buffer.add((JsonValue)args);
    }

    private static void appendAggregateHyperlinkSegment(FormText formText, AggregateHyperlinkSegment segment, JsonArray buffer) {
        Object[] segments = FormTextLCA.getHyperlinkSegments(segment);
        int i = 0;
        while (i < segments.length) {
            Object hyperlinkSegment = segments[i];
            if (hyperlinkSegment instanceof TextHyperlinkSegment) {
                FormTextLCA.appendTextHyperlinkSegment(formText, (TextHyperlinkSegment)hyperlinkSegment, buffer);
            } else if (hyperlinkSegment instanceof ImageHyperlinkSegment) {
                FormTextLCA.appendImageHyperlinkSegment(formText, (ImageHyperlinkSegment)hyperlinkSegment, buffer);
            }
            ++i;
        }
    }

    private static boolean hasHyperlinkSettingsChanged(FormText formText) {
        HyperlinkSettings newValue = formText.getHyperlinkSettings();
        Integer underlineMode = new Integer(newValue.getHyperlinkUnderlineMode());
        Color foreground = newValue.getForeground();
        Color actForeground = newValue.getActiveForeground();
        return WidgetLCAUtil.hasChanged((Widget)formText, (String)PROP_HYPERLINK_UNDERLINE_MODE, (Object)underlineMode) || WidgetLCAUtil.hasChanged((Widget)formText, (String)PROP_HYPERLINK_FOREGROUND, (Object)foreground) || WidgetLCAUtil.hasChanged((Widget)formText, (String)PROP_HYPERLINK_ACTIVE_FOREGROUND, (Object)actForeground);
    }

    private static Paragraph[] getParagraphs(FormText formText) {
        IFormTextAdapter adapter = FormTextLCA.getAdapter(formText);
        return adapter.getParagraphs();
    }

    private static boolean hasLayoutChanged(FormText formText) {
        IFormTextAdapter adapter = FormTextLCA.getAdapter(formText);
        return adapter.hasLayoutChanged();
    }

    private static boolean hasResourceTableChanged(FormText formText) {
        Hashtable resourceTable = FormTextLCA.getResourceTable(formText);
        return WidgetLCAUtil.hasChanged((Widget)formText, (String)PROP_RESOURCE_TABLE, (Object)resourceTable);
    }

    private static boolean hasBoundsChanged(FormText formText) {
        return WidgetLCAUtil.hasChanged((Widget)formText, (String)PROP_BOUNDS, (Object)formText.getBounds());
    }

    private static IFormTextAdapter getAdapter(FormText formText) {
        Object adapter = formText.getAdapter(IFormTextAdapter.class);
        return (IFormTextAdapter)adapter;
    }

    private static ITextSegmentAdapter getAdapter(TextSegment segment) {
        Object adapter = segment.getAdapter(ITextSegmentAdapter.class);
        return (ITextSegmentAdapter)adapter;
    }

    private static IBulletParagraphAdapter getAdapter(BulletParagraph bullet) {
        Object adapter = bullet.getAdapter(IBulletParagraphAdapter.class);
        return (IBulletParagraphAdapter)adapter;
    }

    private static IAggregateHyperlinkSegmentAdapter getAdapter(AggregateHyperlinkSegment segment) {
        Object adapter = segment.getAdapter(IAggregateHyperlinkSegmentAdapter.class);
        return (IAggregateHyperlinkSegmentAdapter)adapter;
    }

    private static Image getBulletImage(FormText formText, BulletParagraph bullet) {
        Image img;
        String text;
        Image bulletImage = FormTextLCA.getImage((Device)formText.getDisplay(), BULLET_CIRCLE_GIF);
        if (bullet.getBulletStyle() == 3 && (text = bullet.getBulletText()) != null && (img = (Image)FormTextLCA.getResourceTable(formText).get(text)) != null) {
            bulletImage = img;
        }
        return bulletImage;
    }

    private static Rectangle getBulletBounds(BulletParagraph bullet) {
        return FormTextLCA.getAdapter(bullet).getBulletBounds();
    }

    private static Hashtable getResourceTable(FormText formText) {
        return FormTextLCA.getAdapter(formText).getResourceTable();
    }

    private static String[] getTextFragments(TextSegment segment) {
        return FormTextLCA.getAdapter(segment).getTextFragments();
    }

    private static Rectangle[] getTextFragmentsBounds(TextSegment segment) {
        return FormTextLCA.getAdapter(segment).getTextFragmentsBounds();
    }

    private static String getFontId(TextSegment segment) {
        return FormTextLCA.getAdapter(segment).getFontId();
    }

    private static Object[] getHyperlinkSegments(AggregateHyperlinkSegment segment) {
        return FormTextLCA.getAdapter(segment).getHyperlinkSegments();
    }

    private static JsonArray getBoundsAsArray(Rectangle bounds) {
        return new JsonArray().add(bounds.x).add(bounds.y).add(bounds.width).add(bounds.height);
    }

    private static JsonValue getFontAsArray(Font font) {
        JsonValue result = JsonObject.NULL;
        if (font != null) {
            result = new JsonArray().add((JsonValue)FormTextLCA.getFontName(font)).add(FormTextLCA.getFontSize(font)).add(FormTextLCA.getFontStyle(font, 1)).add(FormTextLCA.getFontStyle(font, 2));
        }
        return result;
    }

    private static JsonArray getFontName(Font font) {
        JsonArray resutl = new JsonArray();
        FontData fontData = font.getFontData()[0];
        String fontName = fontData.getName();
        String[] names = fontName.split(",");
        int i = 0;
        while (i < names.length) {
            names[i] = names[i].trim();
            Matcher matcher = FONT_NAME_FILTER_PATTERN.matcher(names[i]);
            names[i] = matcher.replaceAll("");
            resutl.add(names[i]);
            ++i;
        }
        return resutl;
    }

    private static int getFontSize(Font font) {
        return font.getFontData()[0].getHeight();
    }

    private static boolean getFontStyle(Font font, int style) {
        return (font.getFontData()[0].getStyle() & style) != 0;
    }

    private static JsonValue getColorAsArray(Color color) {
        JsonValue result = JsonObject.NULL;
        if (color != null) {
            RGB rgb = color.getRGB();
            result = new JsonArray().add(rgb.red).add(rgb.green).add(rgb.blue).add(255);
        }
        return result;
    }

    public static Image getImage(Device device, String path) {
        ClassLoader classLoader = FormTextLCA.class.getClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream(path);
        Image result = null;
        if (inputStream != null) {
            try {
                result = new Image(device, inputStream);
            }
            catch (Throwable throwable) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
        return result;
    }
}

