/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.xtext.base.scoping;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.internal.utilities.PathElement;
import org.eclipse.ocl.xtext.base.as2cs.AliasAnalysis;
import org.eclipse.ocl.xtext.basecs.PathElementCS;
import org.eclipse.ocl.xtext.basecs.RootPackageCS;
import org.eclipse.xtext.naming.QualifiedName;

public class QualifiedPath
extends QualifiedName {
    private final List<PathElement> pathElements;
    private final boolean isAbsolute;

    private static String[] getSegments(List<PathElement> pathElements) {
        String[] segments = new String[pathElements.size()];
        int i = 0;
        while (i < segments.length) {
            segments[i] = pathElements.get(i).getName();
            ++i;
        }
        return segments;
    }

    public QualifiedPath(List<PathElement> pathElements) {
        this(pathElements, true);
    }

    protected QualifiedPath(List<PathElement> pathElements, boolean isAbsolute) {
        super(QualifiedPath.getSegments(pathElements));
        this.pathElements = pathElements;
        this.isAbsolute = isAbsolute;
    }

    public QualifiedPath deresolve(QualifiedPath contextPath) {
        List<PathElement> thisPath = this.pathElements;
        List<PathElement> thatPath = contextPath.pathElements;
        int iSize = thisPath.size();
        if (iSize <= 0) {
            return this;
        }
        int i = PathElement.getCommonLength(thisPath, thatPath);
        if (i <= 0) {
            return this;
        }
        if (i >= iSize) {
            return this;
        }
        ArrayList<PathElement> newPath = new ArrayList<PathElement>();
        while (i < iSize - 1) {
            newPath.add(thisPath.get(i));
            ++i;
        }
        newPath.add(thisPath.get(iSize - 1));
        return new QualifiedPath(newPath, false);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof QualifiedPath) {
            QualifiedPath other = (QualifiedPath)((Object)obj);
            if (this.hashCode() != other.hashCode()) {
                return false;
            }
            if (this.isAbsolute != other.isAbsolute) {
                return false;
            }
            int iMax = this.pathElements.size();
            if (iMax != other.pathElements.size()) {
                return false;
            }
            int i = 0;
            while (i < iMax) {
                if (!this.pathElements.get(i).equals(other.pathElements.get(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return super.equals(obj);
    }

    public List<String> getSegments(EObject csObject) {
        ArrayList<String> segments = new ArrayList<String>();
        int segmentCount = this.getSegmentCount();
        if (segmentCount == 0) {
            return segments;
        }
        if (this.isAbsolute) {
            EObject root = EcoreUtil.getRootContainer((EObject)csObject);
            Resource csResource = root.eResource();
            Resource asResource = null;
            if (root instanceof RootPackageCS) {
                Element root2 = ((RootPackageCS)root).getPivot();
                asResource = EcoreUtil.getRootContainer((EObject)root2).eResource();
            }
            Element firstElement = null;
            firstElement = csObject instanceof PathElementCS ? ((PathElementCS)csObject).getReferredElement() : this.pathElements.get(0).getElement();
            if (firstElement instanceof Package && !firstElement.eIsProxy()) {
                Resource elementResource = firstElement.eResource();
                if (csResource != null && elementResource != csResource && elementResource != asResource) {
                    AliasAnalysis adapter = AliasAnalysis.getAdapter(csResource);
                    if (segmentCount == 1) {
                        String alias = adapter.getAlias((EObject)firstElement, null);
                        if (alias != null) {
                            segments.add(alias);
                            segments.add(this.getFirstSegment());
                        }
                    } else {
                        int i = segmentCount - 2;
                        while (i >= 0) {
                            String alias;
                            Element element = this.pathElements.get(i).getElement();
                            if (element != null && (alias = adapter.getAlias((EObject)element, null)) != null) {
                                segments.add(alias);
                                if (segmentCount == 1) {
                                    segments.add(((NamedElement)firstElement).getName());
                                } else {
                                    ++i;
                                    while (i < segmentCount) {
                                        segments.add(this.getSegment(i));
                                        ++i;
                                    }
                                }
                                return segments;
                            }
                            --i;
                        }
                    }
                }
            }
        }
        if (segments.size() == 0) {
            segments.add(this.getFirstSegment());
        }
        int i = 1;
        while (i < segmentCount) {
            segments.add(this.getSegment(i));
            ++i;
        }
        return segments;
    }

    public String toString() {
        if (this.getSegmentCount() == 0) {
            return "";
        }
        if (this.getSegmentCount() == 1) {
            return this.getFirstSegment();
        }
        StringBuilder builder = new StringBuilder();
        boolean isFirst = true;
        for (String segment : this.getSegments()) {
            if (!isFirst) {
                builder.append("::");
            }
            isFirst = false;
            builder.append(segment);
        }
        return builder.toString();
    }
}

