/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.xotcl.internal.core.parser.processors.xotcl;

import org.eclipse.dltk.ast.ASTListNode;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.compiler.problem.ProblemSeverities;
import org.eclipse.dltk.tcl.ast.TclStatement;
import org.eclipse.dltk.tcl.core.AbstractTclCommandProcessor;
import org.eclipse.dltk.tcl.core.ITclParser;
import org.eclipse.dltk.xotcl.core.ast.xotcl.XOTclExInstanceVariable;
import org.eclipse.dltk.xotcl.core.ast.xotcl.XOTclInstanceVariable;
import org.eclipse.dltk.xotcl.core.ast.xotcl.XOTclObjectDeclaration;
import org.eclipse.dltk.xotcl.core.ast.xotcl.XOTclProcCallStatement;

public class XOTclProcCallProcessor
extends AbstractTclCommandProcessor {
    public ASTNode process(TclStatement statement, ITclParser parser, ASTNode parent) {
        Object param = this.getDetectedParameter();
        if (param == null || !(param instanceof TypeDeclaration) && !(param instanceof XOTclObjectDeclaration) && !(param instanceof XOTclInstanceVariable) && !(param instanceof XOTclExInstanceVariable)) {
            return null;
        }
        Expression nameExpr = statement.getAt(1);
        if (!(nameExpr instanceof SimpleReference)) {
            this.report(parser, "A proc name expected.", (ASTNode)nameExpr, ProblemSeverities.Error);
            return null;
        }
        SimpleReference name = (SimpleReference)nameExpr;
        ASTListNode args = null;
        if (statement.getCount() > 2) {
            args = new ASTListNode(name.sourceEnd() + 1, statement.sourceEnd());
            int i = 2;
            while (i < statement.getCount()) {
                args.addNode((ASTNode)statement.getAt(i));
                ++i;
            }
        }
        XOTclProcCallStatement call = new XOTclProcCallStatement(name, (ASTNode)param, args);
        call.setInstNameRef((SimpleReference)statement.getAt(0));
        call.setStart(statement.sourceStart());
        call.setEnd(statement.sourceEnd());
        this.addToParent(parent, (ASTNode)call);
        return call;
    }
}

