/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.core.packages;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.dltk.tcl.ast.AstFactory;
import org.eclipse.dltk.tcl.ast.StringArgument;
import org.eclipse.dltk.tcl.ast.Substitution;
import org.eclipse.dltk.tcl.ast.TclArgument;
import org.eclipse.dltk.tcl.ast.VariableReference;
import org.eclipse.dltk.tcl.core.TclParseUtil;
import org.eclipse.dltk.tcl.parser.ITclErrorReporter;
import org.eclipse.dltk.tcl.parser.TclErrorCollector;
import org.eclipse.dltk.tcl.parser.TclParser;
import org.eclipse.dltk.tcl.parser.TclParserUtils;
import org.eclipse.dltk.tcl.parser.TclVisitor;
import org.eclipse.dltk.tcl.parser.printer.SimpleCodePrinter;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class TclVariableResolver {
    private final IVariableRegistry registry;

    public TclVariableResolver(IVariableRegistry registry) {
        this.registry = registry;
    }

    public String resolve(String value) {
        return this.resolve(value, new HashSet<String>());
    }

    private String resolve(String value, Set<String> requests) {
        if (value == null || value.indexOf(36) == -1) {
            return value;
        }
        TclParser parser = new TclParser();
        TclErrorCollector collector = new TclErrorCollector();
        List result = parser.parse(value, (ITclErrorReporter)collector, null);
        if (collector.getCount() > 0) {
            return value;
        }
        final ArrayList variables = new ArrayList();
        TclParserUtils.traverse((List)result, (TclVisitor)new TclVisitor(){

            public boolean visit(VariableReference list) {
                variables.add(list);
                return super.visit(list);
            }

            public boolean visit(Substitution substitution) {
                return false;
            }
        });
        if (variables.isEmpty()) {
            return value;
        }
        for (VariableReference variableReference : variables) {
            String resultValue;
            EObject container = variableReference.eContainer();
            if (container == null) continue;
            String request = value.substring(variableReference.getStart(), variableReference.getEnd());
            if (!requests.add(request)) {
                return null;
            }
            try {
                resultValue = this.resolveVariable(variableReference, requests);
            }
            finally {
                requests.remove(request);
            }
            if (resultValue == null) {
                return null;
            }
            StringArgument string = AstFactory.eINSTANCE.createStringArgument();
            string.setValue(resultValue);
            string.setStart(variableReference.getStart());
            string.setEnd(variableReference.getEnd());
            EcoreUtil.replace((EObject)variableReference, (EObject)string);
        }
        return SimpleCodePrinter.getCommandsString((List)result, (boolean)false).trim();
    }

    private String resolveVariable(VariableReference variable, Set<String> requests) {
        String indexValue;
        TclArgument index = variable.getIndex();
        if (index != null) {
            String value;
            indexValue = index instanceof StringArgument ? ((StringArgument)index).getValue() : this.resolve(SimpleCodePrinter.getArgumentString((TclArgument)index, (int)0, (boolean)false), requests);
            if (indexValue != null && (value = this.registry.getValue(String.valueOf(TclParseUtil.escapeName(variable.getName())) + '(' + TclParseUtil.escapeName(indexValue) + ')', null)) != null) {
                return this.resolve(value, requests);
            }
        } else {
            indexValue = null;
        }
        return this.resolve(this.registry.getValue(variable.getName(), indexValue), requests);
    }

    public static String[] extractVariableNames(String value) {
        TclParser parser = new TclParser();
        TclErrorCollector collector = new TclErrorCollector();
        List result = parser.parse(value, (ITclErrorReporter)collector, null);
        if (collector.getCount() > 0) {
            return null;
        }
        final ArrayList variables = new ArrayList();
        TclParserUtils.traverse((List)result, (TclVisitor)new TclVisitor(){

            public boolean visit(VariableReference list) {
                variables.add(list.getName());
                return super.visit(list);
            }

            public boolean visit(Substitution substitution) {
                return false;
            }
        });
        if (variables.isEmpty()) {
            return null;
        }
        return variables.toArray(new String[variables.size()]);
    }

    public static interface IVariableRegistry {
        public String getValue(String var1, String var2);
    }

    public static class SimpleVariableRegistry
    implements IVariableRegistry {
        private final Map<String, Object> values;

        public SimpleVariableRegistry(Map<String, Object> values) {
            this.values = values;
        }

        @Override
        public String getValue(String name, String index) {
            Object value = this.values.get(name);
            if (value instanceof Map) {
                if (index == null) {
                    index = "";
                }
                Map map = (Map)value;
                return (String)map.get(index);
            }
            return (String)value;
        }
    }
}

