/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.vagrant.core;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.runtime.Platform;
import org.eclipse.linuxtools.internal.vagrant.core.VagrantConnection;
import org.eclipse.linuxtools.vagrant.core.IVagrantConnection;
import org.eclipse.linuxtools.vagrant.core.IVagrantVM;
import org.eclipse.linuxtools.vagrant.core.IVagrantVMListener;

public class VagrantVMRefreshManager
implements IVagrantVMListener {
    private static VagrantVMRefreshManager instance;
    private final long DEFAULT_REFRESH_TIME = 15L;
    private Map<IVagrantConnection, ContainerRefreshThread> refreshThreadMap = new HashMap<IVagrantConnection, ContainerRefreshThread>();

    private VagrantVMRefreshManager() {
    }

    public static VagrantVMRefreshManager getInstance() {
        if (instance == null) {
            instance = new VagrantVMRefreshManager();
        }
        return instance;
    }

    @Override
    public synchronized void listChanged(IVagrantConnection connection, List<IVagrantVM> dclist) {
        ContainerRefreshThread rt = this.refreshThreadMap.get(connection);
        if (rt == null) {
            long refreshRateInSeconds = Platform.getPreferencesService().getLong("org.eclipse.linuxtools.vagrant.ui", "containerRefreshTime", 15L, null);
            rt = new ContainerRefreshThread(connection, TimeUnit.SECONDS.toMillis(refreshRateInSeconds));
            rt.start();
            this.refreshThreadMap.put(connection, rt);
        }
    }

    public void setRefreshTime(long seconds) {
        if (seconds >= 5L) {
            long refreshRate = TimeUnit.SECONDS.toMillis(seconds);
            for (ContainerRefreshThread t : this.refreshThreadMap.values()) {
                t.setSleepTime(refreshRate);
            }
        }
    }

    public void killAllThreads() {
        for (ContainerRefreshThread rt : this.refreshThreadMap.values()) {
            rt.kill();
            this.refreshThreadMap.remove(rt.getConnection());
        }
    }

    private class ContainerRefreshThread
    extends Thread {
        private IVagrantConnection connection;
        private long sleepTime;
        private boolean kill;

        public ContainerRefreshThread(IVagrantConnection connection, long sleepTime) {
            this.connection = connection;
            this.sleepTime = sleepTime;
        }

        public IVagrantConnection getConnection() {
            return this.connection;
        }

        public synchronized long getSleepTime() {
            return this.sleepTime;
        }

        public synchronized void setSleepTime(long newTime) {
            this.sleepTime = newTime;
            this.interrupt();
        }

        public void kill() {
            this.kill = true;
            this.interrupt();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        Thread.sleep(this.getSleepTime());
                        VagrantVMRefreshManager vagrantVMRefreshManager = instance;
                        synchronized (vagrantVMRefreshManager) {
                            this.connection.removeVMListener(instance);
                            ((VagrantConnection)this.connection).getVMs(true);
                            this.connection.addVMListener(instance);
                        }
                    }
                }
                catch (InterruptedException e) {
                    if (!this.kill) continue;
                    return;
                }
                break;
            }
        }
    }
}

