/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.common.project.facet.core.internal;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jst.common.project.facet.core.IClasspathProvider;
import org.eclipse.jst.common.project.facet.core.JavaFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponent;

public final class StandardJreClasspathProvider
implements IClasspathProvider {
    private IRuntimeComponent rc;

    public StandardJreClasspathProvider(IRuntimeComponent rc) {
        this.rc = rc;
    }

    @Override
    public List<IClasspathEntry> getClasspathEntries(IProjectFacetVersion fv) {
        IVMInstall vmInstall;
        if (fv.getProjectFacet() == JavaFacet.FACET && (vmInstall = this.getVMInstall()) != null) {
            IPath cpEntryPath = JavaRuntime.newJREContainerPath((IVMInstall)vmInstall);
            IClasspathEntry cpEntry = JavaCore.newContainerEntry((IPath)cpEntryPath);
            return Collections.singletonList(cpEntry);
        }
        return null;
    }

    private IVMInstall getVMInstall() {
        String vmInstallTypeId = this.rc.getProperty("vm-install-type");
        String vmInstallId = this.rc.getProperty("vm-install-id");
        if (vmInstallTypeId == null || vmInstallId == null) {
            return null;
        }
        IVMInstallType vmInstallType = JavaRuntime.getVMInstallType((String)vmInstallTypeId);
        if (vmInstallType == null) {
            return null;
        }
        return vmInstallType.findVMInstall(vmInstallId);
    }

    public static final class Factory
    implements IAdapterFactory {
        private static final Class<?>[] ADAPTER_TYPES = new Class[]{IClasspathProvider.class};

        public Class<?>[] getAdapterList() {
            return ADAPTER_TYPES;
        }

        public <T> T getAdapter(Object adaptable, Class<T> adapterType) {
            IRuntimeComponent rc = (IRuntimeComponent)adaptable;
            return (T)new StandardJreClasspathProvider(rc);
        }
    }
}

