/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.editor;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.commands.CommandStackEvent;
import org.eclipse.gef.commands.CommandStackEventListener;
import org.eclipse.gef.commands.CommandStackListener;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.DeleteAction;
import org.eclipse.gef.ui.actions.PrintAction;
import org.eclipse.gef.ui.actions.RedoAction;
import org.eclipse.gef.ui.actions.SelectAllAction;
import org.eclipse.gef.ui.actions.UndoAction;
import org.eclipse.gef.ui.actions.UpdateAction;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.gef.ui.parts.SelectionSynchronizer;
import org.eclipse.gef.ui.properties.UndoablePropertySheetPage;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.views.properties.IPropertySheetPage;

public abstract class GraphicalComposite
extends Composite
implements CommandStackListener,
CommandStackEventListener,
ISelectionListener {
    private DefaultEditDomain editDomain;
    private GraphicalViewer graphicalViewer;
    private ActionRegistry actionRegistry;
    private SelectionSynchronizer synchronizer;
    private List selectionActions = new ActionIDList();
    private List stackActions = new ActionIDList();
    private List propertyActions = new ActionIDList();

    public GraphicalComposite(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout());
    }

    public void stackChanged(CommandStackEvent event) {
        if ((event.getDetail() & 0x338) != 0) {
            this.updateActions(this.stackActions);
        }
    }

    public void commandStackChanged(EventObject event) {
        this.updateActions(this.stackActions);
    }

    protected void configureGraphicalViewer() {
        this.getGraphicalViewer().getControl().setBackground(ColorConstants.listBackground);
    }

    protected void createActions() {
        if (this.getWorkbenchPart() != null) {
            IWorkbenchPart workbenchPart = this.getWorkbenchPart();
            ActionRegistry registry = this.getActionRegistry();
            UndoAction action = new UndoAction(workbenchPart);
            registry.registerAction((IAction)action);
            this.getStackActions().add(action.getId());
            action = new RedoAction(workbenchPart);
            registry.registerAction((IAction)action);
            this.getStackActions().add(action.getId());
            action = new SelectAllAction(workbenchPart);
            registry.registerAction((IAction)action);
            action = new DeleteAction(workbenchPart);
            registry.registerAction((IAction)action);
            this.getSelectionActions().add(action.getId());
            registry.registerAction((IAction)new PrintAction(workbenchPart));
        }
    }

    protected void createGraphicalViewer() {
        ScrollingGraphicalViewer viewer = new ScrollingGraphicalViewer();
        viewer.createControl((Composite)this);
        this.setGraphicalViewer((GraphicalViewer)viewer);
        this.configureGraphicalViewer();
        this.hookGraphicalViewer();
        this.initializeGraphicalViewer();
    }

    public void createControl() {
        this.createGraphicalViewer();
    }

    public void dispose() {
        this.getCommandStack().removeCommandStackEventListener((CommandStackEventListener)this);
        if (this.getWorkbenchPart() != null) {
            this.getWorkbenchPart().getSite().getWorkbenchWindow().getSelectionService().removeSelectionListener((ISelectionListener)this);
        }
        this.getEditDomain().setActiveTool(null);
        this.getActionRegistry().dispose();
        super.dispose();
    }

    protected void firePropertyChange(int property) {
        this.updateActions(this.propertyActions);
    }

    public ActionRegistry getActionRegistry() {
        if (this.actionRegistry == null) {
            this.actionRegistry = new ActionRegistry();
        }
        return this.actionRegistry;
    }

    public Object getAdapter(Class type) {
        if (type == IPropertySheetPage.class) {
            return new UndoablePropertySheetPage(this.getCommandStack(), this.getActionRegistry().getAction((Object)ActionFactory.UNDO.getId()), this.getActionRegistry().getAction((Object)ActionFactory.REDO.getId()));
        }
        if (type == GraphicalViewer.class) {
            return this.getGraphicalViewer();
        }
        if (type == CommandStack.class) {
            return this.getCommandStack();
        }
        if (type == ActionRegistry.class) {
            return this.getActionRegistry();
        }
        if (type == EditPart.class && this.getGraphicalViewer() != null) {
            return this.getGraphicalViewer().getRootEditPart();
        }
        if (type == IFigure.class && this.getGraphicalViewer() != null) {
            return ((GraphicalEditPart)this.getGraphicalViewer().getRootEditPart()).getFigure();
        }
        return null;
    }

    protected CommandStack getCommandStack() {
        return this.getEditDomain().getCommandStack();
    }

    public DefaultEditDomain getEditDomain() {
        return this.editDomain;
    }

    public GraphicalViewer getGraphicalViewer() {
        return this.graphicalViewer;
    }

    protected List getPropertyActions() {
        return this.propertyActions;
    }

    public List getSelectionActions() {
        return this.selectionActions;
    }

    protected SelectionSynchronizer getSelectionSynchronizer() {
        if (this.synchronizer == null) {
            this.synchronizer = new SelectionSynchronizer();
        }
        return this.synchronizer;
    }

    protected List getStackActions() {
        return this.stackActions;
    }

    public void hookGraphicalViewer() {
        this.getSelectionSynchronizer().addViewer((EditPartViewer)this.getGraphicalViewer());
        if (this.getWorkbenchPart() != null) {
            this.getWorkbenchPart().getSite().setSelectionProvider((ISelectionProvider)this.getGraphicalViewer());
        }
    }

    protected void init() {
        this.getCommandStack().addCommandStackEventListener((CommandStackEventListener)this);
        if (this.getWorkbenchPart() != null) {
            this.getWorkbenchPart().getSite().getWorkbenchWindow().getSelectionService().addSelectionListener((ISelectionListener)this);
            this.initializeActionRegistry();
        }
        this.createControl();
    }

    protected void initializeActionRegistry() {
        this.createActions();
        this.updateActions(this.propertyActions);
        this.updateActions(this.stackActions);
    }

    protected void initializeGraphicalViewer() {
    }

    public boolean isDirty() {
        return this.getCommandStack().isDirty();
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        IWorkbenchPart activePart;
        IWorkbenchPage page;
        IWorkbenchPartSite site;
        IWorkbenchPart workbenchPart = this.getWorkbenchPart();
        if (workbenchPart != null && (site = workbenchPart.getSite()) != null && (page = site.getPage()) != null && workbenchPart.equals(activePart = page.getActivePart())) {
            this.updateActions(this.selectionActions);
        }
    }

    protected void setActionRegistry(ActionRegistry registry) {
        this.actionRegistry = registry;
    }

    public void setEditDomain(DefaultEditDomain editDomain) {
        this.editDomain = editDomain;
    }

    public boolean setFocus() {
        return this.getGraphicalViewer().getControl().setFocus();
    }

    public void setGraphicalViewer(GraphicalViewer viewer) {
        this.getEditDomain().addViewer((EditPartViewer)viewer);
        this.graphicalViewer = viewer;
    }

    protected void updateActions(List actionIds) {
        ActionRegistry registry = this.getActionRegistry();
        Iterator iter = actionIds.iterator();
        while (iter.hasNext()) {
            IAction action = registry.getAction(iter.next());
            if (!(action instanceof UpdateAction)) continue;
            ((UpdateAction)action).update();
        }
    }

    protected abstract IWorkbenchPart getWorkbenchPart();

    private static class ActionIDList
    extends ArrayList {
        private ActionIDList() {
        }

        @Override
        public boolean add(Object o) {
            if (o instanceof IAction) {
                try {
                    IAction action = (IAction)o;
                    o = action.getId();
                    throw new IllegalArgumentException("Action IDs should be added to lists, not the action: " + action);
                }
                catch (IllegalArgumentException exc) {
                    exc.printStackTrace();
                }
            }
            return super.add(o);
        }
    }
}

