/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.examples.tutorial.features;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.custom.AbstractAsynchronousCustomFeature;

public class TutorialLongRunningCustomFeature
extends AbstractAsynchronousCustomFeature {
    public TutorialLongRunningCustomFeature(IFeatureProvider fp) {
        super(fp);
    }

    public String getName() {
        return "Long running custom feature";
    }

    public String getDescription() {
        return "Simple example for a long running feature that is executed in the background showing a progress monitor";
    }

    public boolean canExecute(ICustomContext context) {
        return true;
    }

    protected void execute(ICustomContext context, IProgressMonitor monitor) {
        monitor.beginTask("Long work", 10);
        int i = 0;
        while (i < 10) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                monitor.setCanceled(true);
            }
            monitor.worked(i);
            if (monitor.isCanceled()) break;
            ++i;
        }
        monitor.done();
    }
}

