/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui;

import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.Path;
import org.eclipse.egit.core.internal.Utils;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.RepositorySaveableFilter;
import org.eclipse.egit.ui.internal.UIIcons;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.components.RefContentProposal;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.bindings.Trigger;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.ISaveableFilter;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ContributionItemFactory;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.keys.IBindingService;
import org.eclipse.ui.services.IServiceLocator;

public class UIUtils {
    private static final String CSS_CLASS_KEY = "org.eclipse.e4.ui.css.CssClassName";
    private static final String CSS_DISABLED_KEY = "org.eclipse.e4.ui.css.disabled";
    public static final ImageDescriptor DEFAULT_FILE_IMG = PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FILE");
    private static final char[] VALUE_HELP_ACTIVATIONCHARS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123457890*@ <>".toCharArray();
    private static final Pattern SPACES = Pattern.compile("(?:\\v|\\h)+");
    public static final KeyStroke SUBMIT_KEY_STROKE = KeyStroke.getInstance((int)SWT.MOD1, (int)13);
    private static Map<String, SoftReference<ImageDescriptor>> extensionToDescriptor = new HashMap<String, SoftReference<ImageDescriptor>>();

    public static Font getFont(String id) {
        return PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getFontRegistry().get(id);
    }

    public static Font getBoldFont(String id) {
        return PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getFontRegistry().getBold(id);
    }

    public static Font getItalicFont(String id) {
        return PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getFontRegistry().getItalic(id);
    }

    public static int getControlIndent() {
        return 20;
    }

    public static Text createSelectableLabel(Composite parent, int style) {
        Text text = new Text(parent, style | 8);
        text.setBackground(text.getDisplay().getSystemColor(22));
        return text;
    }

    public static ControlDecoration addBulbDecorator(Control control, String tooltip) {
        ControlDecoration dec = new ControlDecoration(control, 16512);
        dec.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_CONTENT_PROPOSAL").getImage());
        dec.setShowOnlyOnFocus(true);
        dec.setShowHover(true);
        dec.setDescriptionText(tooltip);
        return dec;
    }

    public static Pattern createProposalPattern(String content) {
        Pattern pattern;
        String patternString = content;
        while (patternString.length() > 0 && patternString.charAt(0) == ' ') {
            patternString = patternString.substring(1);
        }
        patternString = Pattern.quote(patternString);
        if (!(patternString = patternString.replaceAll("\\x2A", ".*")).endsWith(".*")) {
            patternString = String.valueOf(patternString) + ".*";
        }
        try {
            pattern = Pattern.compile(patternString, 2);
        }
        catch (PatternSyntaxException e) {
            pattern = null;
        }
        return pattern;
    }

    public static IPreviousValueProposalHandler addPreviousValuesContentProposalToText(Text textField, final String preferenceKey) {
        KeyStroke stroke = UIUtils.getKeystrokeOfBestActiveBindingFor("org.eclipse.ui.edit.text.contentAssist.proposals");
        if (stroke == null) {
            UIUtils.addBulbDecorator((Control)textField, UIText.UIUtils_StartTypingForPreviousValuesMessage);
        } else {
            UIUtils.addBulbDecorator((Control)textField, NLS.bind((String)UIText.UIUtils_PressShortcutMessage, (Object)stroke.format()));
        }
        IContentProposalProvider cp = new IContentProposalProvider(){

            public IContentProposal[] getProposals(String contents, int position) {
                ArrayList<1> resultList = new ArrayList<1>();
                Pattern pattern = UIUtils.createProposalPattern(contents);
                String[] proposals = Activator.getDefault().getDialogSettings().getArray(preferenceKey);
                if (proposals != null) {
                    String[] stringArray = proposals;
                    int n = proposals.length;
                    int n2 = 0;
                    while (n2 < n) {
                        final String uriString = stringArray[n2];
                        if (pattern == null || pattern.matcher(uriString).matches()) {
                            IContentProposal propsal = new IContentProposal(){

                                public String getLabel() {
                                    return null;
                                }

                                public String getDescription() {
                                    return null;
                                }

                                public int getCursorPosition() {
                                    return 0;
                                }

                                public String getContent() {
                                    return uriString;
                                }
                            };
                            resultList.add(propsal);
                        }
                        ++n2;
                    }
                }
                return resultList.toArray(new IContentProposal[0]);
            }
        };
        ContentProposalAdapter adapter = new ContentProposalAdapter((Control)textField, (IControlContentAdapter)new TextContentAdapter(), cp, stroke, VALUE_HELP_ACTIVATIONCHARS);
        adapter.setProposalAcceptanceStyle(2);
        return () -> {
            String value = textField.getText();
            if (value.length() > 0) {
                IDialogSettings settings;
                String[] existingValues;
                if (value.length() > 2000) {
                    value = value.substring(0, 1999);
                }
                if ((existingValues = (settings = Activator.getDefault().getDialogSettings()).getArray(preferenceKey)) == null) {
                    existingValues = new String[]{value};
                    settings.put(preferenceKey, existingValues);
                } else {
                    ArrayList<String> values = new ArrayList<String>(existingValues.length + 1);
                    values.addAll(Arrays.asList(existingValues));
                    if (values.indexOf(value) == 0) {
                        return;
                    }
                    values.remove(value);
                    values.add(0, value);
                    while (values.size() > 10) {
                        values.remove(values.size() - 1);
                    }
                    settings.put(preferenceKey, values.toArray(new String[0]));
                }
            }
        };
    }

    public static final ExplicitContentProposalAdapter addRefContentProposalToText(Text textField, Repository repository, IContentProposalCandidateProvider<Ref> refListProvider, boolean upstream) {
        return UIUtils.addContentProposalToText(textField, refListProvider, (pattern, ref) -> {
            String shortenedName = Repository.shortenRefName((String)ref.getName());
            if (pattern != null && !pattern.matcher(ref.getName()).matches() && !pattern.matcher(shortenedName).matches()) {
                return null;
            }
            return new RefContentProposal(repository, (Ref)ref, upstream);
        }, null, UIText.UIUtils_StartTypingForRemoteRefMessage, UIText.UIUtils_PressShortcutForRemoteRefMessage);
    }

    @NonNull
    public static final <T> ExplicitContentProposalAdapter addContentProposalToText(Text textField, final IContentProposalCandidateProvider<T> candidateProvider, final IContentProposalFactory<T> factory, final Function<String, Pattern> patternProvider, String startTypingMessage, String shortcutMessage) {
        KeyStroke stroke = UIUtils.getKeystrokeOfBestActiveBindingFor("org.eclipse.ui.edit.text.contentAssist.proposals");
        if (stroke == null) {
            UIUtils.addBulbDecorator((Control)textField, startTypingMessage);
        } else {
            UIUtils.addBulbDecorator((Control)textField, NLS.bind((String)shortcutMessage, (Object)stroke.format()));
        }
        IContentProposalProvider cp = new IContentProposalProvider(){

            public IContentProposal[] getProposals(String contents, int position) {
                ArrayList<IContentProposal> resultList = new ArrayList<IContentProposal>();
                Collection candidates = candidateProvider.getCandidates();
                if (candidates == null) {
                    return null;
                }
                Pattern pattern = patternProvider != null ? (Pattern)patternProvider.apply(contents) : UIUtils.createProposalPattern(contents);
                for (Object candidate : candidates) {
                    IContentProposal proposal = factory.getProposal(pattern, candidate);
                    if (proposal == null) continue;
                    resultList.add(proposal);
                }
                return resultList.toArray(new IContentProposal[0]);
            }
        };
        ExplicitContentProposalAdapter adapter = new ExplicitContentProposalAdapter((Control)textField, (IControlContentAdapter)new TextContentAdapter(), cp, stroke, VALUE_HELP_ACTIVATIONCHARS);
        adapter.setProposalAcceptanceStyle(2);
        return adapter;
    }

    public static void setEnabledRecursively(Control control, boolean enable) {
        control.setEnabled(enable);
        if (control instanceof Composite) {
            Control[] controlArray = ((Composite)control).getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                UIUtils.setEnabledRecursively(child, enable);
                ++n2;
            }
        }
    }

    public static void hookDisposal(Widget widget, final Resource resource) {
        if (widget == null || resource == null) {
            return;
        }
        widget.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                resource.dispose();
            }
        });
    }

    public static void hookDisposal(Widget widget, final ResourceManager resources) {
        if (widget == null || resources == null) {
            return;
        }
        widget.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                resources.dispose();
            }
        });
    }

    public static ImageDescriptor getEditorImage(String path) {
        ImageDescriptor descriptor;
        if (path == null || path.length() <= 0) {
            return DEFAULT_FILE_IMG;
        }
        String fileName = new Path(path).lastSegment();
        if (fileName == null) {
            return DEFAULT_FILE_IMG;
        }
        IEditorRegistry registry = PlatformUI.getWorkbench().getEditorRegistry();
        IEditorDescriptor defaultEditor = registry.getDefaultEditor(fileName);
        if (defaultEditor != null) {
            return defaultEditor.getImageDescriptor();
        }
        int extensionIndex = fileName.lastIndexOf(46);
        if (extensionIndex < 0) {
            return DEFAULT_FILE_IMG;
        }
        String key = fileName.substring(extensionIndex);
        SoftReference<ImageDescriptor> cached = extensionToDescriptor.get(key);
        if (cached != null && (descriptor = cached.get()) != null) {
            return descriptor;
        }
        descriptor = registry.getImageDescriptor(fileName);
        extensionToDescriptor.put(key, new SoftReference<ImageDescriptor>(descriptor));
        return descriptor;
    }

    public static ToolBar addExpansionItems(ToolBar toolbar, final AbstractTreeViewer viewer) {
        ToolItem collapseItem = new ToolItem(toolbar, 8);
        Image collapseImage = UIIcons.COLLAPSEALL.createImage();
        UIUtils.hookDisposal((Widget)collapseItem, (Resource)collapseImage);
        collapseItem.setImage(collapseImage);
        collapseItem.setToolTipText(UIText.UIUtils_CollapseAll);
        collapseItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UIUtils.collapseAll(viewer);
            }
        });
        ToolItem expandItem = new ToolItem(toolbar, 8);
        Image expandImage = UIIcons.EXPAND_ALL.createImage();
        UIUtils.hookDisposal((Widget)expandItem, (Resource)expandImage);
        expandItem.setImage(expandImage);
        expandItem.setToolTipText(UIText.UIUtils_ExpandAll);
        expandItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UIUtils.expandAll(viewer);
            }
        });
        return toolbar;
    }

    public static IDialogSettings getDialogBoundSettings(Class<?> clazz) {
        return UIUtils.getDialogSettings(String.valueOf(clazz.getName()) + ".dialogBounds");
    }

    public static IDialogSettings getDialogSettings(String sectionName) {
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(sectionName);
        if (section == null) {
            section = settings.addNewSection(sectionName);
        }
        return section;
    }

    public static boolean isUsable(Viewer viewer) {
        return viewer != null && UIUtils.isUsable(viewer.getControl());
    }

    public static boolean isUsable(Control control) {
        return control != null && !control.isDisposed();
    }

    public static void associateLabel(Control control, final Label label) {
        control.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = label.getText();
            }
        });
    }

    public static void executeCommand(IHandlerService service, String id) {
        UIUtils.executeCommand(service, id, null);
    }

    public static void executeCommand(IHandlerService service, String id, Event event) {
        try {
            service.executeCommand(id, event);
        }
        catch (ExecutionException | NotEnabledException | NotHandledException | NotDefinedException e) {
            Activator.handleError(e.getMessage(), e, false);
        }
    }

    public static boolean isSubmitKeyEvent(KeyEvent event) {
        return (event.stateMask & SWT.MODIFIER_MASK) != 0 && event.keyCode == SUBMIT_KEY_STROKE.getNaturalKey();
    }

    public static boolean saveAllEditors(Repository repository) {
        return UIUtils.saveAllEditors(repository, null);
    }

    public static boolean saveAllEditors(Repository repository, String cancelConfirmationQuestion) {
        RepositorySaveableFilter filter;
        IWorkbenchWindow window;
        IWorkbench workbench = PlatformUI.getWorkbench();
        boolean success = workbench.saveAll((IShellProvider)(window = workbench.getActiveWorkbenchWindow()), (IRunnableContext)window, (ISaveableFilter)(filter = new RepositorySaveableFilter(repository)), true);
        if (success && cancelConfirmationQuestion != null && filter.isAnythingSaved()) {
            String[] buttons = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL};
            MessageDialog dialog = new MessageDialog(window.getShell(), UIText.CancelAfterSaveDialog_Title, null, cancelConfirmationQuestion, 3, buttons, 0){

                protected int getShellStyle() {
                    return 0x10010820 | 8.getDefaultOrientation();
                }
            };
            int choice = dialog.open();
            if (choice != 1) {
                return false;
            }
        }
        return success;
    }

    public static MenuManager createShowInMenu(IWorkbenchWindow workbenchWindow) {
        MenuManager showInSubMenu = new MenuManager(UIUtils.getShowInMenuLabel());
        showInSubMenu.add(ContributionItemFactory.VIEWS_SHOW_IN.create(workbenchWindow));
        return showInSubMenu;
    }

    private static String getShowInMenuLabel() {
        String keyBinding;
        IBindingService bindingService = (IBindingService)Adapters.adapt((Object)PlatformUI.getWorkbench(), IBindingService.class);
        if (bindingService != null && (keyBinding = bindingService.getBestActiveBindingFormattedFor("org.eclipse.ui.navigate.showInQuickMenu")) != null) {
            return String.valueOf(UIText.UIUtils_ShowInMenuLabel) + '\t' + keyBinding;
        }
        return UIText.UIUtils_ShowInMenuLabel;
    }

    @Nullable
    public static KeyStroke getKeystrokeOfBestActiveBindingFor(String commandId) {
        IBindingService bindingService = (IBindingService)Adapters.adapt((Object)PlatformUI.getWorkbench(), IBindingService.class);
        if (bindingService == null) {
            return null;
        }
        TriggerSequence ts = bindingService.getBestActiveBindingFor(commandId);
        if (ts == null) {
            return null;
        }
        Trigger[] triggers = ts.getTriggers();
        if (triggers.length == 1 && triggers[0] instanceof KeyStroke) {
            return (KeyStroke)triggers[0];
        }
        return null;
    }

    public static void setButtonLayoutData(Button button) {
        GC gc = new GC((Drawable)button);
        gc.setFont(JFaceResources.getDialogFont());
        FontMetrics fontMetrics = gc.getFontMetrics();
        gc.dispose();
        GridData data = new GridData(256);
        int widthHint = Dialog.convertHorizontalDLUsToPixels((FontMetrics)fontMetrics, (int)61);
        Point minSize = button.computeSize(-1, -1, true);
        data.widthHint = Math.max(widthHint, minSize.x);
        button.setLayoutData((Object)data);
    }

    public static void notifySelectionChangedWithCurrentSelection(ISelectionListener selectionListener, IServiceLocator serviceLocator) {
        IHandlerService handlerService = (IHandlerService)serviceLocator.getService(IHandlerService.class);
        IEvaluationContext state = handlerService.getCurrentState();
        Object partObject = state.getVariable("activePart");
        if (!(partObject instanceof IWorkbenchPart)) {
            partObject = state.getVariable("activeEditor");
        }
        Object selectionObject = state.getVariable("selection");
        if (partObject instanceof IWorkbenchPart) {
            IWorkbenchPart part = (IWorkbenchPart)partObject;
            StructuredSelection selection = selectionObject instanceof ISelection ? (ISelection)selectionObject : StructuredSelection.EMPTY;
            selectionListener.selectionChanged(part, (ISelection)selection);
        }
    }

    public static void expandAll(AbstractTreeViewer viewer) {
        viewer.getControl().setRedraw(false);
        try {
            viewer.expandAll();
        }
        finally {
            viewer.getControl().setRedraw(true);
        }
    }

    public static void collapseAll(AbstractTreeViewer viewer) {
        viewer.getControl().setRedraw(false);
        try {
            viewer.collapseAll();
        }
        finally {
            viewer.getControl().setRedraw(true);
        }
    }

    public static String menuText(String text, int maxLength) {
        String result = Utils.shortenText((String)text, (int)maxLength);
        return SPACES.matcher(result).replaceAll(" ");
    }

    public static void setCssStyling(Widget widget, boolean enabled) {
        widget.setData(CSS_DISABLED_KEY, (Object)(!enabled ? 1 : 0));
    }

    public static void setCssClass(Widget widget, String cssClass) {
        widget.setData(CSS_CLASS_KEY, (Object)cssClass);
    }

    public static class ExplicitContentProposalAdapter
    extends ContentProposalAdapter {
        public ExplicitContentProposalAdapter(Control control, IControlContentAdapter controlContentAdapter, IContentProposalProvider proposalProvider, KeyStroke keyStroke, char[] autoActivationCharacters) {
            super(control, controlContentAdapter, proposalProvider, keyStroke, autoActivationCharacters);
        }

        public void openProposalPopup() {
            super.openProposalPopup();
        }
    }

    public static interface IContentProposalCandidateProvider<T> {
        public Collection<? extends T> getCandidates();
    }

    public static interface IContentProposalFactory<T> {
        public IContentProposal getProposal(Pattern var1, T var2);
    }

    public static interface IPreviousValueProposalHandler {
        public void updateProposals();
    }
}

