/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ibm.db2.luw.catalog.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.enablement.ibm.catalog.util.CatalogLoadUtil;
import org.eclipse.datatools.enablement.ibm.db2.DB2PluginActivator;
import org.eclipse.datatools.enablement.ibm.util.CloneUtil;
import org.eclipse.datatools.enablement.ibm.util.DBReverseProvider;
import org.eclipse.datatools.modelbase.sql.accesscontrol.AuthorizationIdentifier;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.tables.BaseTable;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.datatools.modelbase.sql.tables.ViewTable;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.FeatureMapUtil;

public class DatabaseREProvider {
    public static final int EXCLUDE_INDEXES = 1;
    public static final int EXCLUDE_TRIGGERS = 2;
    public static final int GENERATE_IMPLICIT_RELATIONSHIPS = 4;
    public static final int EXCLUDE_TABLES = 8;
    public static final int EXCLUDE_ROUTINES = 16;
    public static final int EXCLUDE_USER_DEFINED_TYPE = 32;
    public static final int EXCLUDE_SEQUENCE = 64;
    public static final int EXCLUDE_TABLESPACE = 128;
    public static final int EXCLUDE_VIEWS = 256;
    public static final int EXCLUDE_SYNONYMS = 512;
    public static final int GENERATE_IMPLICIT_PKS = 1024;
    public static final int EXCLUDE_ACCESS_CONTROL = 2048;
    public static final int EXCLUDE_FGAC = 4096;
    public static final String LOAD_PROPERTY = "LOAD_PROPERTY";
    public static final String IS_BATCH_LOAD = "BATCH_LOAD";
    public static final String LOAD_OPTIONS = "LOAD_OPTIONS";
    public static final String OWNER_LOAD_OPTION = "OWNER_LOAD_OPTION";
    public static final String OwnerFilterSelected = "isOwnerFilterSelected";
    private boolean isOwnerForRE;
    protected Database database = null;
    protected int options;
    protected List<String> columnNamesToIgnore;
    protected IProgressMonitor monitor;
    protected EObject[] objectsToRE;
    protected DBReverseProvider provider;

    protected void handleDatabaseVendors() {
        if (this.database.getVendor().equals("Derby")) {
            this.buildVertex(this.objectsToRE);
        } else {
            this.cloneVertex(this.objectsToRE);
        }
        this.refresh(this.objectsToRE);
    }

    public void buildVertex(EObject[] objsToRE) {
        EObject[] targets = new EObject[objsToRE.length];
        int i = 0;
        while (i < objsToRE.length) {
            targets[i] = this.database;
            ++i;
        }
        EObject[] cloned = this.buildVertex(targets, objsToRE);
        int i2 = 0;
        while (i2 < cloned.length) {
            if (cloned[i2] instanceof Database) {
                Database db = (Database)cloned[i2];
                if ((this.options & 0x800) == 2048) {
                    for (AuthorizationIdentifier aId : db.getAuthorizationIds()) {
                        aId.getReceivedPrivilege().clear();
                        aId.getReceivedRoleAuthorization().clear();
                    }
                    db.getAuthorizationIds().clear();
                }
            } else if (cloned[i2] instanceof Schema) {
                Schema schema = (Schema)cloned[i2];
                if ((this.options & 3) != 0) {
                    for (Table t : schema.getTables()) {
                        if ((this.options & 2) == 2) {
                            t.getTriggers().clear();
                        }
                        if ((this.options & 1) != 1) continue;
                        t.getIndex().clear();
                    }
                }
            }
            ++i2;
        }
    }

    protected EObject[] buildVertex(EObject[] parent, EObject[] object) {
        EObject[] newObjects = CloneUtil.clone((EObject[])parent, (EObject[])object);
        return newObjects;
    }

    protected void generateImplicitPK(Database db) {
        CatalogLoadUtil.generateImplicitPK((Database)db);
    }

    protected void cloneVertex(EObject[] objsToRE) {
        DBReverseProvider reProvider;
        EObject[] targets = new EObject[objsToRE.length];
        EObject[] newObjects = new EObject[1];
        int i = 0;
        while (i < objsToRE.length) {
            targets[i] = this.database;
            ++i;
        }
        if (!this.isOwnerForRE) {
            newObjects = CloneUtil.clone((EObject[])targets, (EObject[])objsToRE);
        }
        if ((reProvider = this.getDBReverseProvider(this.database)) != null) {
            reProvider.reverseEngineer(this.database, this.options, objsToRE, this.monitor);
            if (newObjects != null) {
                reProvider.removeNeedlessObjects(newObjects, this.options);
            }
        } else if (newObjects != null) {
            this.removeNeedlessObjects(newObjects);
        }
    }

    protected void removeNeedlessObjects(EObject[] clonedObjects) {
        int i = 0;
        while (i < clonedObjects.length) {
            if (clonedObjects[i] instanceof Database) {
                Database db = (Database)clonedObjects[i];
                if ((this.options & 0x800) == 2048) {
                    for (AuthorizationIdentifier aId : db.getAuthorizationIds()) {
                        aId.getReceivedPrivilege().clear();
                        aId.getReceivedRoleAuthorization().clear();
                    }
                    db.getAuthorizationIds().clear();
                }
            } else if (clonedObjects[i] instanceof Schema) {
                Schema schema = (Schema)clonedObjects[i];
                if ((this.options & 0x10) == 16) {
                    schema.getRoutines().clear();
                }
                if ((this.options & 0x20) == 32) {
                    schema.getUserDefinedTypes().clear();
                }
                if ((this.options & 0x40) == 64) {
                    schema.getSequences().clear();
                }
                if ((this.options & 8) == 8 || (this.options & 0x100) == 256 || (this.options & 0x200) == 512) {
                    ArrayList<Table> needRemovedTables = new ArrayList<Table>();
                    for (Table t : schema.getTables()) {
                        if ((this.options & 8) == 8) {
                            if (!(t instanceof BaseTable)) continue;
                            needRemovedTables.add(t);
                            continue;
                        }
                        if ((this.options & 0x100) != 256 || !(t instanceof ViewTable)) continue;
                        needRemovedTables.add(t);
                    }
                    schema.getTables().removeAll(needRemovedTables);
                }
                if ((this.options & 8) != 8 && ((this.options & 2) == 2 || (this.options & 1) == 1)) {
                    for (Table t : schema.getTables()) {
                        if ((this.options & 2) == 2) {
                            t.getTriggers().clear();
                        }
                        if ((this.options & 1) != 1) continue;
                        t.getIndex().clear();
                    }
                }
            }
            ++i;
        }
    }

    protected void refresh(EObject[] objsToRE) {
        int i = 0;
        while (i < objsToRE.length) {
            EObject obj = objsToRE[i];
            if (obj instanceof ICatalogObject) {
                ((ICatalogObject)obj).refresh();
            }
            ++i;
        }
    }

    protected void setLoadProperties(EObject db) {
        if (!(db instanceof SQLObject)) {
            return;
        }
        EAnnotation eAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
        eAnnotation.setSource(LOAD_PROPERTY);
        eAnnotation.getDetails().put((Object)IS_BATCH_LOAD, (Object)Boolean.TRUE.toString());
        eAnnotation.getDetails().put((Object)LOAD_OPTIONS, (Object)Integer.toString(this.options));
        ((SQLObject)db).getEAnnotations().add((Object)eAnnotation);
    }

    protected void resetLoadProperties(EObject db) {
        if (!(db instanceof SQLObject)) {
            return;
        }
        EList eAnnotations = ((SQLObject)db).getEAnnotations();
        for (EAnnotation eAnnotation : eAnnotations) {
            String source = eAnnotation.getSource();
            if (source == null || !source.equals(LOAD_PROPERTY)) continue;
            eAnnotations.remove((Object)eAnnotation);
            return;
        }
    }

    protected void resetOwnerProperties(EObject ownerObject) {
        if (!(ownerObject instanceof SQLObject)) {
            return;
        }
        EList eAnnotations = ((SQLObject)ownerObject).getEAnnotations();
        for (EAnnotation eAnnotation : eAnnotations) {
            String source = eAnnotation.getSource();
            if (source == null || !source.equals(OWNER_LOAD_OPTION)) continue;
            eAnnotations.remove((Object)eAnnotation);
            return;
        }
    }

    private static void copyAttribute(EObject src, EObject target) {
        EClass c = src.eClass();
        for (EAttribute a : c.getEAllAttributes()) {
            if (!a.isChangeable() || a.isDerived()) continue;
            DatabaseREProvider.copyAttribute(a, src, target);
        }
    }

    private static void copyAttribute(EAttribute attribute, EObject src, EObject target) {
        if (!src.eIsSet((EStructuralFeature)attribute)) {
            return;
        }
        if (FeatureMapUtil.isFeatureMap((EStructuralFeature)attribute)) {
            FeatureMap srcFeatureMap = (FeatureMap)src.eGet((EStructuralFeature)attribute);
            FeatureMap tgtFeatureMap = (FeatureMap)src.eGet((EStructuralFeature)attribute);
            for (FeatureMap.Entry entry : srcFeatureMap) {
                EStructuralFeature feature = entry.getEStructuralFeature();
                if (feature instanceof EReference) continue;
                tgtFeatureMap.add((Object)entry);
            }
        } else if (attribute.isMany()) {
            ((Collection)target.eGet((EStructuralFeature)attribute)).addAll((Collection)src.eGet((EStructuralFeature)attribute));
        } else {
            target.eSet((EStructuralFeature)attribute, src.eGet((EStructuralFeature)attribute));
        }
    }

    protected DBReverseProvider getDBReverseProvider(Database db) {
        if (this.provider != null) {
            return this.provider;
        }
        String dbProduct = db.getVendor();
        IExtensionRegistry pluginRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = pluginRegistry.getExtensionPoint("com.ibm.datatools.core", "dbReverseProvider");
        IExtension[] extensions = extensionPoint.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < configElements.length) {
                String product;
                if (configElements[j].getName().equals("provider") && (product = configElements[j].getAttribute("product")).equals(dbProduct)) {
                    String version = configElements[j].getAttribute("version");
                    try {
                        this.provider = (DBReverseProvider)configElements[j].createExecutableExtension("class");
                    }
                    catch (CoreException e) {
                        Status status = new Status(4, RDBCorePlugin.getDefault().getBundle().getSymbolicName(), 4, "The error was detected when creating the db reverse provider for " + product + " " + version, (Throwable)e);
                        DB2PluginActivator.getInstance().getLog().log((IStatus)status);
                    }
                    break;
                }
                ++j;
            }
            ++i;
        }
        return this.provider;
    }
}

